/*
 * Decompiled with CFR 0.152.
 */
package tools.docrobot;

import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.fest.swing.core.BasicRobot;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;

public abstract class ImageWatermarkRobot {
    protected String screenshotFilename;
    protected JFrame sf;

    public ImageWatermarkRobot(String screenshotFilename) {
        this.screenshotFilename = screenshotFilename;
    }

    public void run() {
        long start = System.currentTimeMillis();
        Robot robot = BasicRobot.robotWithNewAwtHierarchy();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                ImageWatermarkRobot.this.sf = new JFrame("Sample frame");
                ImageWatermarkRobot.this.apply();
                ImageWatermarkRobot.this.sf.setSize(238, 261);
                ImageWatermarkRobot.this.sf.setLayout(new FlowLayout(1));
                JButton defButton = new JButton("default");
                JButton disButton = new JButton("disabled");
                JButton regButton = new JButton("regular");
                disButton.setEnabled(false);
                ImageWatermarkRobot.this.sf.add(defButton);
                ImageWatermarkRobot.this.sf.add(disButton);
                ImageWatermarkRobot.this.sf.add(regButton);
                ImageWatermarkRobot.this.sf.getRootPane().setDefaultButton(defButton);
                BufferedImage iconImage = new BufferedImage(1, 1, 2);
                ImageWatermarkRobot.this.sf.setIconImage(iconImage);
                ImageWatermarkRobot.this.sf.setLocationRelativeTo(null);
                ImageWatermarkRobot.this.sf.setDefaultCloseOperation(3);
                ImageWatermarkRobot.this.sf.setVisible(true);
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                ImageWatermarkRobot.this.makeScreenshot();
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                ImageWatermarkRobot.this.sf.dispose();
            }
        });
        robot.waitForIdle();
        long end = System.currentTimeMillis();
        System.out.println(this.getClass().getSimpleName() + " : " + (end - start) + "ms");
    }

    protected abstract void apply();

    public void makeScreenshot() {
        BufferedImage bi = new BufferedImage(this.sf.getWidth(), this.sf.getHeight(), 2);
        Graphics g = bi.getGraphics();
        this.sf.paint(g);
        try {
            ImageIO.write((RenderedImage)bi, "png", new File(this.screenshotFilename));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

