/*
 * Decompiled with CFR 0.152.
 */
package tools.docrobot;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.fest.swing.core.BasicRobot;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.timing.Pause;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import test.check.SampleFrame;

public abstract class SkinRobot {
    protected SubstanceSkin skin;
    protected String screenshotFilename;
    protected SampleFrame sf;

    public SkinRobot(SubstanceSkin skin, String screenshotFilename) {
        this.skin = skin;
        this.screenshotFilename = screenshotFilename;
    }

    public void run() {
        long start = System.currentTimeMillis();
        Robot robot = BasicRobot.robotWithNewAwtHierarchy();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SubstanceLookAndFeel.setSkin(SkinRobot.this.skin);
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SkinRobot.this.sf = new SampleFrame();
                SkinRobot.this.sf.setIconImage((Image)SubstanceImageCreator.getColorSchemeImage(null, new ImageIcon(SkinRobot.class.getClassLoader().getResource("test/resource/image-x-generic.png")), SubstanceLookAndFeel.getCurrentSkin(SkinRobot.this.sf.getRootPane()).getActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE), 0.0f));
                SkinRobot.this.sf.setSize(338, 245);
                SkinRobot.this.sf.setLocationRelativeTo(null);
                SkinRobot.this.sf.setDefaultCloseOperation(3);
                SkinRobot.this.sf.setVisible(true);
            }
        });
        robot.waitForIdle();
        JButton defaultButton = (JButton)GuiActionRunner.execute((GuiQuery)new GuiQuery<JButton>(){

            protected JButton executeInEDT() throws Throwable {
                return SkinRobot.this.sf.getRootPane().getDefaultButton();
            }
        });
        robot.moveMouse((Component)defaultButton);
        robot.waitForIdle();
        Pause.pause((long)1000L);
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SkinRobot.this.makeScreenshot(1);
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SkinRobot.this.sf.switchToLastTab();
            }
        });
        robot.waitForIdle();
        robot.moveMouse(new Point(0, 0));
        robot.waitForIdle();
        Pause.pause((long)1000L);
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SkinRobot.this.makeScreenshot(2);
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SkinRobot.this.sf.dispose();
            }
        });
        robot.waitForIdle();
        long end = System.currentTimeMillis();
        System.out.println(this.getClass().getSimpleName() + " : " + (end - start) + "ms");
    }

    public void makeScreenshot(int count) {
        BufferedImage bi = new BufferedImage(this.sf.getWidth(), this.sf.getHeight(), 2);
        Graphics g = bi.getGraphics();
        this.sf.paint(g);
        try {
            File output = new File(this.screenshotFilename + count + ".png");
            output.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)bi, "png", output);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

