/*
 * Decompiled with CFR 0.152.
 */
package tools.electra;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.GeminiSkin;
import test.SubstanceLogo;
import tools.common.JImageComponent;
import tools.electra.JElectrifiedImageComponent;

public class Electra
extends JFrame {
    public Electra() {
        super("Electra");
        this.setIconImage(SubstanceLogo.getLogoImage((SubstanceColorScheme)SubstanceLookAndFeel.getCurrentSkin(this.getRootPane()).getColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.setSize(1200, 800);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setLayout(new GridLayout(1, 2));
        final JImageComponent jic = new JImageComponent(false);
        jic.setLegend(new String[]{"\tDrag and drop an image file from local disk"});
        jic.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(SubstanceLookAndFeel.getCurrentSkin(c).getColorScheme(c, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED).getMidColor());
                g2d.drawLine(x + width - 2, y, x + width - 2, y + height - 1);
                g2d.setComposite(AlphaComposite.SrcOver.derive(0.8f));
                g2d.setColor(SubstanceLookAndFeel.getCurrentSkin(c).getColorScheme(c, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED).getExtraLightColor().brighter());
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                g2d.dispose();
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 2);
            }
        });
        this.add(jic);
        final JElectrifiedImageComponent jeic = new JElectrifiedImageComponent(jic);
        JPanel electrifiedContainer = new JPanel(new BorderLayout());
        JScrollPane scroller = new JScrollPane(jeic, 20, 31);
        scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        electrifiedContainer.add((Component)scroller, "Center");
        JButton saveElectrified = new JButton("save");
        saveElectrified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        File originalFile = jic.getOriginalFile();
                        if (originalFile != null) {
                            jeic.save(originalFile);
                        }
                    }
                });
            }
        });
        JPanel controls = new JPanel(new FlowLayout(4));
        controls.add(saveElectrified);
        electrifiedContainer.add((Component)controls, "South");
        this.add(electrifiedContainer);
        jic.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point absPoint = jic.toOriginalImageCoords(e.getX(), e.getY());
                    jeic.addZoomBubble(absPoint.x, absPoint.y, 80);
                }
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                SubstanceLookAndFeel.setSkin(new GeminiSkin());
                new Electra().setVisible(true);
            }
        });
    }
}

