/*
 * Decompiled with CFR 0.152.
 */
package tools.jitterbug;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.pushingpixels.lafwidget.utils.RenderingUtils;

public class JColorComponent
extends JComponent {
    private JRadioButton radio;
    private Color selectedColor;
    private String name;
    private ColorVisualizer visualizer;

    public JColorComponent(String name, Color color) {
        this.radio = new JRadioButton(name);
        this.radio.setFocusable(false);
        this.selectedColor = color;
        this.visualizer = new ColorVisualizer();
        this.setLayout(new ColorComponentLayout());
        this.add(this.radio);
        this.add(this.visualizer);
    }

    public String getEncodedColor() {
        return "#" + JColorComponent.encodeColorComponent(this.selectedColor.getRed()) + JColorComponent.encodeColorComponent(this.selectedColor.getGreen()) + JColorComponent.encodeColorComponent(this.selectedColor.getBlue());
    }

    private static String encodeColorComponent(int colorComp) {
        String hex = "0123456789ABCDEF";
        return "" + hex.charAt(colorComp / 16) + hex.charAt(colorComp % 16);
    }

    public JRadioButton getRadio() {
        return this.radio;
    }

    public void setColor(Color color, boolean firePropertyChange) {
        Color old = this.selectedColor;
        this.selectedColor = color;
        this.repaint();
        if (firePropertyChange) {
            this.firePropertyChange("selectedColor", old, this.selectedColor);
        }
    }

    public Color getColor() {
        return this.selectedColor;
    }

    public boolean isDefined() {
        return this.selectedColor != null;
    }

    private class ColorComponentLayout
    implements LayoutManager {
        private ColorComponentLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            JColorComponent cc = (JColorComponent)parent;
            int width = cc.getWidth();
            int height = cc.getHeight();
            ColorVisualizer cv = cc.visualizer;
            Dimension cvPref = cv.getPreferredSize();
            cv.setBounds(width - cvPref.width, 0, cvPref.width, height);
            cc.radio.setBounds(0, 0, width - cvPref.width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JColorComponent cc = (JColorComponent)parent;
            ColorVisualizer cv = cc.visualizer;
            Dimension cvPref = cv.getPreferredSize();
            return new Dimension(100 + cvPref.width, cvPref.height);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private class ColorVisualizer
    extends JComponent {
        boolean isRollover;

        public ColorVisualizer() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!ColorVisualizer.this.isEnabled()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JColorComponent.this.radio.setSelected(true);
                            Color selected = JColorChooser.showDialog(ColorVisualizer.this, "Color chooser", JColorComponent.this.selectedColor);
                            if (selected != null) {
                                Color old = JColorComponent.this.selectedColor;
                                JColorComponent.this.selectedColor = selected;
                                JColorComponent.this.firePropertyChange("selectedColor", old, JColorComponent.this.selectedColor);
                            }
                        }
                    });
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!ColorVisualizer.this.isEnabled()) {
                        return;
                    }
                    ColorVisualizer.this.isRollover = true;
                    ColorVisualizer.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!ColorVisualizer.this.isEnabled()) {
                        return;
                    }
                    ColorVisualizer.this.isRollover = false;
                    ColorVisualizer.this.repaint();
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setToolTipText("Open color chooser and change the color");
            this.isRollover = false;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            RenderingUtils.installDesktopHints(g2d, this);
            g2d.setFont(UIManager.getFont("Label.font"));
            if (JColorComponent.this.selectedColor != null) {
                g2d.setColor(JColorComponent.this.selectedColor);
                g2d.fillRect(2, 2, 100, this.getHeight() - 4);
                g2d.setStroke(new BasicStroke(this.isRollover ? 2.5f : 1.0f));
                g2d.setColor(JColorComponent.this.selectedColor.darker());
                g2d.drawRect(2, 2, 99, this.getHeight() - 5);
                g2d.setColor(Color.black);
                g2d.drawString(JColorComponent.this.getEncodedColor(), 108, (this.getHeight() + g2d.getFontMetrics().getHeight()) / 2 - g2d.getFontMetrics().getDescent());
            } else {
                g2d.setColor(this.isEnabled() ? Color.gray : Color.lightGray);
                g2d.drawString("click to choose", 5, (this.getHeight() + g2d.getFontMetrics().getHeight()) / 2 - g2d.getFontMetrics().getDescent());
            }
            g2d.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 25);
        }
    }
}

