/*
 * Decompiled with CFR 0.152.
 */
package tools.jitterbug;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import tools.jitterbug.JColorComponent;
import tools.jitterbug.StateChangeEvent;
import tools.jitterbug.StateChangeListener;

public class JColorSchemeComponent
extends JPanel {
    private JCheckBox isLight;
    private JLabel name;
    private JColorComponent ultraLight;
    private JColorComponent extraLight;
    private JColorComponent light;
    private JColorComponent mid;
    private JColorComponent dark;
    private JColorComponent ultraDark;
    private JColorComponent foreground;
    private ButtonGroup bg;

    public JColorSchemeComponent() {
        FormLayout layout = new FormLayout("fill:pref", "");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(layout, (JPanel)this);
        this.bg = new ButtonGroup();
        this.ultraLight = this.createColorComponent("ultra light");
        this.extraLight = this.createColorComponent("extra light");
        this.light = this.createColorComponent("light");
        this.mid = this.createColorComponent("mid");
        this.dark = this.createColorComponent("dark");
        this.ultraDark = this.createColorComponent("ultra dark");
        this.foreground = this.createColorComponent("foreground");
        JPanel header = new JPanel();
        FormLayout hLayout = new FormLayout("fill:pref,2dlu,fill:min(150px;pref):grow,4dlu,right:pref", "");
        DefaultFormBuilder headerBuilder = new DefaultFormBuilder(hLayout, header);
        this.name = new JLabel("");
        this.name.setFont(this.name.getFont().deriveFont(1));
        this.isLight = new JCheckBox("light");
        this.isLight.setSelected(true);
        this.isLight.setFocusable(false);
        headerBuilder.append((Component)new JLabel("Display name:"));
        headerBuilder.append((Component)this.name);
        headerBuilder.append((Component)this.isLight);
        this.isLight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorSchemeComponent.this.fireStateChanged(StateChangeEvent.StateChangeType.MODIFIED);
            }
        });
        formBuilder.append((Component)header);
        formBuilder.append((Component)this.ultraLight);
        formBuilder.append((Component)this.extraLight);
        formBuilder.append((Component)this.light);
        formBuilder.append((Component)this.mid);
        formBuilder.append((Component)this.dark);
        formBuilder.append((Component)this.ultraDark);
        formBuilder.append((Component)this.foreground);
    }

    private JColorComponent createColorComponent(String label) {
        JColorComponent result = new JColorComponent(label, null);
        result.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedColor".equals(evt.getPropertyName())) {
                    JColorSchemeComponent.this.fireStateChanged(StateChangeEvent.StateChangeType.MODIFIED);
                }
            }
        });
        this.bg.add(result.getRadio());
        return result;
    }

    public void setContent(SubstanceColorScheme scheme) {
        this.setEnabled(true);
        this.ultraLight.setColor(scheme.getUltraLightColor(), false);
        this.extraLight.setColor(scheme.getExtraLightColor(), false);
        this.light.setColor(scheme.getLightColor(), false);
        this.mid.setColor(scheme.getMidColor(), false);
        this.dark.setColor(scheme.getDarkColor(), false);
        this.ultraDark.setColor(scheme.getUltraDarkColor(), false);
        this.foreground.setColor(scheme.getForegroundColor(), false);
        this.isLight.setSelected(!scheme.isDark());
        this.name.setText(scheme.getDisplayName());
        this.fireStateChanged(StateChangeEvent.StateChangeType.INITIALIZED);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEnabledChildren(this, enabled);
    }

    private void setEnabledChildren(Component c, boolean enabled) {
        if (c instanceof Container) {
            Container cont = (Container)c;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                child.setEnabled(enabled);
                this.setEnabledChildren(child, enabled);
            }
        }
    }

    public void clearContent() {
        this.setEnabled(false);
        this.ultraLight.setColor(null, false);
        this.extraLight.setColor(null, false);
        this.light.setColor(null, false);
        this.mid.setColor(null, false);
        this.dark.setColor(null, false);
        this.ultraDark.setColor(null, false);
        this.foreground.setColor(null, false);
        this.isLight.setSelected(true);
        this.name.setText("");
        this.fireStateChanged(StateChangeEvent.StateChangeType.RESET);
    }

    public boolean isLight() {
        return this.isLight.isSelected();
    }

    public String getDisplayName() {
        return this.name.getText();
    }

    public Color getUltraLightColor() {
        return this.ultraLight.getColor();
    }

    public Color getExtraLightColor() {
        return this.extraLight.getColor();
    }

    public Color getLightColor() {
        return this.light.getColor();
    }

    public Color getMidColor() {
        return this.mid.getColor();
    }

    public Color getDarkColor() {
        return this.dark.getColor();
    }

    public Color getUltraDarkColor() {
        return this.ultraDark.getColor();
    }

    public Color getForegroundColor() {
        return this.foreground.getColor();
    }

    public String getEncoded() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDisplayName() + " {\n");
        sb.append("\tkind=" + (this.isLight() ? "Light" : "Dark") + "\n");
        sb.append("\tcolorUltraLight=" + this.ultraLight.getEncodedColor() + "\n");
        sb.append("\tcolorExtraLight=" + this.extraLight.getEncodedColor() + "\n");
        sb.append("\tcolorLight=" + this.light.getEncodedColor() + "\n");
        sb.append("\tcolorMid=" + this.mid.getEncodedColor() + "\n");
        sb.append("\tcolorDark=" + this.dark.getEncodedColor() + "\n");
        sb.append("\tcolorUltraDark=" + this.ultraDark.getEncodedColor() + "\n");
        sb.append("\tcolorForeground=" + this.foreground.getEncodedColor() + "\n");
        sb.append("}\n");
        return sb.toString();
    }

    public void addStateChangeListener(StateChangeListener l) {
        this.listenerList.add(StateChangeListener.class, l);
    }

    public void removeStateChangeListener(StateChangeListener l) {
        this.listenerList.remove(StateChangeListener.class, l);
    }

    protected void fireStateChanged(StateChangeEvent.StateChangeType stateChangeType) {
        Object[] listeners = this.listenerList.getListenerList();
        StateChangeEvent event = new StateChangeEvent(this, stateChangeType);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StateChangeListener.class) continue;
            ((StateChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public boolean isDefined() {
        if (this.name.getText() == null || this.name.getText().trim().length() == 0) {
            return false;
        }
        if (!this.ultraLight.isDefined()) {
            return false;
        }
        if (!this.extraLight.isDefined()) {
            return false;
        }
        if (!this.light.isDefined()) {
            return false;
        }
        if (!this.mid.isDefined()) {
            return false;
        }
        if (!this.dark.isDefined()) {
            return false;
        }
        if (!this.ultraDark.isDefined()) {
            return false;
        }
        return this.foreground.isDefined();
    }

    public JColorComponent getSelectedColorComponent() {
        if (this.ultraLight.getRadio().isSelected()) {
            return this.ultraLight;
        }
        if (this.extraLight.getRadio().isSelected()) {
            return this.extraLight;
        }
        if (this.light.getRadio().isSelected()) {
            return this.light;
        }
        if (this.mid.getRadio().isSelected()) {
            return this.mid;
        }
        if (this.dark.getRadio().isSelected()) {
            return this.dark;
        }
        if (this.ultraDark.getRadio().isSelected()) {
            return this.ultraDark;
        }
        if (this.foreground.getRadio().isSelected()) {
            return this.foreground;
        }
        return null;
    }
}

