/*
 * Decompiled with CFR 0.152.
 */
package tools.jitterbug;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;

public class JColorSchemeList
extends JComponent {
    private SubstanceSkin.ColorSchemes schemes = new SubstanceSkin.ColorSchemes();
    private JList schemeList = new JList();
    private JPanel cardPanel;
    private ColorSchemeListModel schemeListModel = new ColorSchemeListModel();
    static final String LIST = "List";
    static final String INSTRUCTIONAL = "Instructional";
    private File schemesFile;
    private boolean isModified;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton renameButton;
    private JButton deleteButton;

    public JColorSchemeList() {
        this.schemeList.setModel(this.schemeListModel);
        this.schemeList.setCellRenderer(new ColorSchemeListRenderer());
        this.schemeList.setSelectionMode(0);
        this.schemeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selected = JColorSchemeList.this.schemeList.getSelectedValue();
                JColorSchemeList.this.firePropertyChange("selectedColorScheme", null, selected);
            }
        });
        JPanel bottomButtonsPanel = new JPanel(new FlowLayout(4));
        JButton addColorScheme = new JButton();
        addColorScheme.setToolTipText("Adds a new color scheme");
        addColorScheme.setIcon(new ImageIcon(JColorSchemeList.class.getClassLoader().getResource("tools/jitterbug/add.png")));
        addColorScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String newName = JColorSchemeList.this.getNewColorSchemeName(null);
                        if (newName == null) {
                            return;
                        }
                        Color[] colors = new Color[]{Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.black};
                        SubstanceColorScheme newScheme = SubstanceColorSchemeUtilities.getLightColorScheme(newName, colors);
                        JColorSchemeList.this.schemes.add(newScheme);
                        JColorSchemeList.this.schemeListModel.fireContentsChanged();
                        JColorSchemeList.this.schemeList.setSelectedValue(newScheme, true);
                        JColorSchemeList.this.setModified(true);
                    }
                });
            }
        });
        bottomButtonsPanel.add(addColorScheme);
        bottomButtonsPanel.add(Box.createHorizontalStrut(10));
        this.moveUpButton = new JButton();
        this.moveUpButton.setToolTipText("Moves the currently selected color scheme up");
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setIcon(new ImageIcon(JColorSchemeList.class.getClassLoader().getResource("tools/jitterbug/arrow_up.png")));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceColorScheme selected = (SubstanceColorScheme)JColorSchemeList.this.schemeList.getSelectedValue();
                        JColorSchemeList.this.schemes.switchWithPrevious(selected.getDisplayName());
                        JColorSchemeList.this.schemeListModel.fireContentsChanged();
                        JColorSchemeList.this.schemeList.setSelectedValue(selected, true);
                        JColorSchemeList.this.setModified(true);
                    }
                });
            }
        });
        bottomButtonsPanel.add(this.moveUpButton);
        this.moveDownButton = new JButton();
        this.moveDownButton.setToolTipText("Moves the currently selected color scheme down");
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setIcon(new ImageIcon(JColorSchemeList.class.getClassLoader().getResource("tools/jitterbug/arrow_down.png")));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceColorScheme selected = (SubstanceColorScheme)JColorSchemeList.this.schemeList.getSelectedValue();
                        JColorSchemeList.this.schemes.switchWithNext(selected.getDisplayName());
                        JColorSchemeList.this.schemeListModel.fireContentsChanged();
                        JColorSchemeList.this.schemeList.setSelectedValue(selected, true);
                        JColorSchemeList.this.setModified(true);
                    }
                });
            }
        });
        bottomButtonsPanel.add(this.moveDownButton);
        bottomButtonsPanel.add(Box.createHorizontalStrut(10));
        this.renameButton = new JButton();
        this.renameButton.setToolTipText("Rename the currently selected color scheme");
        this.renameButton.setEnabled(false);
        this.renameButton.setIcon(new ImageIcon(JColorSchemeList.class.getClassLoader().getResource("tools/jitterbug/chart_line_edit.png")));
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceColorScheme selected = (SubstanceColorScheme)JColorSchemeList.this.schemeList.getSelectedValue();
                        String newName = JColorSchemeList.this.getNewColorSchemeName(selected.getDisplayName());
                        if (newName == null) {
                            return;
                        }
                        if (newName.equals(selected.getDisplayName())) {
                            return;
                        }
                        boolean isLight = !selected.isDark();
                        Color ultraDark = selected.getUltraDarkColor();
                        Color dark = selected.getDarkColor();
                        Color mid = selected.getMidColor();
                        Color light = selected.getLightColor();
                        Color extraLight = selected.getExtraLightColor();
                        Color ultraLight = selected.getUltraLightColor();
                        Color foreground = selected.getForegroundColor();
                        Color[] colors = new Color[]{ultraLight, extraLight, light, mid, dark, ultraDark, foreground};
                        SubstanceColorScheme renamedScheme = isLight ? SubstanceColorSchemeUtilities.getLightColorScheme(newName, colors) : SubstanceColorSchemeUtilities.getDarkColorScheme(newName, colors);
                        JColorSchemeList.this.schemes.replace(selected.getDisplayName(), renamedScheme);
                        JColorSchemeList.this.schemeListModel.fireContentsChanged();
                        JColorSchemeList.this.schemeList.getSelectionModel().clearSelection();
                        JColorSchemeList.this.schemeList.setSelectedValue(renamedScheme, true);
                        JColorSchemeList.this.setModified(true);
                    }
                });
            }
        });
        bottomButtonsPanel.add(this.renameButton);
        this.deleteButton = new JButton();
        this.deleteButton.setToolTipText("Removes the currently selected color scheme");
        this.deleteButton.setEnabled(false);
        this.deleteButton.setIcon(new ImageIcon(JColorSchemeList.class.getClassLoader().getResource("tools/jitterbug/delete.png")));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceColorScheme selected = (SubstanceColorScheme)JColorSchemeList.this.schemeList.getSelectedValue();
                        JColorSchemeList.this.schemes.delete(selected.getDisplayName());
                        JColorSchemeList.this.schemeListModel.fireContentsChanged();
                        JColorSchemeList.this.schemeList.getSelectionModel().clearSelection();
                        JColorSchemeList.this.setModified(true);
                    }
                });
            }
        });
        bottomButtonsPanel.add(this.deleteButton);
        this.schemeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = JColorSchemeList.this.schemeList.getSelectedIndex();
                boolean hasSelection = selectedIndex >= 0;
                JColorSchemeList.this.renameButton.setEnabled(hasSelection);
                JColorSchemeList.this.deleteButton.setEnabled(hasSelection);
                JColorSchemeList.this.moveUpButton.setEnabled(hasSelection && selectedIndex > 0);
                JColorSchemeList.this.moveDownButton.setEnabled(hasSelection && selectedIndex < JColorSchemeList.this.schemes.size() - 1);
            }
        });
        JPanel mainControlPanel = new JPanel(new BorderLayout());
        mainControlPanel.add((Component)new JScrollPane(this.schemeList), "Center");
        mainControlPanel.add((Component)bottomButtonsPanel, "South");
        this.cardPanel = new JPanel(new CardLayout());
        JTextArea textArea = new JTextArea("List of color schemes. Use one of the following:\n   * Drag a .colorschemes file here\n   * Click the \"New\" button below");
        textArea.setBorder(new EmptyBorder(10, 8, 0, 8));
        textArea.setEditable(false);
        textArea.setOpaque(false);
        textArea.setRows(9);
        this.cardPanel.add((Component)textArea, INSTRUCTIONAL);
        this.cardPanel.add((Component)mainControlPanel, LIST);
        this.setLayout(new BorderLayout());
        this.add((Component)this.cardPanel, "Center");
        this.setPreferredSize(textArea.getPreferredSize());
    }

    public void setColorSchemeList(File file) {
        if (!this.checkModifiedStateAndSaveIfNecessary()) {
            return;
        }
        try {
            this.schemesFile = file;
            this.schemes = file != null ? SubstanceSkin.getColorSchemes(file.toURI().toURL()) : new SubstanceSkin.ColorSchemes();
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, LIST);
            this.schemeListModel.fireContentsChanged();
            if (file == null) {
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.renameButton.setEnabled(false);
            }
            this.setModified(false);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public boolean checkModifiedStateAndSaveIfNecessary() {
        if (!this.isModified) {
            return true;
        }
        String fileName = this.schemesFile == null ? "Unsaved" : this.schemesFile.getName();
        int userSelection = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), "Do you want to save the changes to '" + fileName + "'?", "Modified contents", 1);
        if (userSelection == 2) {
            return false;
        }
        if (userSelection == 0) {
            if (this.schemesFile != null) {
                this.save();
            } else {
                this.saveAs();
            }
        }
        return true;
    }

    private String getFileNameForSaving() {
        JFileChooser jfc = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Color scheme files", "colorschemes");
        jfc.setFileFilter(filter);
        int returnVal = jfc.showSaveDialog(SwingUtilities.getWindowAncestor(this));
        if (returnVal == 0) {
            String res = jfc.getSelectedFile().getAbsolutePath();
            if (!res.endsWith(".colorschemes")) {
                res = res + ".colorschemes";
            }
            return res;
        }
        return null;
    }

    private String getNewColorSchemeName(String nameToStartWith) {
        String result = JOptionPane.showInputDialog(SwingUtilities.getWindowAncestor(this), "Type the color scheme name", nameToStartWith);
        if (result == null) {
            return null;
        }
        if (result.equals(nameToStartWith)) {
            return result;
        }
        result = result.trim();
        Pattern pattern = Pattern.compile("[a-zA-Z ]+");
        Matcher matcher = pattern.matcher(result);
        if (!matcher.matches()) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), "Only use letters and spaces", "Name invalid", 0);
            return null;
        }
        SubstanceColorScheme existing = this.schemes.get(result);
        if (existing != null) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), "Name already exists", "Name clash", 0);
            return null;
        }
        return result;
    }

    public void save() {
        this.saveAs(this.schemesFile);
    }

    public void saveAs() {
        String fileName = this.getFileNameForSaving();
        if (fileName != null) {
            File file = new File(fileName);
            this.saveAs(file);
        }
    }

    private void saveAs(File file) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
            for (int i = 0; i < this.schemes.size(); ++i) {
                SubstanceColorScheme colorScheme = this.schemes.get(i);
                String encodedColorScheme = colorScheme.toString();
                printStream.println(encodedColorScheme);
                printStream.println();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (printStream != null) {
            printStream.close();
        }
        this.schemesFile = file;
        this.setModified(false);
    }

    public void setModified(boolean isModified) {
        if (this.isModified == isModified) {
            return;
        }
        boolean old = this.isModified;
        this.isModified = isModified;
        this.firePropertyChange("modified", old, isModified);
    }

    public File getCurrentFile() {
        return this.schemesFile;
    }

    public void updateColorScheme(SubstanceColorScheme colorScheme) {
        SubstanceColorScheme existing = this.schemes.get(colorScheme.getDisplayName());
        if (existing == null) {
            throw new IllegalArgumentException("Color scheme " + colorScheme.getDisplayName() + " not found");
        }
        this.schemes.replace(colorScheme.getDisplayName(), colorScheme);
    }

    public boolean isModified() {
        return this.isModified;
    }

    class ColorSchemeListRenderer
    extends SubstanceDefaultListCellRenderer {
        ColorSchemeListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SubstanceColorScheme scheme = (SubstanceColorScheme)value;
            return super.getListCellRendererComponent(list, (Object)scheme.getDisplayName(), index, isSelected, cellHasFocus);
        }
    }

    class ColorSchemeListModel
    extends AbstractListModel {
        ColorSchemeListModel() {
        }

        @Override
        public int getSize() {
            return JColorSchemeList.this.schemes == null ? 0 : JColorSchemeList.this.schemes.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (JColorSchemeList.this.schemes == null) {
                return null;
            }
            return JColorSchemeList.this.schemes.get(index);
        }

        void fireContentsChanged() {
            this.fireContentsChanged(JColorSchemeList.this.schemeList, 0, this.getSize());
        }
    }
}

