/*
 * Decompiled with CFR 0.152.
 */
package tools.uidebug;

import java.awt.Color;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseColorScheme;

public class ColorBlindColorScheme
extends BaseColorScheme {
    public double[][] _rgbToLms = new double[][]{{0.05059983, 0.08585369, 0.0095242}, {0.01893033, 0.08925308, 0.01370054}, {0.00292202, 0.00975732, 0.07145979}};
    public double[][] _lmsToRgb = new double[][]{{30.830854, -29.832659, 1.610474}, {-6.481468, 17.715578, -2.532642}, {-0.37569, -1.199062, 14.273846}};
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private SubstanceColorScheme origScheme;

    public ColorBlindColorScheme(SubstanceColorScheme origScheme, BlindnessKind kind) {
        super(kind.name() + " " + origScheme.getDisplayName(), origScheme.isDark());
        this.origScheme = origScheme;
        this.foregroundColor = ColorBlindColorScheme.getColorBlindColor(origScheme.getForegroundColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainUltraDarkColor = ColorBlindColorScheme.getColorBlindColor(origScheme.getUltraDarkColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainDarkColor = ColorBlindColorScheme.getColorBlindColor(origScheme.getDarkColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainMidColor = ColorBlindColorScheme.getColorBlindColor(origScheme.getMidColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainLightColor = ColorBlindColorScheme.getColorBlindColor(origScheme.getLightColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainExtraLightColor = ColorBlindColorScheme.getColorBlindColor(origScheme.getExtraLightColor(), this._rgbToLms, kind, this._lmsToRgb);
        this.mainUltraLightColor = ColorBlindColorScheme.getColorBlindColor(origScheme.getUltraLightColor(), this._rgbToLms, kind, this._lmsToRgb);
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public SubstanceColorScheme getOrigScheme() {
        return this.origScheme;
    }

    private static Color getColorBlindColor(Color orig, double[][] rgbToLms, BlindnessKind kind, double[][] lmsToRgb) {
        double r = orig.getRed();
        double g = orig.getGreen();
        double b = orig.getBlue();
        double[] rgbOrig = new double[]{r, g, b};
        double[] lms = ColorBlindColorScheme.mult3(rgbToLms, rgbOrig);
        double tmp = 0.0;
        double[] anchor = new double[]{0.08008, 0.1579, 0.5897, 0.1284, 0.2237, 0.3636, 0.9856, 0.7325, 0.001079, 0.0914, 0.007009, 0.0};
        double[] rgbAnchor = new double[]{rgbToLms[0][0] + rgbToLms[0][1] + rgbToLms[0][2], rgbToLms[1][0] + rgbToLms[1][1] + rgbToLms[1][2], rgbToLms[2][0] + rgbToLms[2][1] + rgbToLms[2][2]};
        switch (kind) {
            case PROTANOPIA: {
                double a1 = rgbAnchor[1] * anchor[8] - rgbAnchor[2] * anchor[7];
                double b1 = rgbAnchor[2] * anchor[6] - rgbAnchor[0] * anchor[8];
                double c1 = rgbAnchor[0] * anchor[7] - rgbAnchor[1] * anchor[6];
                double a2 = rgbAnchor[1] * anchor[2] - rgbAnchor[2] * anchor[1];
                double b2 = rgbAnchor[2] * anchor[0] - rgbAnchor[0] * anchor[2];
                double c2 = rgbAnchor[0] * anchor[1] - rgbAnchor[1] * anchor[0];
                double inflection = rgbAnchor[2] / rgbAnchor[1];
                tmp = lms[2] / lms[1];
                if (tmp < inflection) {
                    lms[0] = -(b1 * lms[1] + c1 * lms[2]) / a1;
                    break;
                }
                lms[0] = -(b2 * lms[1] + c2 * lms[2]) / a2;
                break;
            }
            case DEUTERANOPIA: {
                double a1 = rgbAnchor[1] * anchor[8] - rgbAnchor[2] * anchor[7];
                double b1 = rgbAnchor[2] * anchor[6] - rgbAnchor[0] * anchor[8];
                double c1 = rgbAnchor[0] * anchor[7] - rgbAnchor[1] * anchor[6];
                double a2 = rgbAnchor[1] * anchor[2] - rgbAnchor[2] * anchor[1];
                double b2 = rgbAnchor[2] * anchor[0] - rgbAnchor[0] * anchor[2];
                double c2 = rgbAnchor[0] * anchor[1] - rgbAnchor[1] * anchor[0];
                double inflection = rgbAnchor[2] / rgbAnchor[0];
                tmp = lms[2] / lms[0];
                if (tmp < inflection) {
                    lms[1] = -(a1 * lms[0] + c1 * lms[2]) / b1;
                    break;
                }
                lms[1] = -(a2 * lms[0] + c2 * lms[2]) / b2;
                break;
            }
            case TRITANOPIA: {
                double a1 = rgbAnchor[1] * anchor[11] - rgbAnchor[2] * anchor[10];
                double b1 = rgbAnchor[2] * anchor[9] - rgbAnchor[0] * anchor[11];
                double c1 = rgbAnchor[0] * anchor[10] - rgbAnchor[1] * anchor[9];
                double a2 = rgbAnchor[1] * anchor[5] - rgbAnchor[2] * anchor[4];
                double b2 = rgbAnchor[2] * anchor[3] - rgbAnchor[0] * anchor[5];
                double c2 = rgbAnchor[0] * anchor[4] - rgbAnchor[1] * anchor[3];
                double inflection = rgbAnchor[1] / rgbAnchor[0];
                tmp = lms[1] / lms[0];
                if (tmp < inflection) {
                    lms[2] = -(a1 * lms[0] + b1 * lms[1]) / c1;
                    break;
                }
                lms[2] = -(a2 * lms[0] + b2 * lms[1]) / c2;
                break;
            }
        }
        double[] rgbCb = ColorBlindColorScheme.mult3(lmsToRgb, lms);
        double nr = Math.min(255.0, Math.max(0.0, rgbCb[0]));
        double ng = Math.min(255.0, Math.max(0.0, rgbCb[1]));
        double nb = Math.min(255.0, Math.max(0.0, rgbCb[2]));
        return new Color((int)nr, (int)ng, (int)nb);
    }

    private static double[] mult3(double[][] matrix, double[] vector) {
        double[] res = new double[]{matrix[0][0] * vector[0] + matrix[0][1] * vector[1] + matrix[0][2] * vector[2], matrix[1][0] * vector[0] + matrix[1][1] * vector[1] + matrix[1][2] * vector[2], matrix[2][0] * vector[0] + matrix[2][1] * vector[1] + matrix[2][2] * vector[2]};
        return res;
    }

    public static enum BlindnessKind {
        PROTANOPIA,
        DEUTERANOPIA,
        TRITANOPIA;

    }
}

