/*
 * Decompiled with CFR 0.152.
 */
package tools.uidebug;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.lafwidget.LafWidgetAdapter;
import org.pushingpixels.substance.api.SubstanceConstants;

public class ScrollBarUiDebugger
extends LafWidgetAdapter<JScrollBar> {
    protected MouseListener substanceDebugUiListener;

    @Override
    public boolean requiresCustomLafSupport() {
        return false;
    }

    @Override
    public void installListeners() {
        this.substanceDebugUiListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.process(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.process(e);
            }

            protected void process(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem policyNone = new JMenuItem("Empty policy");
                    policyNone.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.NONE));
                    popup.add(policyNone);
                    JMenuItem policyOpposite = new JMenuItem("Opposite policy");
                    policyOpposite.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE));
                    popup.add(policyOpposite);
                    JMenuItem policyAdjacent = new JMenuItem("Adjacent policy");
                    policyAdjacent.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.ADJACENT));
                    popup.add(policyAdjacent);
                    JMenuItem policyMultiple = new JMenuItem("Multiple policy");
                    policyMultiple.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE));
                    popup.add(policyMultiple);
                    JMenuItem policyMultipleBoth = new JMenuItem("Multiple both policy");
                    policyMultipleBoth.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE_BOTH));
                    popup.add(policyMultipleBoth);
                    popup.show(ScrollBarUiDebugger.this.jcomp, e.getX(), e.getY());
                }
            }
        };
        ((JScrollBar)this.jcomp).addMouseListener(this.substanceDebugUiListener);
    }

    @Override
    public void uninstallListeners() {
        if (this.substanceDebugUiListener != null) {
            ((JScrollBar)this.jcomp).removeMouseListener(this.substanceDebugUiListener);
            this.substanceDebugUiListener = null;
        }
    }

    protected class PolicyChanger
    implements ActionListener {
        protected SubstanceConstants.ScrollPaneButtonPolicyKind newPolicy;

        public PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind newPolicy) {
            this.newPolicy = newPolicy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JScrollPane)((JScrollBar)ScrollBarUiDebugger.this.jcomp).getParent()).putClientProperty("substancelaf.scrollPaneButtonsPolicy", (Object)PolicyChanger.this.newPolicy);
                    ((JScrollBar)ScrollBarUiDebugger.this.jcomp).getParent().doLayout();
                    ((JScrollBar)ScrollBarUiDebugger.this.jcomp).getParent().repaint();
                }
            });
        }
    }
}

