/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.triplea.ui.MapData;
import games.strategy.util.JTextAreaOptionPane;
import games.strategy.util.PointFileReaderWriter;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import util.image.FileSave;

public class AutoPlacementFinder {
    private static int PLACEWIDTH = 48;
    private static int PLACEHEIGHT = 48;
    private static MapData s_mapData;
    private static boolean placeDimensionsSet;
    private static double unit_zoom_percent;
    private static int unit_width;
    private static int unit_height;
    private static File s_mapFolderLocation;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private static final String TRIPLEA_UNIT_ZOOM = "triplea.unit.zoom";
    private static final String TRIPLEA_UNIT_WIDTH = "triplea.unit.width";
    private static final String TRIPLEA_UNIT_HEIGHT = "triplea.unit.height";
    private static final JTextAreaOptionPane textOptionPane;

    public static String[] getProperties() {
        return new String[]{TRIPLEA_MAP_FOLDER, TRIPLEA_UNIT_ZOOM, TRIPLEA_UNIT_WIDTH, TRIPLEA_UNIT_HEIGHT};
    }

    public static void main(String[] args) {
        AutoPlacementFinder.handleCommandLineArgs(args);
        JOptionPane.showMessageDialog(null, new JLabel("<html>This is the AutoPlacementFinder, it will create a place.txt file for you. <br>In order to run this, you must already have created a centers.txt file and a polygons.txt file, <br>and you must have already created the map directory structure in its final place.<br>Example: the map folder should have a name, with the 2 text files already in that folder, and <br>the folder should be located in your users\\yourname\\triplea\\maps\\ directory.<br><br>The program will ask for the folder name (just the name, not the full path).<br>Then it will ask for unit scale (unit zoom) level [normally between 0.5 and 1.0]<br>Then it will ask for the unit image size when not zoomed [normally 48x48].<br><br>If you want to have less, or more, room around the edges of your units, you can change the unit size.<br><br>When done, the program will attempt to make placements for all territories on your map.<br>However, it doesn't do a good job with thin or small territories, or islands, so it is a very good idea<br>to use the PlacementPicker to check all placements and redo some of them by hand.</html>"));
        AutoPlacementFinder.calculate();
    }

    static void calculate() {
        String mapDir;
        HashMap<String, List<Point>> m_placements;
        block36: {
            File file;
            m_placements = new HashMap<String, List<Point>>();
            String string = mapDir = s_mapFolderLocation == null ? AutoPlacementFinder.getMapDirectory() : s_mapFolderLocation.getName();
            if (mapDir == null) {
                System.out.println("You need to specify a map name for this to work");
                System.out.println("Shutting down");
                System.exit(0);
            }
            if (!(file = new File(GameRunner2.getUserMapsFolder() + File.separator + mapDir + File.separator + "map.properties")).exists()) {
                file = new File(GameRunner2.getRootFolder() + File.separator + "maps" + File.separator + mapDir + File.separator + "map.properties");
            }
            if (file.exists() && s_mapFolderLocation == null) {
                s_mapFolderLocation = file.getParentFile();
            }
            if (!placeDimensionsSet) {
                try {
                    int result;
                    if (!file.exists()) break block36;
                    double scale = unit_zoom_percent;
                    int width = unit_width;
                    int height = unit_height;
                    boolean found = false;
                    String scaleProperty = "units.scale=";
                    String widthProperty = "units.width=";
                    String heightProperty = "units.height=";
                    FileReader reader = new FileReader(file);
                    LineNumberReader reader2 = new LineNumberReader(reader);
                    int i = 0;
                    while (true) {
                        reader2.setLineNumber(i);
                        String line = reader2.readLine();
                        if (line == null) break;
                        if (line.contains("units.scale=")) {
                            try {
                                scale = Double.parseDouble(line.substring(line.indexOf("units.scale=") + "units.scale=".length()).trim());
                                found = true;
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                        if (line.contains("units.width=")) {
                            try {
                                width = Integer.parseInt(line.substring(line.indexOf("units.width=") + "units.width=".length()).trim());
                                found = true;
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                        if (!line.contains("units.height=")) continue;
                        try {
                            height = Integer.parseInt(line.substring(line.indexOf("units.height=") + "units.height=".length()).trim());
                            found = true;
                        }
                        catch (NumberFormatException ex) {}
                    }
                    reader2.close();
                    ++i;
                    if (found && (result = JOptionPane.showConfirmDialog(new JPanel(), "A map.properties file was found in the map's folder, \r\n do you want to use the file to supply the info for the placement box size? \r\n Zoom = " + scale + ",  Width = " + width + ",  Height = " + height + ",    Result = (" + (int)(scale * (double)width) + "x" + (int)(scale * (double)height) + ")", "File Suggestion", 1)) == 0) {
                        unit_zoom_percent = scale;
                        PLACEWIDTH = (int)(unit_zoom_percent * (double)width);
                        PLACEHEIGHT = (int)(unit_zoom_percent * (double)height);
                        placeDimensionsSet = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (!placeDimensionsSet || JOptionPane.showConfirmDialog(new JPanel(), "Placement Box Size already set (" + PLACEWIDTH + "x" + PLACEHEIGHT + "), " + "do you wish to continue with this?\r\nSelect Yes to continue, Select No to override and change the size.", "Placement Box Size", 0) == 1) {
            try {
                String height;
                String result = AutoPlacementFinder.getUnitsScale();
                try {
                    unit_zoom_percent = Double.parseDouble(result.toLowerCase());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                String width = JOptionPane.showInputDialog(null, (Object)"Enter the unit's image width in pixels (unscaled / without zoom).\r\n(e.g. 48)");
                if (width != null) {
                    try {
                        PLACEWIDTH = (int)(unit_zoom_percent * (double)Integer.parseInt(width));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if ((height = JOptionPane.showInputDialog(null, (Object)"Enter the unit's image height in pixels (unscaled / without zoom).\r\n(e.g. 48)")) != null) {
                    try {
                        PLACEHEIGHT = (int)(unit_zoom_percent * (double)Integer.parseInt(height));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            s_mapData = new MapData(mapDir);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, new JLabel("Could not find map. Make sure it is in finalized location and contains centers.txt and polygons.txt"));
            System.out.println("Caught Exception.");
            System.out.println("Could be due to some missing text files.");
            System.out.println("Or due to the map folder not being in the right location.");
            ex.printStackTrace();
            System.exit(0);
        }
        textOptionPane.show();
        textOptionPane.appendNewLine("Place Dimensions in pixels, being used: " + PLACEWIDTH + "x" + PLACEHEIGHT + "\r\n");
        textOptionPane.appendNewLine("Calculating, this may take a while...\r\n");
        for (String name : s_mapData.getTerritories()) {
            List<Point> points;
            if (s_mapData.hasContainedTerritory(name)) {
                HashSet<Polygon> containedPolygons = new HashSet<Polygon>();
                for (String containedName : s_mapData.getContainedTerritory(name)) {
                    containedPolygons.addAll(s_mapData.getPolygons(containedName));
                }
                points = AutoPlacementFinder.getPlacementsStartingAtTopLeft(s_mapData.getPolygons(name), s_mapData.getBoundingRect(name), s_mapData.getCenter(name), containedPolygons);
                m_placements.put(name, points);
            } else {
                points = AutoPlacementFinder.getPlacementsStartingAtMiddle(s_mapData.getPolygons(name), s_mapData.getBoundingRect(name), s_mapData.getCenter(name));
                m_placements.put(name, points);
            }
            textOptionPane.appendNewLine(name + ": " + points.size());
        }
        textOptionPane.appendNewLine("\r\nAll Finished!");
        textOptionPane.countDown();
        try {
            String fileName = new FileSave("Where To Save place.txt ?", "place.txt", s_mapFolderLocation).getPathString();
            if (fileName == null) {
                textOptionPane.appendNewLine("You chose not to save, Shutting down");
                textOptionPane.dispose();
                System.exit(0);
            }
            PointFileReaderWriter.writeOneToMany(new FileOutputStream(fileName), m_placements);
            textOptionPane.appendNewLine("Data written to :" + new File(fileName).getCanonicalPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            textOptionPane.dispose();
            System.exit(0);
        }
        textOptionPane.dispose();
        System.exit(0);
    }

    private static String getMapDirectory() {
        String mapDir = JOptionPane.showInputDialog(null, (Object)"Enter the map name (ie. folder name)");
        if (mapDir != null) {
            return mapDir;
        }
        return null;
    }

    private static String getUnitsScale() {
        String unitsScale = JOptionPane.showInputDialog(null, (Object)"Enter the unit's scale (zoom).\r\n(e.g. 1.25, 1, 0.875, 0.8333, 0.75, 0.6666, 0.5625, 0.5)");
        if (unitsScale != null) {
            return unitsScale;
        }
        return "1";
    }

    static List<Point> getPlacementsStartingAtMiddle(Collection<Polygon> countryPolygons, Rectangle bounding, Point center) {
        ArrayList<Rectangle2D> placementRects = new ArrayList<Rectangle2D>();
        ArrayList<Point> placementPoints = new ArrayList<Point>();
        Rectangle2D.Double place = new Rectangle2D.Double(center.x, center.y, PLACEHEIGHT, PLACEWIDTH);
        int x = center.x - PLACEHEIGHT / 2;
        int y = center.y - PLACEWIDTH / 2;
        int step = 1;
        for (int i = 0; i < 2 * Math.max(bounding.width, bounding.height); ++i) {
            int j;
            for (j = 0; j < Math.abs(step); ++j) {
                x = step > 0 ? ++x : --x;
                AutoPlacementFinder.isPlacement(countryPolygons, Collections.<Polygon>emptySet(), placementRects, placementPoints, place, x, y);
            }
            for (j = 0; j < Math.abs(step); ++j) {
                y = step > 0 ? ++y : --y;
                AutoPlacementFinder.isPlacement(countryPolygons, Collections.<Polygon>emptySet(), placementRects, placementPoints, place, x, y);
            }
            step = (step = -step) > 0 ? ++step : --step;
            if (placementPoints.size() > 50) break;
        }
        if (placementPoints.isEmpty()) {
            int defaultx = center.x - PLACEHEIGHT / 2;
            int defaulty = center.y - PLACEWIDTH / 2;
            placementPoints.add(new Point(defaultx, defaulty));
        }
        return placementPoints;
    }

    static List<Point> getPlacementsStartingAtTopLeft(Collection<Polygon> countryPolygons, Rectangle bounding, Point center, Collection<Polygon> containedCountryPolygons) {
        ArrayList<Rectangle2D> placementRects = new ArrayList<Rectangle2D>();
        ArrayList<Point> placementPoints = new ArrayList<Point>();
        Rectangle2D.Double place = new Rectangle2D.Double(center.x, center.y, PLACEHEIGHT, PLACEWIDTH);
        for (int x = bounding.x + 1; x < bounding.width + bounding.x; ++x) {
            for (int y = bounding.y + 1; y < bounding.height + bounding.y; ++y) {
                AutoPlacementFinder.isPlacement(countryPolygons, containedCountryPolygons, placementRects, placementPoints, place, x, y);
            }
            if (placementPoints.size() > 50) break;
        }
        if (placementPoints.isEmpty()) {
            int defaultx = center.x - PLACEHEIGHT / 2;
            int defaulty = center.y - PLACEWIDTH / 2;
            placementPoints.add(new Point(defaultx, defaulty));
        }
        return placementPoints;
    }

    private static void isPlacement(Collection<Polygon> countryPolygons, Collection<Polygon> containedCountryPolygons, List<Rectangle2D> placementRects, List<Point> placementPoints, Rectangle2D place, int x, int y) {
        place.setFrame(x, y, PLACEWIDTH, PLACEHEIGHT);
        if (AutoPlacementFinder.containedIn(place, countryPolygons) && !AutoPlacementFinder.intersectsOneOf(place, placementRects) && !AutoPlacementFinder.containedIn(place, containedCountryPolygons) && !AutoPlacementFinder.intersectsOneOf(place, containedCountryPolygons)) {
            placementPoints.add(new Point((int)place.getX(), (int)place.getY()));
            Rectangle2D.Double newRect = new Rectangle2D.Double();
            newRect.setFrame(place);
            placementRects.add(newRect);
        }
    }

    public static boolean containedIn(Rectangle2D r, Collection<Polygon> shapes) {
        for (Shape shape : shapes) {
            if (!shape.contains(r)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersectsOneOf(Rectangle2D r, Collection<? extends Shape> shapes) {
        if (shapes.isEmpty()) {
            return false;
        }
        for (Shape shape : shapes) {
            if (!shape.intersects(r)) continue;
            return true;
        }
        return false;
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        String heightString;
        String widthString;
        String zoomString;
        String[] properties = AutoPlacementFinder.getProperties();
        if (args.length == 1) {
            String value = args[0].startsWith(TRIPLEA_UNIT_ZOOM) ? AutoPlacementFinder.getValue(args[0]) : args[0];
            try {
                Double.parseDouble(value);
                System.setProperty(TRIPLEA_UNIT_ZOOM, value);
            }
            catch (Exception ex) {}
        } else if (args.length == 2) {
            String value0 = args[0].startsWith(TRIPLEA_UNIT_WIDTH) ? AutoPlacementFinder.getValue(args[0]) : args[0];
            try {
                Integer.parseInt(value0);
                System.setProperty(TRIPLEA_UNIT_WIDTH, value0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String value1 = args[0].startsWith(TRIPLEA_UNIT_HEIGHT) ? AutoPlacementFinder.getValue(args[1]) : args[1];
            try {
                Integer.parseInt(value1);
                System.setProperty(TRIPLEA_UNIT_HEIGHT, value1);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean usagePrinted = false;
        for (String arg2 : args) {
            boolean found = false;
            String arg = arg2;
            int indexOf = arg.indexOf(61);
            if (indexOf > 0) {
                arg = arg.substring(0, indexOf);
                for (String propertie : properties) {
                    if (!arg.equals(propertie)) continue;
                    String value = AutoPlacementFinder.getValue(arg2);
                    System.getProperties().setProperty(propertie, value);
                    System.out.println(propertie + ":" + value);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            System.out.println("Unrecogized:" + arg2);
            if (usagePrinted) continue;
            usagePrinted = true;
            System.out.println("Arguments\r\n   triplea.map.folder=<FILE_PATH>\r\n   triplea.unit.zoom=<UNIT_ZOOM_LEVEL>\r\n   triplea.unit.width=<UNIT_WIDTH>\r\n   triplea.unit.height=<UNIT_HEIGHT>\r\n");
        }
        String folderString = System.getProperty(TRIPLEA_MAP_FOLDER);
        if (folderString != null && folderString.length() > 0) {
            File mapFolder = new File(folderString);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + folderString);
            }
        }
        if ((zoomString = System.getProperty(TRIPLEA_UNIT_ZOOM)) != null && zoomString.length() > 0) {
            try {
                unit_zoom_percent = Double.parseDouble(zoomString);
                System.out.println("Unit Zoom Percent to use: " + unit_zoom_percent);
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                System.err.println("Not a decimal percentage: " + zoomString);
            }
        }
        if ((widthString = System.getProperty(TRIPLEA_UNIT_WIDTH)) != null && widthString.length() > 0) {
            try {
                unit_width = Integer.parseInt(widthString);
                System.out.println("Unit Width to use: " + unit_width);
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + widthString);
            }
        }
        if ((heightString = System.getProperty(TRIPLEA_UNIT_HEIGHT)) != null && heightString.length() > 0) {
            try {
                unit_height = Integer.parseInt(heightString);
                System.out.println("Unit Height to use: " + unit_height);
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + heightString);
            }
        }
        if (placeDimensionsSet) {
            PLACEWIDTH = (int)(unit_zoom_percent * (double)unit_width);
            PLACEHEIGHT = (int)(unit_zoom_percent * (double)unit_height);
            System.out.println("Place Dimensions to use: " + PLACEWIDTH + "x" + PLACEHEIGHT);
        }
    }

    static {
        placeDimensionsSet = false;
        unit_zoom_percent = 1.0;
        unit_width = 48;
        unit_height = 48;
        s_mapFolderLocation = null;
        textOptionPane = new JTextAreaOptionPane(null, "AutoPlacementFinder Log\r\n\r\n", "", "AutoPlacementFinder Log", null, 500, 300, true, 1, null);
    }
}

