/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileOpen {
    private final String ERR_MSG_1 = "Warning! Could not load the file!";
    private File file = null;

    public FileOpen(String title) {
        this(title, ".txt", ".gif", ".png");
    }

    public FileOpen(String title, String ... extensions) {
        this(title, new File(System.getProperties().getProperty("user.dir")), extensions);
    }

    public FileOpen(String title, File currentDirectory) {
        this(title, currentDirectory, ".txt", ".gif", ".png");
    }

    public FileOpen(String title, File currentDirectory, String ... extensions) {
        this(title, currentDirectory, (File)null, extensions);
    }

    public FileOpen(String title, File currentDirectory, File selectedFile, final String ... extensions) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        if (selectedFile != null) {
            chooser.setSelectedFile(selectedFile);
        }
        chooser.setCurrentDirectory(currentDirectory == null || !currentDirectory.exists() ? new File(System.getProperties().getProperty("user.dir")) : currentDirectory);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String ex : extensions) {
                    if (!f.getName().endsWith(ex)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                StringBuffer buf = new StringBuffer();
                for (String ex : extensions) {
                    buf.append("*").append(ex).append(" ");
                }
                return buf.toString();
            }
        });
        int result = chooser.showOpenDialog(null);
        if (result == 1) {
            return;
        }
        try {
            this.file = chooser.getSelectedFile();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Warning! Could not load the file!", "Warning!", 2);
            this.file = null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getPathString() {
        if (this.file == null) {
            return null;
        }
        return this.file.getPath();
    }
}

