/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.util.Tuple;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import util.image.MapPropertyWrapper;

public class MapProperties {
    public final String MAP_PROPERTIES_FILENAME = "map.properties";
    public Map<String, Color> COLOR_MAP = new TreeMap<String, Color>();
    public String UNITS_SCALE = "0.75";
    public int UNITS_WIDTH = 48;
    public int UNITS_HEIGHT = 48;
    public int UNITS_COUNTER_OFFSET_WIDTH = 12;
    public int UNITS_COUNTER_OFFSET_HEIGHT = 48;
    public int UNITS_STACK_SIZE = 0;
    public int MAP_WIDTH = 256;
    public int MAP_HEIGHT = 256;
    public boolean MAP_SCROLLWRAPX = true;
    public boolean MAP_SCROLLWRAPY = false;
    public boolean MAP_HASRELIEF = true;
    public int MAP_CURSOR_HOTSPOT_X = 0;
    public int MAP_CURSOR_HOTSPOT_Y = 0;
    public boolean MAP_SHOWCAPITOLMARKERS = true;
    public boolean MAP_USETERRITORYEFFECTMARKERS = false;
    public boolean MAP_SHOWTERRITORYNAMES = true;
    public boolean MAP_SHOWRESOURCES = true;
    public boolean MAP_SHOWCOMMENTS = true;
    public boolean MAP_SHOWSEAZONENAMES = false;
    public boolean MAP_DRAWNAMESFROMTOPLEFT = false;
    public boolean MAP_USENATION_CONVOYFLAGS = false;
    public String DONT_DRAW_TERRITORY_NAMES = "";
    public boolean MAP_MAPBLENDS = false;
    public String MAP_MAPBLENDMODE = "OVERLAY";
    public String MAP_MAPBLENDALPHA = "0.3";
    public boolean SCREENSHOT_TITLE_ENABLED = true;
    public int SCREENSHOT_TITLE_X = 50;
    public int SCREENSHOT_TITLE_Y = 50;
    public Color SCREENSHOT_TITLE_COLOR = Color.black;
    public int SCREENSHOT_TITLE_FONT_SIZE = 20;
    public boolean SCREENSHOT_STATS_ENABLED = true;
    public int SCREENSHOT_STATS_X = 50;
    public int SCREENSHOT_STATS_Y = 54;
    public Color SCREENSHOT_STATS_TEXT_COLOR = Color.black;
    public Color SCREENSHOT_STATS_BORDER_COLOR = Color.white;

    public MapProperties() {
        this.COLOR_MAP.put("Americans", new Color(0x666600));
        this.COLOR_MAP.put("Australians", new Color(0xCCCC00));
        this.COLOR_MAP.put("British", new Color(9528320));
        this.COLOR_MAP.put("Canadians", new Color(14401151));
        this.COLOR_MAP.put("Chinese", new Color(0x663E66));
        this.COLOR_MAP.put("French", new Color(1129079));
        this.COLOR_MAP.put("Germans", new Color(0x777777));
        this.COLOR_MAP.put("Italians", new Color(750210));
        this.COLOR_MAP.put("Japanese", new Color(16765952));
        this.COLOR_MAP.put("Puppet_States", new Color(1793440));
        this.COLOR_MAP.put("Russians", new Color(11680512));
        this.COLOR_MAP.put("Neutral", new Color(14852209));
        this.COLOR_MAP.put("Impassible", new Color(14203516));
    }

    public Tuple<PropertiesUI, List<MapPropertyWrapper>> propertyWrapperUI(boolean editable) {
        return MapPropertyWrapper.createPropertiesUI(this, editable);
    }

    public void writePropertiesToObject(List<MapPropertyWrapper> properties) {
        MapPropertyWrapper.writePropertiesToObject(this, properties);
    }

    public Map<String, Color> getCOLOR_MAP() {
        return this.COLOR_MAP;
    }

    public void setCOLOR_MAP(Map<String, Color> value) {
        this.COLOR_MAP = value;
    }

    public String outCOLOR_MAP() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Color> entry : this.COLOR_MAP.entrySet()) {
            buf.append("color." + entry.getKey() + "=" + MapProperties.colorToHex(entry.getValue()) + "\r\n");
        }
        return buf.toString();
    }

    public static String colorToHex(Color color) {
        String hexString = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        while (hexString.length() < 6) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public String getUNITS_SCALE() {
        return this.UNITS_SCALE;
    }

    public void setUNITS_SCALE(String value) {
        double dvalue = Math.max(0.0, Math.min(2.0, Double.parseDouble(value)));
        this.UNITS_SCALE = Math.abs(1.25 - dvalue) < 0.01 ? "1.25" : (Math.abs(1.0 - dvalue) < 0.01 ? "1.0" : (Math.abs(0.875 - dvalue) < 0.01 ? "0.875" : (Math.abs(0.8333 - dvalue) < 0.01 ? "0.8333" : (Math.abs(0.75 - dvalue) < 0.01 ? "0.75" : (Math.abs(0.6666 - dvalue) < 0.01 ? "0.6666" : (Math.abs(0.5625 - dvalue) < 0.01 ? "0.5625" : (Math.abs(0.5 - dvalue) < 0.01 ? "0.5" : "" + dvalue)))))));
    }

    public String outUNITS_SCALE() {
        return "units.scale=" + this.UNITS_SCALE + "\r\n";
    }

    public int getUNITS_WIDTH() {
        return this.UNITS_WIDTH;
    }

    public void setUNITS_WIDTH(int value) {
        this.UNITS_WIDTH = value;
    }

    public String outUNITS_WIDTH() {
        return "units.width=" + this.UNITS_WIDTH + "\r\n";
    }

    public int getUNITS_HEIGHT() {
        return this.UNITS_HEIGHT;
    }

    public void setUNITS_HEIGHT(int value) {
        this.UNITS_HEIGHT = value;
    }

    public String outUNITS_HEIGHT() {
        return "units.height=" + this.UNITS_HEIGHT + "\r\n";
    }

    public int getUNITS_COUNTER_OFFSET_WIDTH() {
        return this.UNITS_COUNTER_OFFSET_WIDTH;
    }

    public void setUNITS_COUNTER_OFFSET_WIDTH(int value) {
        this.UNITS_COUNTER_OFFSET_WIDTH = value;
    }

    public String outUNITS_COUNTER_OFFSET_WIDTH() {
        return "units.counter.offset.width=" + this.UNITS_COUNTER_OFFSET_WIDTH + "\r\n";
    }

    public int getUNITS_COUNTER_OFFSET_HEIGHT() {
        return this.UNITS_COUNTER_OFFSET_HEIGHT;
    }

    public void setUNITS_COUNTER_OFFSET_HEIGHT(int value) {
        this.UNITS_COUNTER_OFFSET_HEIGHT = value;
    }

    public String outUNITS_COUNTER_OFFSET_HEIGHT() {
        return "units.counter.offset.height=" + this.UNITS_COUNTER_OFFSET_HEIGHT + "\r\n";
    }

    public int getUNITS_STACK_SIZE() {
        return this.UNITS_STACK_SIZE;
    }

    public void setUNITS_STACK_SIZE(int value) {
        this.UNITS_STACK_SIZE = value;
    }

    public String outUNITS_STACK_SIZE() {
        return "units.stack.size=" + this.UNITS_STACK_SIZE + "\r\n";
    }

    public int getMAP_WIDTH() {
        return this.MAP_WIDTH;
    }

    public void setMAP_WIDTH(int value) {
        this.MAP_WIDTH = value;
    }

    public String outMAP_WIDTH() {
        return "map.width=" + this.MAP_WIDTH + "\r\n";
    }

    public int getMAP_HEIGHT() {
        return this.MAP_HEIGHT;
    }

    public void setMAP_HEIGHT(int value) {
        this.MAP_HEIGHT = value;
    }

    public String outMAP_HEIGHT() {
        return "map.height=" + this.MAP_HEIGHT + "\r\n";
    }

    public boolean getMAP_SCROLLWRAPX() {
        return this.MAP_SCROLLWRAPX;
    }

    public void setMAP_SCROLLWRAPX(boolean value) {
        this.MAP_SCROLLWRAPX = value;
    }

    public String outMAP_SCROLLWRAPX() {
        return "map.scrollWrapX=" + this.MAP_SCROLLWRAPX + "\r\n";
    }

    public boolean getMAP_SCROLLWRAPY() {
        return this.MAP_SCROLLWRAPY;
    }

    public void setMAP_SCROLLWRAPY(boolean value) {
        this.MAP_SCROLLWRAPY = value;
    }

    public String outMAP_SCROLLWRAPY() {
        return "map.scrollWrapY=" + this.MAP_SCROLLWRAPY + "\r\n";
    }

    public boolean getMAP_HASRELIEF() {
        return this.MAP_HASRELIEF;
    }

    public void setMAP_HASRELIEF(boolean value) {
        this.MAP_HASRELIEF = value;
    }

    public String outMAP_HASRELIEF() {
        return "map.hasRelief=" + this.MAP_HASRELIEF + "\r\n";
    }

    public int getMAP_CURSOR_HOTSPOT_X() {
        return this.MAP_CURSOR_HOTSPOT_X;
    }

    public void setMAP_CURSOR_HOTSPOT_X(int value) {
        this.MAP_CURSOR_HOTSPOT_X = value;
    }

    public String outMAP_CURSOR_HOTSPOT_X() {
        return "map.cursor.hotspot.x=" + this.MAP_CURSOR_HOTSPOT_X + "\r\n";
    }

    public int getMAP_CURSOR_HOTSPOT_Y() {
        return this.MAP_CURSOR_HOTSPOT_Y;
    }

    public void setMAP_CURSOR_HOTSPOT_Y(int value) {
        this.MAP_CURSOR_HOTSPOT_Y = value;
    }

    public String outMAP_CURSOR_HOTSPOT_Y() {
        return "map.cursor.hotspot.y=" + this.MAP_CURSOR_HOTSPOT_Y + "\r\n";
    }

    public boolean getMAP_SHOWCAPITOLMARKERS() {
        return this.MAP_SHOWCAPITOLMARKERS;
    }

    public void setMAP_SHOWCAPITOLMARKERS(boolean value) {
        this.MAP_SHOWCAPITOLMARKERS = value;
    }

    public String outMAP_SHOWCAPITOLMARKERS() {
        return "map.showCapitolMarkers=" + this.MAP_SHOWCAPITOLMARKERS + "\r\n";
    }

    public boolean getMAP_USETERRITORYEFFECTMARKERS() {
        return this.MAP_USETERRITORYEFFECTMARKERS;
    }

    public void setMAP_USETERRITORYEFFECTMARKERS(boolean value) {
        this.MAP_USETERRITORYEFFECTMARKERS = value;
    }

    public String outMAP_USETERRITORYEFFECTMARKERS() {
        return "map.useTerritoryEffectMarkers=" + this.MAP_USETERRITORYEFFECTMARKERS + "\r\n";
    }

    public boolean getMAP_SHOWTERRITORYNAMES() {
        return this.MAP_SHOWTERRITORYNAMES;
    }

    public void setMAP_SHOWTERRITORYNAMES(boolean value) {
        this.MAP_SHOWTERRITORYNAMES = value;
    }

    public String outMAP_SHOWTERRITORYNAMES() {
        return "map.showTerritoryNames=" + this.MAP_SHOWTERRITORYNAMES + "\r\n";
    }

    public boolean getMAP_SHOWRESOURCES() {
        return this.MAP_SHOWRESOURCES;
    }

    public void setMAP_SHOWRESOURCES(boolean value) {
        this.MAP_SHOWRESOURCES = value;
    }

    public String outMAP_SHOWRESOURCES() {
        return "map.showResources=" + this.MAP_SHOWRESOURCES + "\r\n";
    }

    public boolean getMAP_SHOWCOMMENTS() {
        return this.MAP_SHOWCOMMENTS;
    }

    public void setMAP_SHOWCOMMENTS(boolean value) {
        this.MAP_SHOWCOMMENTS = value;
    }

    public String outMAP_SHOWCOMMENTS() {
        return "map.showComments=" + this.MAP_SHOWCOMMENTS + "\r\n";
    }

    public boolean getMAP_SHOWSEAZONENAMES() {
        return this.MAP_SHOWSEAZONENAMES;
    }

    public void setMAP_SHOWSEAZONENAMES(boolean value) {
        this.MAP_SHOWSEAZONENAMES = value;
    }

    public String outMAP_SHOWSEAZONENAMES() {
        return "map.showSeaZoneNames=" + this.MAP_SHOWSEAZONENAMES + "\r\n";
    }

    public boolean getMAP_DRAWNAMESFROMTOPLEFT() {
        return this.MAP_DRAWNAMESFROMTOPLEFT;
    }

    public void setMAP_DRAWNAMESFROMTOPLEFT(boolean value) {
        this.MAP_DRAWNAMESFROMTOPLEFT = value;
    }

    public String outMAP_DRAWNAMESFROMTOPLEFT() {
        return "map.drawNamesFromTopLeft=" + this.MAP_DRAWNAMESFROMTOPLEFT + "\r\n";
    }

    public boolean getMAP_USENATION_CONVOYFLAGS() {
        return this.MAP_USENATION_CONVOYFLAGS;
    }

    public void setMAP_USENATION_CONVOYFLAGS(boolean value) {
        this.MAP_USENATION_CONVOYFLAGS = value;
    }

    public String outMAP_USENATION_CONVOYFLAGS() {
        return "map.useNation_convoyFlags=" + this.MAP_USENATION_CONVOYFLAGS + "\r\n";
    }

    public String getDONT_DRAW_TERRITORY_NAMES() {
        return this.DONT_DRAW_TERRITORY_NAMES;
    }

    public void setDONT_DRAW_TERRITORY_NAMES(String value) {
        this.DONT_DRAW_TERRITORY_NAMES = value;
    }

    public String outDONT_DRAW_TERRITORY_NAMES() {
        return "dont_draw_territory_names=" + this.DONT_DRAW_TERRITORY_NAMES + "\r\n";
    }

    public boolean getMAP_MAPBLENDS() {
        return this.MAP_MAPBLENDS;
    }

    public void setMAP_MAPBLENDS(boolean value) {
        this.MAP_MAPBLENDS = value;
    }

    public String outMAP_MAPBLENDS() {
        return "map.mapBlends=" + this.MAP_MAPBLENDS + "\r\n";
    }

    public String getMAP_MAPBLENDMODE() {
        return this.MAP_MAPBLENDMODE;
    }

    public void setMAP_MAPBLENDMODE(String value) {
        this.MAP_MAPBLENDMODE = value;
    }

    public String outMAP_MAPBLENDMODE() {
        return "map.mapBlendMode=" + this.MAP_MAPBLENDMODE + "\r\n";
    }

    public String getMAP_MAPBLENDALPHA() {
        return this.MAP_MAPBLENDALPHA;
    }

    public void setMAP_MAPBLENDALPHA(String value) {
        Double.parseDouble(value);
        this.MAP_MAPBLENDALPHA = value;
    }

    public String outMAP_MAPBLENDALPHA() {
        return "map.mapBlendAlpha=" + this.MAP_MAPBLENDALPHA + "\r\n";
    }

    public boolean getSCREENSHOT_TITLE_ENABLED() {
        return this.SCREENSHOT_TITLE_ENABLED;
    }

    public void setSCREENSHOT_TITLE_ENABLED(boolean value) {
        this.SCREENSHOT_TITLE_ENABLED = value;
    }

    public String outSCREENSHOT_TITLE_ENABLED() {
        return "screenshot.title.enabled=" + this.SCREENSHOT_TITLE_ENABLED + "\r\n";
    }

    public int getSCREENSHOT_TITLE_X() {
        return this.SCREENSHOT_TITLE_X;
    }

    public void setSCREENSHOT_TITLE_X(int value) {
        this.SCREENSHOT_TITLE_X = value;
    }

    public String outSCREENSHOT_TITLE_X() {
        return "screenshot.title.x=" + this.SCREENSHOT_TITLE_X + "\r\n";
    }

    public int getSCREENSHOT_TITLE_Y() {
        return this.SCREENSHOT_TITLE_Y;
    }

    public void setSCREENSHOT_TITLE_Y(int value) {
        this.SCREENSHOT_TITLE_Y = value;
    }

    public String outSCREENSHOT_TITLE_Y() {
        return "screenshot.title.y=" + this.SCREENSHOT_TITLE_Y + "\r\n";
    }

    public Color getSCREENSHOT_TITLE_COLOR() {
        return this.SCREENSHOT_TITLE_COLOR;
    }

    public void setSCREENSHOT_TITLE_COLOR(Color value) {
        this.SCREENSHOT_TITLE_COLOR = value;
    }

    public String outSCREENSHOT_TITLE_COLOR() {
        return "screenshot.title.color=" + MapProperties.colorToHex(this.SCREENSHOT_TITLE_COLOR) + "\r\n";
    }

    public int getSCREENSHOT_TITLE_FONT_SIZE() {
        return this.SCREENSHOT_TITLE_FONT_SIZE;
    }

    public void setSCREENSHOT_TITLE_FONT_SIZE(int value) {
        this.SCREENSHOT_TITLE_FONT_SIZE = value;
    }

    public String outSCREENSHOT_TITLE_FONT_SIZE() {
        return "screenshot.title.font.size=" + this.SCREENSHOT_TITLE_FONT_SIZE + "\r\n";
    }

    public boolean getSCREENSHOT_STATS_ENABLED() {
        return this.SCREENSHOT_STATS_ENABLED;
    }

    public void setSCREENSHOT_STATS_ENABLED(boolean value) {
        this.SCREENSHOT_STATS_ENABLED = value;
    }

    public String outSCREENSHOT_STATS_ENABLED() {
        return "screenshot.stats.enabled=" + this.SCREENSHOT_STATS_ENABLED + "\r\n";
    }

    public int getSCREENSHOT_STATS_X() {
        return this.SCREENSHOT_STATS_X;
    }

    public void setSCREENSHOT_STATS_X(int value) {
        this.SCREENSHOT_STATS_X = value;
    }

    public String outSCREENSHOT_STATS_X() {
        return "screenshot.stats.x=" + this.SCREENSHOT_STATS_X + "\r\n";
    }

    public int getSCREENSHOT_STATS_Y() {
        return this.SCREENSHOT_STATS_Y;
    }

    public void setSCREENSHOT_STATS_Y(int value) {
        this.SCREENSHOT_STATS_Y = value;
    }

    public String outSCREENSHOT_STATS_Y() {
        return "screenshot.stats.y=" + this.SCREENSHOT_STATS_Y + "\r\n";
    }

    public Color getSCREENSHOT_STATS_TEXT_COLOR() {
        return this.SCREENSHOT_STATS_TEXT_COLOR;
    }

    public void setSCREENSHOT_STATS_TEXT_COLOR(Color value) {
        this.SCREENSHOT_STATS_TEXT_COLOR = value;
    }

    public String outSCREENSHOT_STATS_TEXT_COLOR() {
        return "screenshot.stats.text.color=" + MapProperties.colorToHex(this.SCREENSHOT_STATS_TEXT_COLOR) + "\r\n";
    }

    public Color getSCREENSHOT_STATS_BORDER_COLOR() {
        return this.SCREENSHOT_STATS_BORDER_COLOR;
    }

    public void setSCREENSHOT_STATS_BORDER_COLOR(Color value) {
        this.SCREENSHOT_STATS_BORDER_COLOR = value;
    }

    public String outSCREENSHOT_STATS_BORDER_COLOR() {
        return "screenshot.stats.border.color=" + MapProperties.colorToHex(this.SCREENSHOT_STATS_BORDER_COLOR) + "\r\n";
    }
}

