/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.ui.DoubleTextField;
import games.strategy.ui.IntTextField;
import games.strategy.util.Tuple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import util.image.FileOpen;
import util.image.FileSave;
import util.image.MapProperties;
import util.image.MapPropertyWrapper;

public class MapPropertiesMaker
extends JFrame {
    private static final long serialVersionUID = 8182821091131994702L;
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private static final String TRIPLEA_UNIT_ZOOM = "triplea.unit.zoom";
    private static final String TRIPLEA_UNIT_WIDTH = "triplea.unit.width";
    private static final String TRIPLEA_UNIT_HEIGHT = "triplea.unit.height";
    private static final MapProperties s_mapProperties = new MapProperties();
    private static JPanel s_playerColorChooser = new JPanel();

    public static String[] getProperties() {
        return new String[]{TRIPLEA_MAP_FOLDER, TRIPLEA_UNIT_ZOOM, TRIPLEA_UNIT_WIDTH, TRIPLEA_UNIT_HEIGHT};
    }

    public static void main(String[] args) {
        MapPropertiesMaker.handleCommandLineArgs(args);
        if (s_mapFolderLocation == null) {
            File mapFolder;
            System.out.println("Select the map folder");
            String path = new FileSave("Where is your map's folder?", null, s_mapFolderLocation).getPathString();
            if (path != null && (mapFolder = new File(path)).exists()) {
                s_mapFolderLocation = mapFolder;
                System.setProperty(TRIPLEA_MAP_FOLDER, s_mapFolderLocation.getPath());
            }
        }
        if (s_mapFolderLocation != null) {
            MapPropertiesMaker maker = new MapPropertiesMaker();
            maker.setSize(800, 800);
            maker.setLocationRelativeTo(null);
            maker.setVisible(true);
        } else {
            System.out.println("No Map Folder Selected. Shutting down.");
            System.exit(0);
        }
    }

    public MapPropertiesMaker() {
        super("Map Properties Maker");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = this.createPropertiesPanel();
        this.getContentPane().add((Component)new JScrollPane(panel), "Center");
        AbstractAction openAction = new AbstractAction("Load Properties"){
            private static final long serialVersionUID = -3135749471880991185L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MapPropertiesMaker.this.loadProperties();
            }
        };
        openAction.putValue("ShortDescription", "Load An Existing Properties File");
        AbstractAction saveAction = new AbstractAction("Save Properties"){
            private static final long serialVersionUID = -5608941822299486808L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MapPropertiesMaker.this.saveProperties();
            }
        };
        saveAction.putValue("ShortDescription", "Save The Properties To File");
        AbstractAction exitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = -9212762817640498442L;

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        JMenuItem openItem = new JMenuItem(openAction);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem saveItem = new JMenuItem(saveAction);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem exitItem = new JMenuItem(exitAction);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
    }

    private JPanel createPropertiesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        panel.add((Component)new JLabel("<html>This is the MapPropertiesMaker, it will create a map.properties file for you. <br>The map.properties is located in the map's directory, and it will tell TripleA various <br>display related information about your map. <br>Such things as the dimensions of your map, the colors of each of the players, <br>the size of the unit images, and how zoomed out they are, etc. <br>To use, just fill in the information in the fields below, and click on 'Show More' to <br>show other, optional, fields. </html>"), new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 0, new Insets(20, 20, 20, 20), 0, 0));
        panel.add((Component)new JLabel("The Width in Pixels of your map: "), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        final IntTextField widthField = new IntTextField(0, Integer.MAX_VALUE);
        widthField.setText("" + s_mapProperties.getMAP_WIDTH());
        widthField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    s_mapProperties.setMAP_WIDTH(Integer.parseInt(widthField.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                widthField.setText("" + s_mapProperties.getMAP_WIDTH());
            }
        });
        panel.add((Component)widthField, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        panel.add((Component)new JLabel("The Height in Pixels of your map: "), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        final IntTextField heightField = new IntTextField(0, Integer.MAX_VALUE);
        heightField.setText("" + s_mapProperties.getMAP_HEIGHT());
        heightField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    s_mapProperties.setMAP_HEIGHT(Integer.parseInt(heightField.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                heightField.setText("" + s_mapProperties.getMAP_HEIGHT());
            }
        });
        panel.add((Component)heightField, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        panel.add((Component)new JLabel("<html>The initial Scale (zoom) of your unit images: <br>Must be one of: 1.25, 1, 0.875, 0.8333, 0.75, 0.6666, 0.5625, 0.5</html>"), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        final DoubleTextField scaleField = new DoubleTextField(0.1, 2.0);
        scaleField.setText("" + s_mapProperties.getUNITS_SCALE());
        scaleField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    s_mapProperties.setUNITS_SCALE(scaleField.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                scaleField.setText("" + s_mapProperties.getUNITS_SCALE());
            }
        });
        panel.add((Component)scaleField, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        panel.add((Component)new JLabel("Create Players and Click on the Color to set their Color: "), new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 0, new Insets(20, 50, 20, 50), 0, 0));
        this.createPlayerColorChooser();
        panel.add((Component)s_playerColorChooser, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        JButton showMore = new JButton("Show All Options");
        showMore.addActionListener(new AbstractAction("Show All Options"){
            private static final long serialVersionUID = -794092512377464803L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Tuple<PropertiesUI, List<MapPropertyWrapper>> propertyWrapperUI = s_mapProperties.propertyWrapperUI(true);
                JOptionPane.showMessageDialog(MapPropertiesMaker.this, propertyWrapperUI.getFirst());
                s_mapProperties.writePropertiesToObject(propertyWrapperUI.getSecond());
                MapPropertiesMaker.this.createPlayerColorChooser();
                MapPropertiesMaker.this.validate();
                MapPropertiesMaker.this.repaint();
            }
        });
        panel.add((Component)showMore, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        return panel;
    }

    private void createPlayerColorChooser() {
        s_playerColorChooser.removeAll();
        s_playerColorChooser.setLayout(new GridBagLayout());
        int row = 0;
        for (final Map.Entry<String, Color> entry : s_mapProperties.getCOLOR_MAP().entrySet()) {
            s_playerColorChooser.add((Component)new JLabel(entry.getKey()), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
            final JLabel label = new JLabel(entry.getKey()){
                private static final long serialVersionUID = 5624227155029721033L;

                @Override
                public void paintComponent(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setColor((Color)entry.getValue());
                    g2.fill(g2.getClip());
                }
            };
            label.setBackground(entry.getValue());
            label.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println(label.getBackground());
                    Color color = JColorChooser.showDialog(label, "Choose color", label.getBackground());
                    s_mapProperties.getCOLOR_MAP().put(label.getText(), color);
                    MapPropertiesMaker.this.createPlayerColorChooser();
                    MapPropertiesMaker.this.validate();
                    MapPropertiesMaker.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            s_playerColorChooser.add((Component)label, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            final JButton removePlayer = new JButton("Remove " + entry.getKey());
            removePlayer.addActionListener(new AbstractAction("Remove " + entry.getKey()){
                private static final long serialVersionUID = -3593575469168341735L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    s_mapProperties.getCOLOR_MAP().remove(removePlayer.getText().replaceFirst("Remove ", ""));
                    MapPropertiesMaker.this.createPlayerColorChooser();
                    MapPropertiesMaker.this.validate();
                    MapPropertiesMaker.this.repaint();
                }
            });
            s_playerColorChooser.add((Component)removePlayer, new GridBagConstraints(2, row, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
            ++row;
        }
        final JTextField nameTextField = new JTextField("Player" + (s_mapProperties.getCOLOR_MAP().size() + 1));
        Dimension ourMinimum = new Dimension(150, 30);
        nameTextField.setMinimumSize(ourMinimum);
        nameTextField.setPreferredSize(ourMinimum);
        JButton addPlayer = new JButton("Add Another Player");
        addPlayer.addActionListener(new AbstractAction("Add Another Player"){
            private static final long serialVersionUID = -794092512377464803L;

            @Override
            public void actionPerformed(ActionEvent e) {
                s_mapProperties.getCOLOR_MAP().put(nameTextField.getText(), Color.GREEN);
                MapPropertiesMaker.this.createPlayerColorChooser();
                MapPropertiesMaker.this.validate();
                MapPropertiesMaker.this.repaint();
            }
        });
        s_playerColorChooser.add((Component)addPlayer, new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        s_playerColorChooser.add((Component)nameTextField, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    private void loadProperties() {
        Properties properties = new Properties();
        try {
            System.out.println("Load a properties file");
            String centerName = new FileOpen("Load A Properties File", s_mapFolderLocation, ".properties").getPathString();
            if (centerName == null) {
                return;
            }
            FileInputStream in = new FileInputStream(centerName);
            properties.load(in);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        for (Method setter : s_mapProperties.getClass().getMethods()) {
            String propertyName;
            String value;
            boolean startsWithSet = setter.getName().startsWith("set");
            if (startsWithSet && (value = properties.getProperty(propertyName = setter.getName().substring(Math.min(3, setter.getName().length()), setter.getName().length()))) != null) continue;
        }
        this.validate();
        this.repaint();
    }

    private void saveProperties() {
        try {
            String fileName = new FileSave("Where To Save map.properties ?", "map.properties", s_mapFolderLocation).getPathString();
            if (fileName == null) {
                return;
            }
            FileOutputStream sink = new FileOutputStream(fileName);
            String stringToWrite = this.getOutPutString();
            OutputStreamWriter out = new OutputStreamWriter(sink);
            out.write(stringToWrite);
            out.flush();
            out.close();
            System.out.println("");
            System.out.println("Data written to :" + new File(fileName).getCanonicalPath());
            System.out.println("");
            System.out.println(stringToWrite);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getOutPutString() {
        StringBuilder outString = new StringBuilder();
        for (Method outMethod : s_mapProperties.getClass().getMethods()) {
            boolean startsWithSet = outMethod.getName().startsWith("out");
            if (!startsWithSet) continue;
            try {
                outString.append(outMethod.invoke((Object)s_mapProperties, new Object[0]));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return outString.toString();
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        String heightString;
        String widthString;
        String zoomString;
        String[] properties = MapPropertiesMaker.getProperties();
        boolean usagePrinted = false;
        for (String arg2 : args) {
            boolean found = false;
            String arg = arg2;
            int indexOf = arg.indexOf(61);
            if (indexOf > 0) {
                arg = arg.substring(0, indexOf);
                for (String propertie : properties) {
                    if (!arg.equals(propertie)) continue;
                    String value = MapPropertiesMaker.getValue(arg2);
                    System.getProperties().setProperty(propertie, value);
                    System.out.println(propertie + ":" + value);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            System.out.println("Unrecogized:" + arg2);
            if (usagePrinted) continue;
            usagePrinted = true;
            System.out.println("Arguments\r\n   triplea.map.folder=<FILE_PATH>\r\n   triplea.unit.zoom=<UNIT_ZOOM_LEVEL>\r\n   triplea.unit.width=<UNIT_WIDTH>\r\n   triplea.unit.height=<UNIT_HEIGHT>\r\n");
        }
        String folderString = System.getProperty(TRIPLEA_MAP_FOLDER);
        if (folderString != null && folderString.length() > 0) {
            File mapFolder = new File(folderString);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + folderString);
            }
        }
        if ((zoomString = System.getProperty(TRIPLEA_UNIT_ZOOM)) != null && zoomString.length() > 0) {
            try {
                double unit_zoom_percent = Double.parseDouble(zoomString);
                s_mapProperties.setUNITS_SCALE(zoomString);
                System.out.println("Unit Zoom Percent to use: " + unit_zoom_percent);
            }
            catch (Exception ex) {
                System.err.println("Not a decimal percentage: " + zoomString);
            }
        }
        if ((widthString = System.getProperty(TRIPLEA_UNIT_WIDTH)) != null && widthString.length() > 0) {
            try {
                int unit_width = Integer.parseInt(widthString);
                s_mapProperties.setUNITS_WIDTH(unit_width);
                s_mapProperties.setUNITS_COUNTER_OFFSET_WIDTH(unit_width / 4);
                System.out.println("Unit Width to use: " + unit_width);
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + widthString);
            }
        }
        if ((heightString = System.getProperty(TRIPLEA_UNIT_HEIGHT)) != null && heightString.length() > 0) {
            try {
                int unit_height = Integer.parseInt(heightString);
                s_mapProperties.setUNITS_HEIGHT(unit_height);
                s_mapProperties.setUNITS_COUNTER_OFFSET_HEIGHT(unit_height);
                System.out.println("Unit Height to use: " + unit_height);
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + heightString);
            }
        }
    }
}

