/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.ui.Util;
import games.strategy.util.PointFileReaderWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import util.image.FileOpen;
import util.image.FileSave;

public class PolygonGrabber
extends JFrame {
    private static final long serialVersionUID = 6381498094805120687L;
    private static boolean s_islandMode;
    private final JCheckBoxMenuItem modeItem;
    private List<Polygon> m_current;
    private BufferedImage m_bufferedImage;
    private Map<String, List<Polygon>> m_polygons = new HashMap<String, List<Polygon>>();
    private Map<String, Point> m_centers;
    private final JLabel location = new JLabel();
    private static File s_mapFolderLocation;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private final Point m_testPoint = new Point();

    public static void main(String[] args) {
        PolygonGrabber.handleCommandLineArgs(args);
        System.out.println("Select the map");
        FileOpen mapSelection = new FileOpen("Select The Map", s_mapFolderLocation, ".gif", ".png");
        String mapName = mapSelection.getPathString();
        if (s_mapFolderLocation == null && mapSelection.getFile() != null) {
            s_mapFolderLocation = mapSelection.getFile().getParentFile();
        }
        if (mapName != null) {
            System.out.println("Map : " + mapName);
            PolygonGrabber grabber = new PolygonGrabber(mapName);
            grabber.setSize(800, 600);
            grabber.setLocationRelativeTo(null);
            grabber.setVisible(true);
            JOptionPane.showMessageDialog(grabber, new JLabel("<html>This is the PolygonGrabber, it will create a polygons.txt file for you. <br>In order to run this, you must already have created a center.txt file. <br>Please click near the center of every single territory and sea zone on your map. <br>The grabber will then fill in the territory based on the borders it finds.<br>If the territory shape or borders do not match what you intend, then your borders <br>might have a gap or differently colored pixel in the border.<br>These borders will define the shape of the territory in TripleA.<br><br>When a territory is inside of another territory, you can turn on 'island mode' to be able to see it.<br><br>You can also load an existing polygons.txt file, then make modifications to it, then save it again.<br><br>LEFT CLICK = fill in a territory's borders.<br><br>Holding CTRL/SHIFT while LEFT CLICKING = add multiple territories together (eg: islands).<br><br>RIGHT CLICK = save or replace those borders for that territory.<br><br>When finished, save the polygons and exit.</html>"));
        } else {
            System.out.println("No Image Map Selected. Shutting down.");
            System.exit(0);
        }
    }

    public PolygonGrabber(String mapName) {
        super("Polygon grabber");
        this.setDefaultCloseOperation(3);
        File file = null;
        if (s_mapFolderLocation != null && s_mapFolderLocation.exists()) {
            file = new File(s_mapFolderLocation, "centers.txt");
        }
        if (file == null || !file.exists()) {
            file = new File(new File(mapName).getParent() + File.separator + "centers.txt");
        }
        if (file.exists() && JOptionPane.showConfirmDialog(new JPanel(), "A centers.txt file was found in the map's folder, do you want to use the file to supply the territories names?", "File Suggestion", 1) == 0) {
            try {
                System.out.println("Centers : " + file.getPath());
                this.m_centers = PointFileReaderWriter.readOneToOne(new FileInputStream(file.getPath()));
            }
            catch (IOException ex1) {
                System.out.println("Something wrong with Centers file");
                ex1.printStackTrace();
            }
        } else {
            try {
                System.out.println("Select the Centers file");
                String centerPath = new FileOpen("Select A Center File", s_mapFolderLocation, ".txt").getPathString();
                if (centerPath != null) {
                    System.out.println("Centers : " + centerPath);
                    this.m_centers = PointFileReaderWriter.readOneToOne(new FileInputStream(centerPath));
                } else {
                    System.out.println("You must specify a centers file.");
                    System.out.println("Shutting down.");
                    System.exit(0);
                }
            }
            catch (IOException ex1) {
                System.out.println("Something wrong with Centers file");
                ex1.printStackTrace();
                System.exit(0);
            }
        }
        this.createImage(mapName);
        JPanel imagePanel = this.createMainPanel();
        imagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PolygonGrabber.this.location.setText("x:" + e.getX() + " y:" + e.getY());
            }
        });
        imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PolygonGrabber.this.mouseEvent(e.getPoint(), e.isControlDown() || e.isShiftDown(), SwingUtilities.isRightMouseButton(e));
            }
        });
        imagePanel.setMinimumSize(new Dimension(this.m_bufferedImage.getWidth(this), this.m_bufferedImage.getHeight(this)));
        imagePanel.setPreferredSize(new Dimension(this.m_bufferedImage.getWidth(this), this.m_bufferedImage.getHeight(this)));
        imagePanel.setMaximumSize(new Dimension(this.m_bufferedImage.getWidth(this), this.m_bufferedImage.getHeight(this)));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(imagePanel), "Center");
        this.getContentPane().add((Component)this.location, "South");
        AbstractAction openAction = new AbstractAction("Load Polygons"){
            private static final long serialVersionUID = -9093814781969488946L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolygonGrabber.this.loadPolygons();
            }
        };
        openAction.putValue("ShortDescription", "Load An Existing Polygon Points FIle");
        AbstractAction saveAction = new AbstractAction("Save Polygons"){
            private static final long serialVersionUID = -6886417728606754296L;

            @Override
            public void actionPerformed(ActionEvent event) {
                PolygonGrabber.this.savePolygons();
            }
        };
        saveAction.putValue("ShortDescription", "Save The Polygon Points To File");
        AbstractAction exitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = -1294988703454116227L;

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        AbstractAction autoAction = new AbstractAction("Auto Find Polygons"){
            private static final long serialVersionUID = 9135123964960352915L;

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(null, new JLabel("<html>You will need to check and go back and do some polygons manually, as Auto does not catch them all. <br>Also, if a territory has more than 1 part (like an island chain), you will need to go back and <br>redo the entire territory chain using CTRL + Click in order to capture each part of the territory.</html>"));
                PolygonGrabber.this.m_current = new ArrayList();
                BufferedImage imageCopy = new BufferedImage(PolygonGrabber.this.m_bufferedImage.getWidth(null), PolygonGrabber.this.m_bufferedImage.getHeight(null), 2);
                Graphics g = imageCopy.getGraphics();
                g.drawImage(PolygonGrabber.this.m_bufferedImage, 0, 0, null);
                for (String territoryName : PolygonGrabber.this.m_centers.keySet()) {
                    Point center = (Point)PolygonGrabber.this.m_centers.get(territoryName);
                    System.out.println("Detecting Polygon for:" + territoryName);
                    Polygon p = PolygonGrabber.this.findPolygon(center.x, center.y);
                    if (!p.contains(center)) continue;
                    boolean hasIslands = false;
                    for (Point otherCenterPoint : PolygonGrabber.this.m_centers.values()) {
                        if (center.equals(otherCenterPoint) || !p.contains(otherCenterPoint)) continue;
                        hasIslands = true;
                        break;
                    }
                    if (hasIslands || PolygonGrabber.this.doesPolygonContainAnyBlackInside(p, imageCopy, g)) continue;
                    ArrayList<Polygon> polys = new ArrayList<Polygon>();
                    polys.add(p);
                    PolygonGrabber.this.m_polygons.put(territoryName, polys);
                }
                g.dispose();
                imageCopy.flush();
                PolygonGrabber.this.repaint();
            }
        };
        autoAction.putValue("ShortDescription", "Autodetect Polygons around Centers");
        JMenuItem openItem = new JMenuItem(openAction);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem saveItem = new JMenuItem(saveAction);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem exitItem = new JMenuItem(exitAction);
        s_islandMode = false;
        this.modeItem = new JCheckBoxMenuItem("Island Mode", false);
        this.modeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                s_islandMode = PolygonGrabber.this.modeItem.getState();
                PolygonGrabber.this.repaint();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem autoItem = new JMenuItem(autoAction);
        editMenu.setMnemonic('E');
        editMenu.add(this.modeItem);
        editMenu.add(autoItem);
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
    }

    private void createImage(String mapName) {
        Image image = Toolkit.getDefaultToolkit().createImage(mapName);
        try {
            Util.ensureImageLoaded(image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.m_bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = this.m_bufferedImage.getGraphics();
        g.drawImage(image, 0, 0, this);
        g.dispose();
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = new JPanel(){
            private static final long serialVersionUID = 4106539186003148628L;

            @Override
            public void paint(Graphics g) {
                g.drawImage(PolygonGrabber.this.m_bufferedImage, 0, 0, this);
                Iterator iter = PolygonGrabber.this.m_polygons.entrySet().iterator();
                g.setColor(Color.red);
                while (iter.hasNext()) {
                    Polygon item;
                    Collection polygons = (Collection)iter.next().getValue();
                    Iterator iter2 = polygons.iterator();
                    if (s_islandMode) {
                        while (iter2.hasNext()) {
                            item = (Polygon)iter2.next();
                            g.drawPolygon(item.xpoints, item.ypoints, item.npoints);
                        }
                        continue;
                    }
                    while (iter2.hasNext()) {
                        item = (Polygon)iter2.next();
                        g.setColor(Color.yellow);
                        g.fillPolygon(item.xpoints, item.ypoints, item.npoints);
                        g.setColor(Color.black);
                        g.drawPolygon(item.xpoints, item.ypoints, item.npoints);
                    }
                }
                g.setColor(Color.red);
                if (PolygonGrabber.this.m_current != null) {
                    for (Polygon item : PolygonGrabber.this.m_current) {
                        g.fillPolygon(item.xpoints, item.ypoints, item.npoints);
                    }
                }
            }
        };
        return imagePanel;
    }

    private void savePolygons() {
        try {
            String polyName = new FileSave("Where To Save Polygons.txt ?", "polygons.txt", s_mapFolderLocation).getPathString();
            if (polyName == null) {
                return;
            }
            FileOutputStream out = new FileOutputStream(polyName);
            PointFileReaderWriter.writeOneToManyPolygons(out, this.m_polygons);
            out.flush();
            out.close();
            System.out.println("Data written to :" + new File(polyName).getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadPolygons() {
        try {
            System.out.println("Load a polygon file");
            String polyName = new FileOpen("Load A Polygon File", s_mapFolderLocation, ".txt").getPathString();
            if (polyName == null) {
                return;
            }
            FileInputStream in = new FileInputStream(polyName);
            this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(in);
            this.repaint();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
    }

    private void mouseEvent(Point point, boolean ctrlDown, boolean rightMouse) {
        Polygon p = this.findPolygon(point.x, point.y);
        if (p == null) {
            return;
        }
        if (rightMouse && this.m_current != null) {
            this.doneCurrentGroup();
        } else {
            if (this.pointInCurrentPolygon(point)) {
                System.out.println("rejecting");
                return;
            }
            if (ctrlDown) {
                if (this.m_current == null) {
                    this.m_current = new ArrayList<Polygon>();
                }
                this.m_current.add(p);
            } else {
                this.m_current = new ArrayList<Polygon>();
                this.m_current.add(p);
            }
        }
        this.repaint();
    }

    private boolean pointInCurrentPolygon(Point p) {
        if (this.m_current == null) {
            return false;
        }
        for (Polygon item : this.m_current) {
            if (!item.contains(p)) continue;
            return true;
        }
        return false;
    }

    private void doneCurrentGroup() throws HeadlessException {
        JTextField text = new JTextField();
        Iterator<Map.Entry<String, Point>> centersiter = this.m_centers.entrySet().iterator();
        this.guessCountryName(text, centersiter);
        int option = JOptionPane.showConfirmDialog(this, text);
        if (option == 0) {
            if (!this.m_centers.keySet().contains(text.getText())) {
                JOptionPane.showMessageDialog(this, "not a valid name");
                this.m_current = null;
                return;
            }
            this.m_polygons.put(text.getText(), new ArrayList<Polygon>(this.m_current));
            this.m_current = null;
        } else if (option > 0) {
            this.m_current = null;
        } else {
            System.out.println("something very invalid");
        }
    }

    private void guessCountryName(JTextField text, Iterator<Map.Entry<String, Point>> centersiter) {
        ArrayList<String> options = new ArrayList<String>();
        while (centersiter.hasNext()) {
            Map.Entry<String, Point> item = centersiter.next();
            Point p = new Point(item.getValue());
            for (Polygon polygon : this.m_current) {
                if (!polygon.contains(p)) continue;
                options.add(item.getKey().toString());
            }
        }
        if (!options.isEmpty()) {
            Collections.shuffle(options);
            text.setText((String)options.get(0));
        }
    }

    private final boolean isBlack(Point p) {
        return this.isBlack(p.x, p.y);
    }

    private final boolean isBlack(int x, int y) {
        if (!this.inBounds(x, y)) {
            return false;
        }
        return (this.m_bufferedImage.getRGB(x, y) & 0xFFFFFF) == 0;
    }

    private static final boolean isBlack(int x, int y, BufferedImage bufferedImage) {
        if (!PolygonGrabber.inBounds(x, y, bufferedImage)) {
            return false;
        }
        return (bufferedImage.getRGB(x, y) & 0xFFFFFF) == 0;
    }

    private final boolean inBounds(int x, int y) {
        return x >= 0 && x < this.m_bufferedImage.getWidth(null) && y >= 0 && y < this.m_bufferedImage.getHeight(null);
    }

    private static final boolean inBounds(int x, int y, Image image) {
        return x >= 0 && x < image.getWidth(null) && y >= 0 && y < image.getHeight(null);
    }

    private final void move(Point p, int direction) {
        if (direction < 0 || direction > 7) {
            throw new IllegalArgumentException("Not a direction :" + direction);
        }
        if (direction == 1 || direction == 2 || direction == 3) {
            ++p.x;
        } else if (direction == 5 || direction == 6 || direction == 7) {
            --p.x;
        }
        if (direction == 5 || direction == 4 || direction == 3) {
            ++p.y;
        } else if (direction == 7 || direction == 0 || direction == 1) {
            --p.y;
        }
    }

    private boolean isOnEdge(int direction, Point currentPoint) {
        this.m_testPoint.setLocation(currentPoint);
        this.move(this.m_testPoint, direction);
        return this.m_testPoint.x == 0 || this.m_testPoint.y == 0 || this.m_testPoint.y == this.m_bufferedImage.getHeight(this) || this.m_testPoint.x == this.m_bufferedImage.getWidth(this) || this.isBlack(this.m_testPoint);
    }

    private final boolean doesPolygonContainAnyBlackInside(Polygon poly, BufferedImage imageCopy, Graphics imageCopyGraphics) {
        imageCopyGraphics.setColor(Color.GREEN);
        imageCopyGraphics.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
        Rectangle rect = poly.getBounds();
        for (int x = rect.x; x < rect.x + rect.width; ++x) {
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                if (!PolygonGrabber.isBlack(x, y, imageCopy) || !poly.contains(new Point(x, y))) continue;
                imageCopyGraphics.setColor(Color.BLACK);
                imageCopyGraphics.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
                return true;
            }
        }
        imageCopyGraphics.setColor(Color.BLACK);
        imageCopyGraphics.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
        return false;
    }

    private final Polygon findPolygon(int x, int y) {
        Point startPoint = new Point(x, y);
        while (this.inBounds(startPoint.x, startPoint.y - 1) && !this.isBlack(startPoint.x, startPoint.y)) {
            --startPoint.y;
        }
        ArrayList<Point> points = new ArrayList<Point>(100);
        points.add(new Point(startPoint));
        int currentDirection = 2;
        Point currentPoint = new Point(startPoint);
        int iterCount = 0;
        block1: while (!currentPoint.equals(startPoint) || points.size() == 1) {
            if (++iterCount > 100000) {
                JOptionPane.showMessageDialog(this, "Failed to grab the polygon. Failed at point: " + currentPoint.getX() + "," + currentPoint.getY() + "\r\n" + "Note that this is a common error and can usually be fixed by 'smoothing out' the territory border and removing any anti-aliasing.");
                return null;
            }
            for (int i = 2; i >= -3; --i) {
                int tempDirection = (currentDirection + i) % 8;
                if (tempDirection < 0) {
                    tempDirection += 8;
                }
                if (!this.isOnEdge(tempDirection, currentPoint)) continue;
                if (i != 0) {
                    points.add(currentPoint);
                    currentPoint = new Point(currentPoint);
                    this.move(currentPoint, tempDirection);
                    currentDirection = tempDirection;
                    continue block1;
                }
                this.move(currentPoint, currentDirection);
                continue block1;
            }
        }
        int[] xpoints = new int[points.size()];
        int[] ypoints = new int[points.size()];
        int i = 0;
        for (Point item : points) {
            xpoints[i] = item.x;
            ypoints[i] = item.y;
            ++i;
        }
        System.out.println("Done finding polygon. total points;" + xpoints.length);
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        File mapFolder;
        String value;
        if (args.length == 1) {
            value = args[0].startsWith(TRIPLEA_MAP_FOLDER) ? PolygonGrabber.getValue(args[0]) : args[0];
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        } else if (args.length > 1) {
            System.out.println("Only argument allowed is the map directory.");
        }
        if ((s_mapFolderLocation == null || s_mapFolderLocation.length() < 1L) && (value = System.getProperty(TRIPLEA_MAP_FOLDER)) != null && value.length() > 0) {
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
    }

    static {
        s_mapFolderLocation = null;
    }
}

