/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.ui.Util;
import games.strategy.util.JTextAreaOptionPane;
import games.strategy.util.PointFileReaderWriter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import util.image.FileOpen;
import util.image.FileSave;

public class TileImageReconstructor {
    private static String baseTileLocation = null;
    private static String imageSaveLocation = null;
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private static final JTextAreaOptionPane textOptionPane = new JTextAreaOptionPane(null, "TileImageReconstructor Log\r\n\r\n", "", "TileImageReconstructor Log", null, 500, 300, true, 1, null);
    private static int sizeX = -1;
    private static int sizeY = -1;
    private static Map<String, List<Polygon>> m_polygons = new HashMap<String, List<Polygon>>();

    public static void main(String[] args) throws Exception {
        String height;
        TileImageReconstructor.handleCommandLineArgs(args);
        JOptionPane.showMessageDialog(null, new JLabel("<html>This is the TileImageReconstructor, it will reconstruct a single map image from a folder full of basetiles. <br>You must know the size of the map image before you begin, this is normally found in the map.properties file. </html>"));
        FileSave baseTileLocationSelection = new FileSave("Where are the Tile Images?", null, s_mapFolderLocation);
        baseTileLocation = baseTileLocationSelection.getPathString();
        if (s_mapFolderLocation == null && baseTileLocationSelection.getFile() != null) {
            s_mapFolderLocation = baseTileLocationSelection.getFile().getParentFile();
        }
        if (baseTileLocation == null) {
            System.out.println("You need to select a folder where the basetiles are for this to work");
            System.out.println("Shutting down");
            System.exit(0);
            return;
        }
        FileSave imageSaveLocationSelection = new FileSave("Save Map Image As?", null, s_mapFolderLocation, 0, new File(s_mapFolderLocation, "map.png"), new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                return f.getName().endsWith(".png");
            }

            @Override
            public String getDescription() {
                return "*.png";
            }
        });
        imageSaveLocation = imageSaveLocationSelection.getPathString();
        if (imageSaveLocation == null) {
            System.out.println("You need to choose a name and location for your image file for this to work");
            System.out.println("Shutting down");
            System.exit(0);
            return;
        }
        String width = JOptionPane.showInputDialog(null, (Object)"Enter the map image's full width in pixels:");
        if (width != null) {
            try {
                sizeX = Integer.parseInt(width);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if ((height = JOptionPane.showInputDialog(null, (Object)"Enter the map image's full height in pixels:")) != null) {
            try {
                sizeY = Integer.parseInt(height);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (sizeX <= 0 || sizeY <= 0) {
            System.out.println("Map dimensions must be greater than zero for this to work");
            System.out.println("Shutting down");
            System.exit(0);
            return;
        }
        if (JOptionPane.showConfirmDialog(null, "Do not draw polgyons.txt file onto your image?\r\n(Default = 'yes' = do not draw)", "Do Not Also Draw Polygons?", 0) == 1) {
            try {
                System.out.println("Load a polygon file");
                String polyName = new FileOpen("Load A Polygon File", s_mapFolderLocation, ".txt").getPathString();
                if (polyName != null) {
                    FileInputStream in = new FileInputStream(polyName);
                    m_polygons = PointFileReaderWriter.readOneToManyPolygons(in);
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (HeadlessException ex) {
                ex.printStackTrace();
            }
        }
        TileImageReconstructor.createMap();
    }

    public static void createMap() {
        textOptionPane.show();
        GraphicsConfiguration localGraphicSystem = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage mapImage = localGraphicSystem.createCompatibleImage(sizeX, sizeY, 3);
        Graphics graphics = mapImage.getGraphics();
        int x = 0;
        while (x * 256 < sizeX) {
            int y = 0;
            while (y * 256 < sizeY) {
                String tileName = x + "_" + y + ".png";
                File tileFile = new File(baseTileLocation, tileName);
                if (tileFile != null && tileFile.exists()) {
                    Image tile = Toolkit.getDefaultToolkit().createImage(tileFile.getPath());
                    try {
                        Util.ensureImageLoaded(tile);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    Rectangle tileBounds = new Rectangle(x * 256, y * 256, Math.min(x * 256 + 256, sizeX), Math.min(y * 256 + 256, sizeY));
                    graphics.drawImage(tile, tileBounds.x, tileBounds.y, tileBounds.x + tileBounds.width, tileBounds.y + tileBounds.height, 0, 0, tileBounds.width, tileBounds.height, null);
                    textOptionPane.appendNewLine("Drew " + tileName);
                }
                ++y;
            }
            ++x;
        }
        if (m_polygons != null && !m_polygons.isEmpty()) {
            graphics.setColor(Color.black);
            textOptionPane.appendNewLine("Drawing Polygons");
            for (Map.Entry<String, List<Polygon>> entry : m_polygons.entrySet()) {
                for (Polygon poly : entry.getValue()) {
                    graphics.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
                }
            }
        }
        textOptionPane.appendNewLine("Saving as " + imageSaveLocation + " ... ");
        try {
            ImageIO.write((RenderedImage)mapImage, "png", new File(imageSaveLocation));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        textOptionPane.appendNewLine("Wrote " + imageSaveLocation);
        textOptionPane.appendNewLine("\r\nAll Finished!");
        textOptionPane.countDown();
        textOptionPane.dispose();
        JOptionPane.showMessageDialog(null, new JLabel("All Finished"));
        System.exit(0);
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        File mapFolder;
        String value;
        if (args.length == 1) {
            value = args[0].startsWith(TRIPLEA_MAP_FOLDER) ? TileImageReconstructor.getValue(args[0]) : args[0];
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        } else if (args.length > 1) {
            System.out.println("Only argument allowed is the map directory.");
        }
        if ((s_mapFolderLocation == null || s_mapFolderLocation.length() < 1L) && (value = System.getProperty(TRIPLEA_MAP_FOLDER)) != null && value.length() > 0) {
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
    }
}

