/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.player;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.delegate.remote.IPlayDelegate;
import games.puzzle.slidingtiles.player.AbstractAI;
import games.strategy.common.player.ai.AIAlgorithm;
import games.strategy.common.player.ai.GameState;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;

public class BetterAI
extends AbstractAI {
    private int m_xDimension;
    private int m_yDimension;
    private final Algorithm m_algorithm;
    private final Heuristic m_heuristic;
    private Stack<Move> m_moves;
    public static int counter = 0;

    public BetterAI(String name, String type, Algorithm algorithm, Heuristic heuristic) {
        super(name, type);
        this.m_algorithm = algorithm;
        this.m_heuristic = heuristic;
        this.m_moves = null;
    }

    public void initialize(IPlayerBridge bridge, PlayerID id) {
        super.initialize(bridge, id);
        this.m_xDimension = this.m_bridge.getGameData().getMap().getXDimension();
        this.m_yDimension = this.m_bridge.getGameData().getMap().getYDimension();
    }

    protected void play() {
        if (this.m_moves == null) {
            ((IPlayDelegate)this.m_bridge.getRemote()).signalStatus("Thinking...");
            try {
                int numberOfShuffles;
                if (this.m_algorithm.equals((Object)Algorithm.DFS)) {
                    numberOfShuffles = 1;
                    while (this.m_moves == null || this.m_moves.isEmpty()) {
                        this.m_moves = AIAlgorithm.depthFirstSearch(this.getInitialState(), numberOfShuffles++);
                    }
                } else {
                    throw new RuntimeException("Invalid algorithm");
                }
                ((IPlayDelegate)this.m_bridge.getRemote()).signalStatus("Solvable in " + (numberOfShuffles - 1) + " moves");
                System.out.println("Solvable in " + (numberOfShuffles - 1) + " moves");
                ((IPlayDelegate)this.m_bridge.getRemote()).signalStatus("Done Thinking...");
            }
            catch (OutOfMemoryError e) {
                System.out.println("Ran out of memory while searching for next move: " + counter + " moves examined.");
                System.exit(-1);
            }
        } else {
            this.pause();
        }
        if (this.m_moves == null || this.m_moves.isEmpty()) {
            ((IPlayDelegate)this.m_bridge.getRemote()).signalStatus("Too hard to solve!");
        } else {
            ((IPlayDelegate)this.m_bridge.getRemote()).signalStatus(" ");
            Move move = this.m_moves.pop();
            IPlayDelegate playDel = (IPlayDelegate)this.m_bridge.getRemote();
            Territory start = this.m_bridge.getGameData().getMap().getTerritoryFromCoordinates(move.getStart().getFirst(), move.getStart().getSecond());
            Territory end = this.m_bridge.getGameData().getMap().getTerritoryFromCoordinates(move.getEnd().getFirst(), move.getEnd().getSecond());
            playDel.play(start, end);
        }
    }

    private State getInitialState() {
        return new State(this.m_bridge.getGameData().getMap());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Pair<First, Second> {
        private final First m_first;
        private final Second m_second;

        Pair(First first, Second second) {
            this.m_first = first;
            this.m_second = second;
        }

        First getFirst() {
            return this.m_first;
        }

        Second getSecond() {
            return this.m_second;
        }

        public String toString() {
            return "(" + this.m_first + "," + this.m_second + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Move {
        private final Pair<Integer, Integer> m_start;
        private final Pair<Integer, Integer> m_end;

        public Move(Pair<Integer, Integer> start, Pair<Integer, Integer> end) {
            this.m_start = start;
            this.m_end = end;
        }

        public Pair<Integer, Integer> getStart() {
            return this.m_start;
        }

        public Pair<Integer, Integer> getEnd() {
            return this.m_end;
        }

        public String toString() {
            return this.m_start + " -> " + this.m_end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class State
    extends GameState<Move> {
        private final int[][] m_data;
        private final int m_depth;
        private final Move m_move;
        private int m_blankX;
        private int m_blankY;

        public State() {
            this.m_depth = 0;
            this.m_move = null;
            this.m_data = new int[BetterAI.this.m_xDimension][BetterAI.this.m_yDimension];
            this.m_data[0][0] = 3;
            this.m_data[1][0] = 1;
            this.m_data[2][0] = 2;
            this.m_data[0][1] = 4;
            this.m_data[1][1] = 0;
            this.m_data[2][1] = 5;
            this.m_data[0][2] = 6;
            this.m_data[1][2] = 7;
            this.m_data[2][2] = 8;
        }

        public State(GameMap map) {
            this.m_depth = 0;
            this.m_move = null;
            this.m_data = new int[BetterAI.this.m_xDimension][BetterAI.this.m_yDimension];
            for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    Territory territory = map.getTerritoryFromCoordinates(x, y);
                    Tile tile = (Tile)territory.getAttachment("tile");
                    if (tile == null) {
                        throw new RuntimeException("Territory " + territory + " does not have an associated tile.");
                    }
                    this.m_data[x][y] = tile.getValue();
                    if (this.m_data[x][y] != 0) continue;
                    this.m_blankX = x;
                    this.m_blankY = y;
                }
            }
        }

        public int hashCode() {
            int code = 0;
            int digit = 1;
            for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    code += this.m_data[x][y] * digit;
                    digit *= 10;
                }
            }
            return code;
        }

        public boolean equals(GameState<Move> state) {
            return this.hashCode() == state.hashCode();
        }

        public String toString() {
            String s = "";
            for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    s = s + this.m_data[x][y] + " ";
                }
                s = s + "- ";
            }
            return s;
        }

        public State getSuccessor(Move move) {
            return new State(move, this);
        }

        @Override
        public Move getMove() {
            return this.m_move;
        }

        private State(Move move, State parentState) {
            this.m_move = move;
            this.m_depth = parentState.m_depth + 1;
            ++counter;
            int startX = move.getStart().getFirst();
            int startY = move.getStart().getSecond();
            int endX = move.getEnd().getFirst();
            int endY = move.getEnd().getSecond();
            this.m_data = new int[BetterAI.this.m_xDimension][BetterAI.this.m_yDimension];
            for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    this.m_data[x][y] = parentState.m_data[x][y];
                }
            }
            int tmp = this.m_data[startX][startY];
            this.m_data[startX][startY] = this.m_data[endX][endY];
            this.m_data[endX][endY] = tmp;
            for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    if (this.m_data[x][y] != 0) continue;
                    this.m_blankX = x;
                    this.m_blankY = y;
                }
            }
        }

        @Override
        public Collection<GameState<Move>> successors() {
            ArrayList<GameState<Move>> successors = new ArrayList<GameState<Move>>();
            Pair<Integer, Integer> blankTile = new Pair<Integer, Integer>(this.m_blankX, this.m_blankY);
            if (this.m_blankX > 0) {
                successors.add(new State(new Move(new Pair<Integer, Integer>(this.m_blankX - 1, this.m_blankY), blankTile), this));
            }
            if (this.m_blankX < BetterAI.this.m_xDimension - 1) {
                successors.add(new State(new Move(new Pair<Integer, Integer>(this.m_blankX + 1, this.m_blankY), blankTile), this));
            }
            if (this.m_blankY > 0) {
                successors.add(new State(new Move(new Pair<Integer, Integer>(this.m_blankX, this.m_blankY - 1), blankTile), this));
            }
            if (this.m_blankY < BetterAI.this.m_yDimension - 1) {
                successors.add(new State(new Move(new Pair<Integer, Integer>(this.m_blankX, this.m_blankY + 1), blankTile), this));
            }
            return successors;
        }

        @Override
        public float getUtility() {
            float utility = 0.0f;
            switch (BetterAI.this.m_heuristic) {
                case NUMBER_OF_MISPLACED_TILES: {
                    int misplacedTiles = 0;
                    int value = 0;
                    for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                        for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                            if (value != this.m_data[x][y]) {
                                ++misplacedTiles;
                            }
                            ++value;
                        }
                    }
                    utility = -1 * misplacedTiles;
                }
            }
            return utility;
        }

        @Override
        public boolean gameIsOver() {
            int value = -1;
            for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    if (value >= this.m_data[x][y]) {
                        return false;
                    }
                    value = this.m_data[x][y];
                }
            }
            return true;
        }

        @Override
        public boolean cutoffTest() {
            return this.gameIsOver();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Heuristic {
        NUMBER_OF_MISPLACED_TILES,
        MANHATTAN_DISTANCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        DFS;

    }
}

