/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.player;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.delegate.remote.IPlayDelegate;
import games.puzzle.slidingtiles.player.AbstractAI;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class RandomAI
extends AbstractAI {
    public RandomAI(String name, String type) {
        super(name, type);
    }

    protected void play() {
        this.pause();
        GameMap map = this.getGameData().getMap();
        Collection<Territory> territories = map.getTerritories();
        IPlayDelegate playDel = (IPlayDelegate)this.getPlayerBridge().getRemote();
        Territory blank = null;
        for (Territory t : territories) {
            int value;
            Tile tile = (Tile)t.getAttachment("tile");
            if (tile == null || (value = tile.getValue()) != 0) continue;
            blank = t;
            break;
        }
        if (blank == null) {
            throw new RuntimeException("No blank tile");
        }
        Random random = new Random();
        ArrayList<Territory> neighbors = new ArrayList<Territory>(map.getNeighbors(blank));
        Territory swap = (Territory)neighbors.get(random.nextInt(neighbors.size()));
        playDel.play(swap, blank);
    }
}

