/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.delegate;

import games.puzzle.tictactoe.delegate.TicTacToeEndTurnExtendedDelegateState;
import games.puzzle.tictactoe.ui.display.ITicTacToeDisplay;
import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndTurnDelegate
extends BaseDelegate {
    @Override
    public void start(IDelegateBridge bridge) {
        super.start(bridge);
        PlayerID winner = this.checkForWinner();
        if (winner != null) {
            if (winner.equals(PlayerID.NULL_PLAYERID)) {
                this.signalGameOver("Cat's game!");
            } else {
                this.signalGameOver(winner.getName() + " wins!");
            }
        }
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        TicTacToeEndTurnExtendedDelegateState state = new TicTacToeEndTurnExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        TicTacToeEndTurnExtendedDelegateState s = (TicTacToeEndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    private void signalGameOver(String status) {
        ITicTacToeDisplay display = (ITicTacToeDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
        display.setGameOver();
    }

    private PlayerID checkForWinner() {
        int y;
        int x;
        GameMap map = this.getData().getMap();
        int boardWidth = map.getXDimension();
        int boardHeight = map.getYDimension();
        Territory[][] grid = new Territory[boardWidth][boardHeight];
        for (int y2 = 0; y2 < boardHeight; ++y2) {
            for (x = 0; x < boardWidth; ++x) {
                grid[x][y2] = map.getTerritoryFromCoordinates(x, y2);
            }
        }
        for (int y3 = 0; y3 < boardHeight; ++y3) {
            PlayerID player;
            if (grid[0][y3] == null || (player = grid[0][y3].getOwner()) == null || player.equals(PlayerID.NULL_PLAYERID)) continue;
            for (int x2 = 0; x2 < boardWidth; ++x2) {
                if (grid[x2][y3] != null && player == grid[x2][y3].getOwner()) continue;
                player = null;
                break;
            }
            if (player == null) continue;
            return player;
        }
        for (x = 0; x < boardWidth; ++x) {
            PlayerID player;
            if (grid[x][0] == null || (player = grid[x][0].getOwner()) == null || player.equals(PlayerID.NULL_PLAYERID)) continue;
            for (y = 0; y < boardHeight; ++y) {
                if (grid[x][y] != null && player == grid[x][y].getOwner()) continue;
                player = null;
                break;
            }
            if (player == null) continue;
            return player;
        }
        PlayerID player = grid[0][0].getOwner();
        if (player != null && !player.equals(PlayerID.NULL_PLAYERID)) {
            for (x = 0; x < boardWidth && x < boardHeight; ++x) {
                if (player == grid[x][x].getOwner()) continue;
                player = null;
                break;
            }
            if (player != null) {
                return player;
            }
        }
        if ((player = grid[0][boardWidth - 1].getOwner()) != null && !player.equals(PlayerID.NULL_PLAYERID)) {
            for (x = boardWidth - 1; x >= 0 && x < boardHeight; --x) {
                if (player == grid[x][boardWidth - 1 - x].getOwner()) continue;
                player = null;
                break;
            }
            if (player != null) {
                return player;
            }
        }
        for (x = 0; x < boardWidth; ++x) {
            for (y = 0; y < boardHeight; ++y) {
                player = grid[x][y].getOwner();
                if (player != null && !player.equals(PlayerID.NULL_PLAYERID)) continue;
                return null;
            }
        }
        return PlayerID.NULL_PLAYERID;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

