/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.delegate;

import games.strategy.common.delegate.BaseDelegateState;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.PoliticsDelegate;
import games.strategy.util.CompositeMatchAnd;
import java.io.Serializable;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDelegate
implements IDelegate {
    protected String m_name;
    protected String m_displayName;
    protected PlayerID m_player;
    protected IDelegateBridge m_bridge;
    private boolean m_startBaseStepsFinished = false;
    private boolean m_endBaseStepsFinished = false;

    @Override
    public void initialize(String name, String displayName) {
        this.m_name = name;
        this.m_displayName = displayName;
    }

    @Override
    public void start(IDelegateBridge bridge) {
        this.m_bridge = bridge;
        this.m_player = bridge.getPlayerID();
        if (!this.m_startBaseStepsFinished) {
            this.m_startBaseStepsFinished = true;
            this.triggerWhenTriggerAttachments("before");
        }
    }

    @Override
    public void end() {
        if (!this.m_endBaseStepsFinished) {
            this.m_endBaseStepsFinished = true;
            this.triggerWhenTriggerAttachments("after");
        }
        this.m_startBaseStepsFinished = false;
        this.m_endBaseStepsFinished = false;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public Serializable saveState() {
        BaseDelegateState state = new BaseDelegateState();
        state.m_startBaseStepsFinished = this.m_startBaseStepsFinished;
        state.m_endBaseStepsFinished = this.m_endBaseStepsFinished;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        BaseDelegateState s = (BaseDelegateState)state;
        this.m_startBaseStepsFinished = s.m_startBaseStepsFinished;
        this.m_endBaseStepsFinished = s.m_endBaseStepsFinished;
    }

    @Override
    public abstract Class<? extends IRemote> getRemoteType();

    @Override
    public IDelegateBridge getBridge() {
        return this.m_bridge;
    }

    protected GameData getData() {
        return this.m_bridge.getData();
    }

    private void triggerWhenTriggerAttachments(String beforeOrAfter) {
        GameData data = this.getData();
        if (Properties.getTriggers(data)) {
            String stepName = data.getSequence().getStep().getName();
            CompositeMatchAnd<TriggerAttachment> baseDelegateWhenTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
            TriggerAttachment.collectAndFireTriggers(new HashSet<PlayerID>(data.getPlayerList().getPlayers()), baseDelegateWhenTriggerMatch, this.m_bridge, beforeOrAfter, stepName);
        }
        PoliticsDelegate.chainAlliancesTogether(this.m_bridge);
    }
}

