/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.ChatController;
import games.strategy.engine.chat.ChatIgnoreList;
import games.strategy.engine.chat.ChatMessage;
import games.strategy.engine.chat.IChatChannel;
import games.strategy.engine.chat.IChatController;
import games.strategy.engine.chat.IChatListener;
import games.strategy.engine.chat.SentMessagesHistory;
import games.strategy.engine.chat.StatusManager;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.MessageContext;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chat {
    private final List<IChatListener> m_listeners = new CopyOnWriteArrayList<IChatListener>();
    private final Messengers m_messengers;
    private final String m_chatChannelName;
    private final String m_chatName;
    private final SentMessagesHistory m_sentMessages;
    private volatile long m_chatInitVersion = -1L;
    private final Object m_mutexNodes = new Object();
    private List<INode> m_nodes;
    private final Object m_mutexQueue = new Object();
    private List<Runnable> m_queuedInitMessages = new ArrayList<Runnable>();
    private final List<ChatMessage> m_chatHistory = new ArrayList<ChatMessage>();
    private final StatusManager m_statusManager;
    private final ChatIgnoreList m_ignoreList = new ChatIgnoreList();
    private final HashMap<INode, LinkedHashSet<String>> m_notesMap = new HashMap();
    private static final String TAG_MODERATOR = "[Mod]";
    private final List<INode> m_playersThatLeft_Last10 = new ArrayList<INode>();
    private final IChatChannel m_chatChannelSubscribor = new IChatChannel(){

        private void assertMessageFromServer() {
            INode senderNode = MessageContext.getSender();
            INode serverNode = Chat.this.m_messengers.getMessenger().getServerNode();
            if (senderNode == null) {
                return;
            }
            if (!senderNode.equals(serverNode)) {
                throw new IllegalStateException("The node:" + senderNode + " sent a message as the server!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chatOccured(String message) {
            INode from = MessageContext.getSender();
            if (Chat.this.isIgnored(from)) {
                return;
            }
            Object object = Chat.this.m_mutexNodes;
            synchronized (object) {
                Chat.this.m_chatHistory.add(new ChatMessage(message, from.getName(), false));
                for (IChatListener listener : Chat.this.m_listeners) {
                    listener.addMessage(message, from.getName(), false);
                }
                while (Chat.this.m_chatHistory.size() > 1000) {
                    Chat.this.m_chatHistory.remove(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void meMessageOccured(String message) {
            INode from = MessageContext.getSender();
            if (Chat.this.isIgnored(from)) {
                return;
            }
            Object object = Chat.this.m_mutexNodes;
            synchronized (object) {
                Chat.this.m_chatHistory.add(new ChatMessage(message, from.getName(), true));
                for (IChatListener listener : Chat.this.m_listeners) {
                    listener.addMessage(message, from.getName(), true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void speakerAdded(final INode node, final IChatController.Tag tag, final long version) {
            this.assertMessageFromServer();
            if (Chat.this.m_chatInitVersion == -1L) {
                Object object = Chat.this.m_mutexQueue;
                synchronized (object) {
                    if (Chat.this.m_queuedInitMessages == null) {
                        this.speakerAdded(node, tag, version);
                    } else {
                        Chat.this.m_queuedInitMessages.add(new Runnable(){

                            public void run() {
                                this.speakerAdded(node, tag, version);
                            }
                        });
                    }
                }
                return;
            }
            if (version > Chat.this.m_chatInitVersion) {
                Object object = Chat.this.m_mutexNodes;
                synchronized (object) {
                    Chat.this.m_nodes.add(node);
                    Chat.this.addToNotesMap(node, tag);
                    Chat.this.updateConnections();
                }
                for (IChatListener listener : Chat.this.m_listeners) {
                    listener.addStatusMessage(node.getName() + " has joined");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void speakerRemoved(final INode node, final long version) {
            this.assertMessageFromServer();
            if (Chat.this.m_chatInitVersion == -1L) {
                Object object = Chat.this.m_mutexQueue;
                synchronized (object) {
                    if (Chat.this.m_queuedInitMessages == null) {
                        this.speakerRemoved(node, version);
                    } else {
                        Chat.this.m_queuedInitMessages.add(new Runnable(){

                            public void run() {
                                this.speakerRemoved(node, version);
                            }
                        });
                    }
                }
                return;
            }
            if (version > Chat.this.m_chatInitVersion) {
                Object object = Chat.this.m_mutexNodes;
                synchronized (object) {
                    Chat.this.m_nodes.remove(node);
                    Chat.this.m_notesMap.remove(node);
                    Chat.this.updateConnections();
                }
                for (IChatListener listener : Chat.this.m_listeners) {
                    listener.addStatusMessage(node.getName() + " has left");
                }
                Chat.this.m_playersThatLeft_Last10.add(node);
                if (Chat.this.m_playersThatLeft_Last10.size() > 10) {
                    Chat.this.m_playersThatLeft_Last10.remove(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void speakerTagUpdated(INode node, IChatController.Tag tag) {
            Object object = Chat.this.m_mutexNodes;
            synchronized (object) {
                Chat.this.m_notesMap.remove(node);
                Chat.this.addToNotesMap(node, tag);
                Chat.this.updateConnections();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void slapOccured(String to) {
            INode from = MessageContext.getSender();
            if (Chat.this.isIgnored(from)) {
                return;
            }
            Object object = Chat.this.m_mutexNodes;
            synchronized (object) {
                if (to.equals(Chat.this.m_messengers.getChannelMessenger().getLocalNode().getName())) {
                    for (IChatListener listener : Chat.this.m_listeners) {
                        String message = "You were slapped by " + from.getName();
                        Chat.this.m_chatHistory.add(new ChatMessage(message, from.getName(), false));
                        listener.addMessageWithSound(message, from.getName(), false, "slap.wav");
                    }
                } else if (from.equals(Chat.this.m_messengers.getChannelMessenger().getLocalNode())) {
                    for (IChatListener listener : Chat.this.m_listeners) {
                        String message = "You just slapped " + to;
                        Chat.this.m_chatHistory.add(new ChatMessage(message, from.getName(), false));
                        listener.addMessageWithSound(message, from.getName(), false, "slap.wav");
                    }
                }
            }
        }

        public void ping() {
        }
    };

    private void addToNotesMap(INode node, IChatController.Tag tag) {
        if (tag == IChatController.Tag.NONE) {
            return;
        }
        LinkedHashSet<String> current = Chat.getTagText(tag);
        this.m_notesMap.put(node, current);
    }

    private static LinkedHashSet<String> getTagText(IChatController.Tag tag) {
        LinkedHashSet<String> rVal = new LinkedHashSet<String>();
        if (tag == IChatController.Tag.NONE) {
            return null;
        }
        if (tag == IChatController.Tag.MODERATOR) {
            rVal.add(TAG_MODERATOR);
        }
        return rVal;
    }

    public String getNotesForNode(INode node) {
        LinkedHashSet<String> notes = this.m_notesMap.get(node);
        if (notes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        for (String note : notes) {
            sb.append(" ");
            sb.append(note);
        }
        return sb.toString();
    }

    public Chat(String chatName, Messengers messengers) {
        this.m_messengers = messengers;
        this.m_statusManager = new StatusManager(messengers);
        this.m_chatChannelName = ChatController.getChatChannelName(chatName);
        this.m_chatName = chatName;
        this.m_sentMessages = new SentMessagesHistory();
        this.init();
    }

    public Chat(IMessenger messenger, String chatName, IChannelMessenger channelMessenger, IRemoteMessenger remoteMessenger) {
        this(chatName, new Messengers(messenger, remoteMessenger, channelMessenger));
    }

    public SentMessagesHistory getSentMessagesHistory() {
        return this.m_sentMessages;
    }

    public void addChatListener(IChatListener listener) {
        this.m_listeners.add(listener);
        this.updateConnections();
    }

    public StatusManager getStatusManager() {
        return this.m_statusManager;
    }

    public void removeChatListener(IChatListener listener) {
        this.m_listeners.remove(listener);
    }

    public Object getMutex() {
        return this.m_mutexNodes;
    }

    private void init() {
        new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IChatController controller = (IChatController)Chat.this.m_messengers.getRemoteMessenger().getRemote(ChatController.getChatControlerRemoteName(Chat.this.m_chatName));
                Chat.this.m_messengers.getChannelMessenger().registerChannelSubscriber(Chat.this.m_chatChannelSubscribor, new RemoteName(Chat.this.m_chatChannelName, IChatChannel.class));
                Tuple<Map<INode, IChatController.Tag>, Long> init = controller.joinChat();
                final Map<INode, IChatController.Tag> chatters = init.getFirst();
                Object object = Chat.this.m_mutexNodes;
                synchronized (object) {
                    Chat.this.m_nodes = new ArrayList<INode>(chatters.keySet());
                }
                Chat.this.m_chatInitVersion = init.getSecond();
                new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = Chat.this.m_mutexQueue;
                        synchronized (object) {
                            Chat.this.m_queuedInitMessages.add(0, new Runnable(){

                                public void run() {
                                    Chat.this.assignNodeTags(chatters);
                                }
                            });
                            for (Runnable job : Chat.this.m_queuedInitMessages) {
                                job.run();
                            }
                            Chat.this.m_queuedInitMessages = null;
                        }
                        Chat.this.updateConnections();
                    }
                }.run();
            }
        }.run();
    }

    private void assignNodeTags(Map<INode, IChatController.Tag> chatters) {
        for (INode node : chatters.keySet()) {
            IChatController.Tag tag = chatters.get(node);
            this.addToNotesMap(node, tag);
        }
    }

    public void shutdown() {
        this.m_messengers.getChannelMessenger().unregisterChannelSubscriber(this.m_chatChannelSubscribor, new RemoteName(this.m_chatChannelName, IChatChannel.class));
        if (this.m_messengers.getMessenger().isConnected()) {
            RemoteName chatControllerName = ChatController.getChatControlerRemoteName(this.m_chatName);
            IChatController controller = (IChatController)this.m_messengers.getRemoteMessenger().getRemote(chatControllerName);
            controller.leaveChat();
        }
    }

    public void sendSlap(String playerName) {
        IChatChannel remote = (IChatChannel)this.m_messengers.getChannelMessenger().getChannelBroadcastor(new RemoteName(this.m_chatChannelName, IChatChannel.class));
        remote.slapOccured(playerName);
    }

    void sendMessage(String message, boolean meMessage) {
        IChatChannel remote = (IChatChannel)this.m_messengers.getChannelMessenger().getChannelBroadcastor(new RemoteName(this.m_chatChannelName, IChatChannel.class));
        if (meMessage) {
            remote.meMessageOccured(message);
        } else {
            remote.chatOccured(message);
        }
        this.m_sentMessages.append(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnections() {
        Object object = this.m_mutexNodes;
        synchronized (object) {
            if (this.m_nodes == null) {
                return;
            }
            ArrayList<INode> playerNames = new ArrayList<INode>(this.m_nodes);
            Collections.sort(playerNames);
            for (IChatListener listener : this.m_listeners) {
                listener.updatePlayerList(playerNames);
            }
        }
    }

    public void setIgnored(INode node, boolean isIgnored) {
        if (isIgnored) {
            this.m_ignoreList.add(node.getName());
        } else {
            this.m_ignoreList.remove(node.getName());
        }
    }

    public boolean isIgnored(INode node) {
        return this.m_ignoreList.shouldIgnore(node.getName());
    }

    public INode getLocalNode() {
        return this.m_messengers.getMessenger().getLocalNode();
    }

    public INode getServerNode() {
        return this.m_messengers.getMessenger().getServerNode();
    }

    public List<INode> GetPlayersThatLeft_Last10() {
        return new ArrayList<INode>(this.m_playersThatLeft_Last10);
    }

    public List<INode> GetOnlinePlayers() {
        return new ArrayList<INode>(this.m_nodes);
    }

    public List<ChatMessage> getChatHistory() {
        return this.m_chatHistory;
    }
}

