/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.BattleRecordsList;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddBattleRecordsChange
extends Change {
    private static final long serialVersionUID = -6927678548172402611L;
    private final Map<Integer, BattleRecords> m_newRecords;
    private final Map<Integer, BattleRecords> m_oldRecords;

    AddBattleRecordsChange(BattleRecords battleRecords, GameData data) {
        this.m_oldRecords = data.getBattleRecordsList().getBattleRecordsMap();
        this.m_newRecords = data.getBattleRecordsList().getBattleRecordsMap();
        BattleRecordsList.addRecords(this.m_newRecords, data.getSequence().getRound(), battleRecords);
    }

    AddBattleRecordsChange(Map<Integer, BattleRecords> newList, Map<Integer, BattleRecords> oldList) {
        this.m_oldRecords = oldList;
        this.m_newRecords = newList;
    }

    @Override
    protected void perform(GameData data) {
        data.getBattleRecordsList().setRecords(this.m_newRecords);
    }

    @Override
    public Change invert() {
        return new AddBattleRecordsChange(this.m_oldRecords, this.m_newRecords);
    }

    public String toString() {
        if (this.m_newRecords == null || this.m_oldRecords == null) {
            throw new IllegalStateException("Records can not be null (most likely caused by improper or impossible serialization): " + this.m_newRecords + " and " + this.m_oldRecords);
        }
        return "New Battle Record: [" + this.m_newRecords + "] and Old Battle Record: [" + this.m_oldRecords + "]";
    }
}

