/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllianceTracker
extends GameDataComponent {
    private static final long serialVersionUID = 2815023984535209353L;
    Map<PlayerID, Collection<String>> m_alliances = new HashMap<PlayerID, Collection<String>>();

    public AllianceTracker(GameData data) {
        super(data);
    }

    protected void addToAlliance(PlayerID player, String allianceName) {
        if (!this.m_alliances.containsKey(player)) {
            HashSet<String> alliances = new HashSet<String>();
            alliances.add(allianceName);
            this.m_alliances.put(player, alliances);
        } else {
            Collection<String> alliances = this.m_alliances.get(player);
            alliances.add(allianceName);
        }
    }

    public Set<String> getAlliances() {
        Iterator<PlayerID> keys = this.m_alliances.keySet().iterator();
        HashSet<String> rVal = new HashSet<String>();
        while (keys.hasNext()) {
            rVal.addAll(this.m_alliances.get(keys.next()));
        }
        return rVal;
    }

    public HashSet<PlayerID> getPlayersInAlliance(String allianceName) {
        Iterator<PlayerID> keys = this.m_alliances.keySet().iterator();
        HashSet<PlayerID> rVal = new HashSet<PlayerID>();
        while (keys.hasNext()) {
            PlayerID player = keys.next();
            Collection<String> alliances = this.m_alliances.get(player);
            if (!alliances.contains(allianceName)) continue;
            rVal.add(player);
        }
        return rVal;
    }

    public Collection<String> getAlliancesPlayerIsIn(PlayerID player) {
        Collection<String> rVal = this.m_alliances.get(player);
        if (rVal == null) {
            System.out.println("Player, " + player.getName() + ", is not a member of any alliance!");
            return Collections.singleton(player.getName());
        }
        return rVal;
    }

    public Map<PlayerID, Collection<String>> getAlliancesMap() {
        return this.m_alliances;
    }
}

