/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.AttachmentPropertyClearUndo;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.IAttachment;
import games.strategy.util.PropertyUtil;

class AttachmentPropertyClear
extends Change {
    private static final long serialVersionUID = 9208154387325299072L;
    private final Attachable m_attachedTo;
    private final String m_attachmentName;
    private final Object m_oldValue;
    private final String m_property;

    AttachmentPropertyClear(IAttachment attachment, String property, boolean getRaw) {
        if (attachment == null) {
            throw new IllegalArgumentException("No attachment, property:" + property);
        }
        this.m_attachedTo = attachment.getAttachedTo();
        this.m_attachmentName = attachment.getName();
        this.m_oldValue = PropertyUtil.getPropertyFieldObject(property, attachment);
        this.m_property = property;
    }

    AttachmentPropertyClear(Attachable attachTo, String attachmentName, Object oldValue, String property) {
        this.m_attachmentName = attachmentName;
        this.m_attachedTo = attachTo;
        this.m_oldValue = oldValue;
        this.m_property = property;
    }

    public Attachable getAttachedTo() {
        return this.m_attachedTo;
    }

    public String getAttachmentName() {
        return this.m_attachmentName;
    }

    public void perform(GameData data) {
        IAttachment attachment = this.m_attachedTo.getAttachment(this.m_attachmentName);
        PropertyUtil.clear(this.m_property, attachment);
    }

    public Change invert() {
        return new AttachmentPropertyClearUndo(this.m_attachedTo, this.m_attachmentName, this.m_oldValue, this.m_property);
    }

    public String toString() {
        return "AttachmentPropertyClear attached to:" + this.m_attachedTo + " name:" + this.m_attachmentName + ", cleared old value:" + this.m_oldValue;
    }
}

