/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import javax.swing.SwingUtilities;

public class ChangePerformer {
    private final GameData m_data;

    public ChangePerformer(GameData data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        this.m_data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Change aChange) {
        if (this.m_data.areChangesOnlyInSwingEventThread() && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        try {
            this.m_data.acquireWriteLock();
            aChange.perform(this.m_data);
        }
        finally {
            this.m_data.releaseWriteLock();
        }
        this.m_data.notifyGameDataChanged(aChange);
    }
}

