/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.CompositeRouteFinder;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.RouteFinder;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameMap
extends GameDataComponent
implements Iterable<Territory> {
    private static final long serialVersionUID = -4606700588396439283L;
    private final Collection<Territory> m_territories = new ArrayList<Territory>();
    private final Map<Territory, Set<Territory>> m_connections = new HashMap<Territory, Set<Territory>>();
    private final Map<String, Territory> m_territoryLookup = new HashMap<String, Territory>();
    private int[] m_gridDimensions = null;

    GameMap(GameData data) {
        super(data);
    }

    public void setGridDimensions(int ... gridDimensions) {
        this.m_gridDimensions = gridDimensions;
    }

    public int getXDimension() {
        if (this.m_gridDimensions == null || this.m_gridDimensions.length < 1) {
            return 0;
        }
        return this.m_gridDimensions[0];
    }

    public int getYDimension() {
        if (this.m_gridDimensions == null || this.m_gridDimensions.length < 2) {
            return 0;
        }
        return this.m_gridDimensions[1];
    }

    public Territory getTerritoryFromCoordinates(int ... coordinate) {
        if (this.m_gridDimensions == null) {
            return null;
        }
        if (!this.isCoordinateValid(coordinate)) {
            return null;
        }
        int listIndex = coordinate[0];
        int multiplier = 1;
        for (int i = 1; i < this.m_gridDimensions.length; ++i) {
            listIndex += coordinate[i] * (multiplier *= this.m_gridDimensions[i - 1]);
        }
        return (Territory)((ArrayList)this.m_territories).get(listIndex);
    }

    public boolean isCoordinateValid(int ... coordinate) {
        if (coordinate.length != this.m_gridDimensions.length) {
            return false;
        }
        for (int i = 0; i < this.m_gridDimensions.length; ++i) {
            if (coordinate[i] < this.m_gridDimensions[i] && coordinate[i] >= 0) continue;
            return false;
        }
        return true;
    }

    protected void addTerritory(Territory t1) {
        if (this.m_territories.contains(t1)) {
            throw new IllegalArgumentException("Map already contains " + t1.getName());
        }
        this.m_territories.add(t1);
        this.m_connections.put(t1, Collections.emptySet());
        this.m_territoryLookup.put(t1.getName(), t1);
    }

    protected void addConnection(Territory t1, Territory t2) {
        if (t1.equals(t2)) {
            throw new IllegalArgumentException("Cannot connect a territory to itself");
        }
        if (!this.m_territories.contains(t1) || !this.m_territories.contains(t2)) {
            throw new IllegalArgumentException("Map doesnt know about one of " + t1 + " " + t2);
        }
        this.setConnection(t1, t2);
        this.setConnection(t2, t1);
    }

    private void setConnection(Territory from, Territory to) {
        Set<Territory> current = this.m_connections.get(from);
        HashSet<Territory> modified = new HashSet<Territory>(current);
        modified.add(to);
        this.m_connections.put(from, Collections.unmodifiableSet(modified));
    }

    public Territory getTerritory(String s) {
        return this.m_territoryLookup.get(s);
    }

    public Set<Territory> getNeighbors(Territory t) {
        Set<Territory> neighbors = this.m_connections.get(t);
        if (neighbors == null) {
            throw new IllegalArgumentException("No neighbors for:" + t);
        }
        return neighbors;
    }

    public Set<Territory> getNeighbors(Territory t, Match<Territory> cond) {
        if (cond == null) {
            return this.getNeighbors(t);
        }
        Set<Territory> possible = this.m_connections.get(t);
        HashSet<Territory> passed = new HashSet<Territory>();
        if (possible == null) {
            return passed;
        }
        for (Territory current : possible) {
            if (!cond.match(current)) continue;
            passed.add(current);
        }
        return passed;
    }

    public Set<Territory> getNeighbors(Territory territory, int distance) {
        if (distance < 0) {
            throw new IllegalArgumentException("Distance must be positive not:" + distance);
        }
        if (distance == 0) {
            return Collections.EMPTY_SET;
        }
        Set<Territory> start = this.getNeighbors(territory);
        if (distance == 1) {
            return start;
        }
        Set<Territory> neighbors = this.getNeighbors(start, new HashSet<Territory>(start), --distance);
        neighbors.remove(territory);
        return neighbors;
    }

    public Set<Territory> getNeighbors(Territory territory, int distance, Match<Territory> cond) {
        if (distance < 0) {
            throw new IllegalArgumentException("Distance must be positive not:" + distance);
        }
        if (distance == 0) {
            return Collections.EMPTY_SET;
        }
        Set<Territory> start = this.getNeighbors(territory, cond);
        if (distance == 1) {
            return start;
        }
        Set<Territory> neighbors = this.getNeighbors(start, new HashSet<Territory>(start), --distance, cond);
        neighbors.remove(territory);
        return neighbors;
    }

    private Set<Territory> getNeighbors(Set<Territory> frontier, Set<Territory> searched, int distance, Match<Territory> cond) {
        if (distance == 0) {
            return searched;
        }
        Iterator<Territory> iter = frontier.iterator();
        HashSet<Territory> newFrontier = new HashSet<Territory>();
        while (iter.hasNext()) {
            Territory t = iter.next();
            newFrontier.addAll(this.getNeighbors(t, cond));
        }
        newFrontier.removeAll(searched);
        searched.addAll(newFrontier);
        return this.getNeighbors(newFrontier, searched, --distance, cond);
    }

    private Set<Territory> getNeighbors(Set<Territory> frontier, Set<Territory> searched, int distance) {
        if (distance == 0) {
            return searched;
        }
        Iterator<Territory> iter = frontier.iterator();
        HashSet<Territory> newFrontier = new HashSet<Territory>();
        while (iter.hasNext()) {
            Territory t = iter.next();
            newFrontier.addAll(this.getNeighbors(t));
        }
        newFrontier.removeAll(searched);
        searched.addAll(newFrontier);
        return this.getNeighbors(newFrontier, searched, --distance);
    }

    public Route getRoute(Territory t1, Territory t2) {
        return this.getRoute(t1, t2, Matches.TerritoryIsLandOrWater);
    }

    public Route getLandRoute(Territory t1, Territory t2) {
        return this.getRoute(t1, t2, Matches.TerritoryIsLand);
    }

    public Route getWaterRoute(Territory t1, Territory t2) {
        return this.getRoute(t1, t2, Matches.TerritoryIsWater);
    }

    public Route getRoute(Territory t1, Territory t2, Match<Territory> cond) {
        if (t1 == t2) {
            return new Route(t1, new Territory[0]);
        }
        if (this.getNeighbors(t1, cond).contains(t2)) {
            return new Route(t1, t2);
        }
        RouteFinder engine = new RouteFinder(this, cond);
        return engine.findRoute(t1, t2);
    }

    public Route getRoute_IgnoreEnd(Territory t1, Territory t2, Match<Territory> match) {
        return this.getRoute(t1, t2, new CompositeMatchOr<Territory>(Matches.territoryIs(t2), match));
    }

    public Route getCompositeRoute(Territory t1, Territory t2, HashMap<Match<Territory>, Integer> matches) {
        if (t1 == t2) {
            return new Route(t1, new Territory[0]);
        }
        CompositeMatchOr<Territory> allCond = new CompositeMatchOr<Territory>(matches.keySet());
        if (this.getNeighbors(t1, allCond).contains(t2)) {
            return new Route(t1, t2);
        }
        CompositeRouteFinder engine = new CompositeRouteFinder(this, matches);
        return engine.findRoute(t1, t2);
    }

    public Route getCompositeRoute_IgnoreEnd(Territory t1, Territory t2, HashMap<Match<Territory>, Integer> matches) {
        matches.put(Matches.territoryIs(t2), 0);
        return this.getCompositeRoute(t1, t2, matches);
    }

    public int getDistance(Territory t1, Territory t2) {
        return this.getDistance(t1, t2, Matches.TerritoryIsLandOrWater);
    }

    public int getLandDistance(Territory t1, Territory t2) {
        return this.getDistance(t1, t2, Matches.TerritoryIsLand);
    }

    public int getWaterDistance(Territory t1, Territory t2) {
        return this.getDistance(t1, t2, Matches.TerritoryIsWater);
    }

    public int getDistance(Territory t1, Territory t2, Match<Territory> cond) {
        if (t1.equals(t2)) {
            return 0;
        }
        HashSet<Territory> frontier = new HashSet<Territory>();
        frontier.add(t1);
        return this.getDistance(0, new HashSet<Territory>(), frontier, t2, cond);
    }

    private int getDistance(int distance, Set<Territory> searched, Set<Territory> frontier, Territory target, Match<Territory> cond) {
        searched.addAll(frontier);
        HashSet<Territory> newFrontier = new HashSet<Territory>();
        for (Territory onFrontier : frontier) {
            Set<Territory> connections = this.m_connections.get(onFrontier);
            for (Territory nextFrontier : connections) {
                if (!cond.match(nextFrontier)) continue;
                newFrontier.add(nextFrontier);
            }
        }
        if (newFrontier.contains(target)) {
            return distance + 1;
        }
        newFrontier.removeAll(searched);
        if (newFrontier.isEmpty()) {
            return -1;
        }
        return this.getDistance(distance + 1, searched, newFrontier, target, cond);
    }

    public Collection<Territory> getTerritories() {
        return Collections.unmodifiableCollection(this.m_territories);
    }

    @Override
    public Iterator<Territory> iterator() {
        return this.m_territories.iterator();
    }

    public Collection<Territory> getTerritoriesOwnedBy(PlayerID player) {
        Iterator<Territory> iter = this.m_territories.iterator();
        ArrayList<Territory> owner = new ArrayList<Territory>();
        while (iter.hasNext()) {
            Territory territory = iter.next();
            if (!territory.getOwner().equals(player)) continue;
            owner.add(territory);
        }
        return owner;
    }

    public boolean isValidRoute(Route route) {
        Territory previous = null;
        for (Territory t : route) {
            if (previous != null && !this.getNeighbors(previous).contains(t)) {
                return false;
            }
            previous = t;
        }
        return true;
    }
}

