/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.AllianceTracker;
import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DelegateList;
import games.strategy.engine.data.EngineVersionException;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerList;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionFrontierList;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.RelationshipTypeList;
import games.strategy.engine.data.RepairFrontier;
import games.strategy.engine.data.RepairFrontierList;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.data.TechnologyFrontierList;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.data.properties.BooleanProperty;
import games.strategy.engine.data.properties.ColorProperty;
import games.strategy.engine.data.properties.FileProperty;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.data.properties.ListProperty;
import games.strategy.engine.data.properties.NumberProperty;
import games.strategy.engine.data.properties.StringProperty;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.triplea.TripleA;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.GenericTechAdvance;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.Tuple;
import games.strategy.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameParser {
    private static final Class<?>[] SETTER_ARGS = new Class[]{String.class};
    private GameData data;
    private final Collection<SAXParseException> errorsSAX = new ArrayList<SAXParseException>();
    private static HashMap<String, String> newClassesForOldNames;

    public synchronized GameData parse(InputStream stream, boolean delayParsing) throws GameParseException, SAXException, EngineVersionException {
        Element initialization;
        Element attachmentList;
        Element territoryEffectList;
        Element relationshipTypes;
        Element unitList;
        if (stream == null) {
            throw new IllegalArgumentException("Stream must be non null");
        }
        Document doc = null;
        try {
            doc = this.getDocument(stream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        Element root = doc.getDocumentElement();
        this.data = new GameData();
        this.parseInfo(this.getSingleChild("info", root));
        this.parseGameLoader(this.getSingleChild("loader", root));
        this.parseMinimumEngineVersionNumber(this.getSingleChild("triplea", root, true));
        if (!this.errorsSAX.isEmpty()) {
            for (SAXParseException error : this.errorsSAX) {
                System.err.println("SAXParseException: game: " + (this.data == null ? "?" : (this.data.getGameName() == null ? "?" : this.data.getGameName())) + ", line: " + error.getLineNumber() + ", column: " + error.getColumnNumber() + ", error: " + error.getMessage());
            }
        }
        this.parseDiceSides(this.getSingleChild("diceSides", root, true));
        Element playerListNode = this.getSingleChild("playerList", root);
        this.parsePlayerList(playerListNode);
        this.parseAlliances(playerListNode);
        Element properties = this.getSingleChild("propertyList", root, true);
        if (properties != null) {
            this.parseProperties(properties);
        }
        if (delayParsing) {
            return this.data;
        }
        this.parseMap(this.getSingleChild("map", root));
        Element resourceList = this.getSingleChild("resourceList", root, true);
        if (resourceList != null) {
            this.parseResources(resourceList);
        }
        if ((unitList = this.getSingleChild("unitList", root, true)) != null) {
            this.parseUnits(unitList);
        }
        if ((relationshipTypes = this.getSingleChild("relationshipTypes", root, true)) != null) {
            this.parseRelationshipTypes(relationshipTypes);
        }
        if ((territoryEffectList = this.getSingleChild("territoryEffectList", root, true)) != null) {
            this.parseTerritoryEffects(territoryEffectList);
        }
        this.parseGamePlay(this.getSingleChild("gamePlay", root));
        Element production = this.getSingleChild("production", root, true);
        if (production != null) {
            this.parseProduction(production);
        }
        TechAdvance.setStaticTechs(this.data);
        Element technology = this.getSingleChild("technology", root, true);
        if (technology != null) {
            this.parseTechnology(technology);
        }
        if ((attachmentList = this.getSingleChild("attatchmentList", root, true)) != null) {
            this.parseAttachments(attachmentList);
        }
        if ((initialization = this.getSingleChild("initialize", root, true)) != null) {
            this.parseInitialization(initialization);
        }
        this.data.getRelationshipTracker().setNullPlayerRelations();
        this.data.getRelationshipTracker().setSelfRelations();
        if (this.data.getGameLoader() instanceof TripleA) {
            this.checkThatAllUnitsHaveAttachments(this.data);
            TechAbilityAttachment.setDefaultTechnologyAttachments(this.data);
        }
        try {
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GameParseException(e.getMessage());
        }
        return this.data;
    }

    private void parseDiceSides(Node diceSides) {
        if (diceSides == null) {
            this.data.setDiceSides(6);
        } else {
            this.data.setDiceSides(Integer.parseInt(((Element)diceSides).getAttribute("value")));
        }
    }

    private void parseMinimumEngineVersionNumber(Node minimumVersion) throws EngineVersionException {
        if (minimumVersion == null) {
            return;
        }
        Version mapCompatibleWithTripleaVersion = new Version(((Element)minimumVersion).getAttribute("minimumVersion"));
        if (mapCompatibleWithTripleaVersion.isGreaterThan(EngineVersion.VERSION, true)) {
            throw new EngineVersionException("Trying to play a map made for a newer version of TripleA. Map named '" + this.data.getGameName() + "' requires at least TripleA version " + mapCompatibleWithTripleaVersion.toString());
        }
    }

    private void validate() throws GameParseException {
        for (UnitType unitType : this.data.getUnitTypeList()) {
            this.validateAttachments(unitType);
        }
        for (Territory territory : this.data.getMap()) {
            this.validateAttachments(territory);
        }
        for (Resource resource : this.data.getResourceList().getResources()) {
            this.validateAttachments(resource);
        }
        for (PlayerID playerID : this.data.getPlayerList().getPlayers()) {
            this.validateAttachments(playerID);
        }
        for (RelationshipType relationshipType : this.data.getRelationshipTypeList().getAllRelationshipTypes()) {
            this.validateAttachments(relationshipType);
        }
        for (TerritoryEffect territoryEffect : this.data.getTerritoryEffectList().values()) {
            this.validateAttachments(territoryEffect);
        }
        this.validateRelationships();
    }

    private void validateRelationships() throws GameParseException {
        for (PlayerID player : this.data.getPlayerList()) {
            for (PlayerID player2 : this.data.getPlayerList()) {
                if (this.data.getRelationshipTracker().getRelationshipType(player, player2) != null) continue;
                throw new GameParseException("No relation set for: " + player.getName() + " and " + player2.getName());
            }
        }
    }

    private void validateAttachments(Attachable attachable) throws GameParseException {
        for (IAttachment a : attachable.getAttachments().values()) {
            a.validate(this.data);
        }
    }

    private Document getDocument(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        URL url = GameParser.class.getResource("/games/strategy/engine/xml/");
        String system = url.toExternalForm();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ErrorHandler myErrorHandler = new ErrorHandler(){

            public void fatalError(SAXParseException exception) throws SAXException {
                GameParser.this.errorsSAX.add(exception);
            }

            public void error(SAXParseException exception) throws SAXException {
                GameParser.this.errorsSAX.add(exception);
            }

            public void warning(SAXParseException exception) throws SAXException {
                GameParser.this.errorsSAX.add(exception);
            }
        };
        builder.setErrorHandler(myErrorHandler);
        return builder.parse(input, system);
    }

    private PlayerID getPlayerID(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        PlayerID player = this.data.getPlayerList().getPlayerID(name);
        if (player == null && mustFind) {
            throw new GameParseException("Could not find player. name:" + name);
        }
        return player;
    }

    private RelationshipType getRelationshipType(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        RelationshipType relation = this.data.getRelationshipTypeList().getRelationshipType(name);
        if (relation == null && mustFind) {
            throw new GameParseException("Could not find relation name:" + name);
        }
        return relation;
    }

    private TerritoryEffect getTerritoryEffect(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        TerritoryEffect effect = this.data.getTerritoryEffectList().get(name);
        if (effect == null && mustFind) {
            throw new GameParseException("Could not find territoryEffect name:" + name);
        }
        return effect;
    }

    private ProductionRule getProductionRule(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        ProductionRule productionRule = this.data.getProductionRuleList().getProductionRule(name);
        if (productionRule == null && mustFind) {
            throw new GameParseException("Could not find production rule. name:" + name);
        }
        return productionRule;
    }

    private RepairRule getRepairRule(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        RepairRule repairRule = this.data.getRepairRuleList().getRepairRule(name);
        if (repairRule == null && mustFind) {
            throw new GameParseException("Could not find production rule. name:" + name);
        }
        return repairRule;
    }

    private Territory getTerritory(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        Territory territory = this.data.getMap().getTerritory(name);
        if (territory == null && mustFind) {
            throw new GameParseException("Could not find territory. name:" + name);
        }
        return territory;
    }

    private UnitType getUnitType(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        UnitType type = this.data.getUnitTypeList().getUnitType(name);
        if (type == null && mustFind) {
            throw new GameParseException("Could not find unitType. name:" + name);
        }
        return type;
    }

    private TechAdvance getTechnology(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        TechAdvance type = this.data.getTechnologyFrontier().getAdvanceByName(name);
        if (type == null) {
            type = this.data.getTechnologyFrontier().getAdvanceByProperty(name);
        }
        if (type == null && mustFind) {
            throw new GameParseException("Could not find technology. name:" + name);
        }
        return type;
    }

    private IDelegate getDelegate(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        IDelegate delegate = this.data.getDelegateList().getDelegate(name);
        if (delegate == null && mustFind) {
            throw new GameParseException("Could not find delegate. name:" + name);
        }
        return delegate;
    }

    private Resource getResource(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        Resource resource = this.data.getResourceList().getResource(name);
        if (resource == null && mustFind) {
            throw new GameParseException("Could not find resource. name:" + name);
        }
        return resource;
    }

    private ProductionFrontier getProductionFrontier(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        ProductionFrontier productionFrontier = this.data.getProductionFrontierList().getProductionFrontier(name);
        if (productionFrontier == null && mustFind) {
            throw new GameParseException("Could not find production frontier. name:" + name);
        }
        return productionFrontier;
    }

    private RepairFrontier getRepairFrontier(Element element, String attribute, boolean mustFind) throws GameParseException {
        String name = element.getAttribute(attribute);
        RepairFrontier repairFrontier = this.data.getRepairFrontierList().getRepairFrontier(name);
        if (repairFrontier == null && mustFind) {
            throw new GameParseException("Could not find production frontier. name:" + name);
        }
        return repairFrontier;
    }

    private Object getInstance(String className) throws GameParseException {
        Object instance = null;
        try {
            Class<?> instanceClass = Class.forName(className);
            instance = instanceClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new GameParseException("Class <" + className + "> could not be found.");
        }
        catch (InstantiationException ie) {
            throw new GameParseException("Class <" + className + "> could not be instantiated. ->" + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new GameParseException("Constructor could not be accessed ->" + iae.getMessage());
        }
        return instance;
    }

    private Class<?> getClassByName(String className) throws GameParseException {
        try {
            Class<?> instanceClass = Class.forName(className);
            return instanceClass;
        }
        catch (ClassNotFoundException cnfe) {
            String newClassName;
            if (newClassesForOldNames == null) {
                newClassesForOldNames = new HashMap();
            }
            if ((newClassName = newClassesForOldNames.get(className)) != null) {
                return this.getClassByName(newClassName);
            }
            throw new GameParseException("Class <" + className + "> could not be found.");
        }
    }

    private Element getSingleChild(String name, Element node) throws GameParseException {
        return this.getSingleChild(name, node, false);
    }

    private Element getSingleChild(String name, Node node, boolean optional) throws GameParseException {
        List<Element> children = this.getChildren(name, node);
        if (children.size() == 0) {
            if (optional) {
                return null;
            }
            throw new GameParseException("No child called " + name);
        }
        if (children.size() > 1) {
            throw new GameParseException("Too many children named " + name);
        }
        return children.get(0);
    }

    private List<Element> getChildren(String name, Node node) {
        ArrayList<Element> found = new ArrayList<Element>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (!current.getNodeName().equals(name)) continue;
            found.add((Element)current);
        }
        return found;
    }

    private List<Node> getNonTextNodesIgnoring(Node node, String ignore) {
        List<Node> rVal = this.getNonTextNodes(node);
        Iterator<Node> iter = rVal.iterator();
        while (iter.hasNext()) {
            if (!((Element)iter.next()).getTagName().equals(ignore)) continue;
            iter.remove();
        }
        return rVal;
    }

    private List<Node> getNonTextNodes(Node node) {
        ArrayList<Node> found = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (current.getNodeType() == 3) continue;
            found.add(current);
        }
        return found;
    }

    private void parseInfo(Node info) {
        String gameName = ((Element)info).getAttribute("name");
        this.data.setGameName(gameName);
        String version = ((Element)info).getAttribute("version");
        this.data.setGameVersion(new Version(version));
    }

    private void parseGameLoader(Node loader) throws GameParseException {
        String className = ((Element)loader).getAttribute("javaClass");
        Object instance = this.getInstance(className);
        if (!(instance instanceof IGameLoader)) {
            throw new GameParseException("Loader must implement IGameLoader.  Class Name:" + className);
        }
        this.data.setGameLoader((IGameLoader)instance);
    }

    private void parseMap(Node map) throws GameParseException {
        List<Element> grids = this.getChildren("grid", map);
        this.parseGrids(grids);
        List<Element> territories = this.getChildren("territory", map);
        this.parseTerritories(territories);
        List<Element> connections = this.getChildren("connection", map);
        this.parseConnections(connections);
    }

    private void parseGrids(List<Element> grids) throws GameParseException {
        GameMap map = this.data.getMap();
        for (Element current : grids) {
            Territory to;
            Territory newTerritory;
            int x;
            int y;
            boolean diagonalConnectionsImplict;
            boolean verticalConnectionsImplict;
            boolean horizontalConnectionsImplict;
            List<Element> waterNodes = this.getChildren("water", current);
            Set<String> water = this.parseGridWater(waterNodes);
            String horizontalConnections = current.getAttribute("horizontal-connections");
            if (horizontalConnections.equals("implicit")) {
                horizontalConnectionsImplict = true;
            } else if (horizontalConnections.equals("explicit")) {
                horizontalConnectionsImplict = false;
            } else {
                throw new GameParseException("horizontal-connections attribute must be either \"explicit\" or \"implicit\"");
            }
            String verticalConnections = current.getAttribute("vertical-connections");
            if (verticalConnections.equals("implicit")) {
                verticalConnectionsImplict = true;
            } else if (verticalConnections.equals("explicit")) {
                verticalConnectionsImplict = false;
            } else {
                throw new GameParseException("vertical-connections attribute must be either \"explicit\" or \"implicit\"");
            }
            String diagonalConnections = current.getAttribute("diagonal-connections");
            if (diagonalConnections.equals("implicit")) {
                diagonalConnectionsImplict = true;
            } else if (diagonalConnections.equals("explicit")) {
                diagonalConnectionsImplict = false;
            } else {
                throw new GameParseException("diagonal-connections attribute must be either \"explicit\" or \"implicit\"");
            }
            String gridType = current.getAttribute("type");
            String name = current.getAttribute("name");
            String xs = current.getAttribute("x");
            String ys = current.getAttribute("y");
            int x_size = Integer.valueOf(xs);
            int y_size = ys != null ? Integer.valueOf(ys) : 0;
            map.setGridDimensions(x_size, y_size);
            if (gridType.equals("square")) {
                for (y = 0; y < y_size; ++y) {
                    for (x = 0; x < x_size; ++x) {
                        boolean isWater = water.contains(x + "-" + y);
                        newTerritory = new Territory(name + "_" + x + "_" + y, isWater, this.data, x, y);
                        map.addTerritory(newTerritory);
                    }
                }
                if (horizontalConnectionsImplict) {
                    for (y = 0; y < y_size; ++y) {
                        for (x = 0; x < x_size - 1; ++x) {
                            map.addConnection(map.getTerritoryFromCoordinates(x, y), map.getTerritoryFromCoordinates(x + 1, y));
                        }
                    }
                }
                if (verticalConnectionsImplict) {
                    for (int x2 = 0; x2 < x_size; ++x2) {
                        for (int y2 = 0; y2 < y_size - 1; ++y2) {
                            map.addConnection(map.getTerritoryFromCoordinates(x2, y2), map.getTerritoryFromCoordinates(x2, y2 + 1));
                        }
                    }
                }
                if (diagonalConnectionsImplict) {
                    for (y = 0; y < y_size - 1; ++y) {
                        for (x = 0; x < x_size - 1; ++x) {
                            map.addConnection(map.getTerritoryFromCoordinates(x, y), map.getTerritoryFromCoordinates(x + 1, y + 1));
                        }
                    }
                }
                if (!diagonalConnectionsImplict) continue;
                for (y = 0; y < y_size - 1; ++y) {
                    for (x = 1; x < x_size; ++x) {
                        map.addConnection(map.getTerritoryFromCoordinates(x, y), map.getTerritoryFromCoordinates(x - 1, y + 1));
                    }
                }
                continue;
            }
            if (!gridType.equals("points-and-lines")) continue;
            for (y = 0; y < y_size; ++y) {
                for (x = 0; x < x_size; ++x) {
                    boolean isWater = false;
                    if (water.contains(x + "-" + y)) continue;
                    newTerritory = new Territory(name + "_" + x + "_" + y, false, this.data, x, y);
                    map.addTerritory(newTerritory);
                }
            }
            if (horizontalConnectionsImplict) {
                for (y = 0; y < y_size; ++y) {
                    for (x = 0; x < x_size - 1; ++x) {
                        Territory from = map.getTerritoryFromCoordinates(x, y);
                        to = map.getTerritoryFromCoordinates(x + 1, y);
                        if (from == null || to == null) continue;
                        map.addConnection(from, to);
                    }
                }
            }
            if (diagonalConnectionsImplict) {
                for (y = 1; y < y_size; ++y) {
                    for (x = 0; x < x_size - 1; ++x) {
                        Territory from;
                        if (y % 4 == 0 || (y + 1) % 4 == 0) {
                            from = map.getTerritoryFromCoordinates(x, y);
                            to = map.getTerritoryFromCoordinates(x, y - 1);
                            if (from == null || to == null) continue;
                            map.addConnection(from, to);
                            continue;
                        }
                        from = map.getTerritoryFromCoordinates(x, y);
                        to = map.getTerritoryFromCoordinates(x + 1, y - 1);
                        if (from == null || to == null) continue;
                        map.addConnection(from, to);
                    }
                }
            }
            if (!diagonalConnectionsImplict) continue;
            for (y = 1; y < y_size; ++y) {
                for (x = 0; x < x_size - 1; ++x) {
                    Territory from;
                    if (y % 4 == 0 || (y + 1) % 4 == 0) {
                        from = map.getTerritoryFromCoordinates(x, y);
                        to = map.getTerritoryFromCoordinates(x - 1, y - 1);
                        if (from == null || to == null) continue;
                        map.addConnection(from, to);
                        continue;
                    }
                    from = map.getTerritoryFromCoordinates(x, y);
                    to = map.getTerritoryFromCoordinates(x, y - 1);
                    if (from == null || to == null) continue;
                    map.addConnection(from, to);
                }
            }
        }
    }

    private Set<String> parseGridWater(List<Element> waterNodes) {
        HashSet<String> set = new HashSet<String>();
        for (Element current : waterNodes) {
            int x = Integer.valueOf(current.getAttribute("x"));
            int y = Integer.valueOf(current.getAttribute("y"));
            set.add(x + "-" + y);
        }
        return set;
    }

    private void parseTerritories(List<Element> territories) {
        GameMap map = this.data.getMap();
        for (Element current : territories) {
            boolean water = current.getAttribute("water").trim().equalsIgnoreCase("true");
            String name = current.getAttribute("name");
            Territory newTerritory = new Territory(name, water, this.data);
            map.addTerritory(newTerritory);
        }
    }

    private void parseConnections(List<Element> connections) throws GameParseException {
        GameMap map = this.data.getMap();
        for (Element current : connections) {
            Territory t1 = this.getTerritory(current, "t1", true);
            Territory t2 = this.getTerritory(current, "t2", true);
            map.addConnection(t1, t2);
        }
    }

    private void parseResources(Element root) {
        Iterator<Element> iter = this.getChildren("resource", root).iterator();
        while (iter.hasNext()) {
            this.data.getResourceList().addResource(new Resource(iter.next().getAttribute("name"), this.data));
        }
    }

    private void parseRelationshipTypes(Element root) {
        Iterator<Element> iter = this.getChildren("relationshipType", root).iterator();
        while (iter.hasNext()) {
            this.data.getRelationshipTypeList().addRelationshipType(new RelationshipType(iter.next().getAttribute("name"), this.data));
        }
    }

    private void parseTerritoryEffects(Element root) {
        Iterator<Element> iter = this.getChildren("territoryEffect", root).iterator();
        while (iter.hasNext()) {
            String name = iter.next().getAttribute("name");
            this.data.getTerritoryEffectList().put(name, new TerritoryEffect(name, this.data));
        }
    }

    private void parseUnits(Element root) {
        Iterator<Element> iter = this.getChildren("unit", root).iterator();
        while (iter.hasNext()) {
            this.data.getUnitTypeList().addUnitType(new UnitType(iter.next().getAttribute("name"), this.data));
        }
    }

    private void parsePlayerList(Element root) {
        PlayerList playerList = this.data.getPlayerList();
        for (Element current : this.getChildren("player", root)) {
            String name = current.getAttribute("name");
            boolean isOptional = current.getAttribute("optional").equals("true");
            PlayerID newPlayer = new PlayerID(name, isOptional, this.data);
            playerList.addPlayerID(newPlayer);
        }
    }

    private void parseAlliances(Element root) throws GameParseException {
        AllianceTracker allianceTracker = this.data.getAllianceTracker();
        Collection<PlayerID> players = this.data.getPlayerList().getPlayers();
        for (Element current : this.getChildren("alliance", root)) {
            PlayerID p1 = this.getPlayerID(current, "player", true);
            String alliance = current.getAttribute("alliance");
            allianceTracker.addToAlliance(p1, alliance);
        }
        if (this.getSingleChild("relationshipInitialize", root, true) == null) {
            RelationshipTracker relationshipTracker = this.data.getRelationshipTracker();
            RelationshipTypeList relationshipTypeList = this.data.getRelationshipTypeList();
            for (PlayerID currentPlayer : players) {
                HashSet<PlayerID> enemies = new HashSet<PlayerID>(players);
                HashSet<PlayerID> allies = new HashSet<PlayerID>();
                if (allianceTracker.getAlliancesMap().get(currentPlayer) != null) {
                    for (String alliance : allianceTracker.getAlliancesMap().get(currentPlayer)) {
                        for (PlayerID alliedPlayer : allianceTracker.getPlayersInAlliance(alliance)) {
                            allies.add(alliedPlayer);
                            enemies.remove(alliedPlayer);
                        }
                    }
                }
                enemies.remove(currentPlayer);
                allies.remove(currentPlayer);
                for (PlayerID alliedPLayer : allies) {
                    relationshipTracker.setRelationship(currentPlayer, alliedPLayer, relationshipTypeList.getDefaultAlliedRelationship());
                }
                for (PlayerID enemyPlayer : enemies) {
                    relationshipTracker.setRelationship(currentPlayer, enemyPlayer, relationshipTypeList.getDefaultWarRelationship());
                }
            }
        }
    }

    private void parseRelationInitialize(List<Element> relations) throws GameParseException {
        if (relations.size() > 0) {
            RelationshipTracker tracker = this.data.getRelationshipTracker();
            for (Element current : relations) {
                PlayerID p1 = this.getPlayerID(current, "player1", true);
                PlayerID p2 = this.getPlayerID(current, "player2", true);
                RelationshipType r = this.getRelationshipType(current, "type", true);
                int roundValue = Integer.valueOf(current.getAttribute("roundValue"));
                tracker.setRelationship(p1, p2, r, roundValue);
            }
        }
    }

    private void parseGamePlay(Element root) throws GameParseException {
        this.parseDelegates(this.getChildren("delegate", root));
        this.parseSequence(this.getSingleChild("sequence", root));
    }

    private void parseProperties(Node root) throws GameParseException {
        ArrayList<String> runningList = new ArrayList<String>();
        GameProperties properties = this.data.getProperties();
        for (Element current : this.getChildren("property", root)) {
            int intValue;
            Element valueNode;
            List<Element> valueChildren;
            String editable = current.getAttribute("editable");
            String property = current.getAttribute("name");
            String value = current.getAttribute("value");
            runningList.add(property);
            if (!(value != null && value.length() != 0 || (valueChildren = this.getChildren("value", current)).isEmpty() || (valueNode = valueChildren.get(0)) == null)) {
                value = valueNode.getTextContent();
            }
            if (editable != null && editable.equalsIgnoreCase("true")) {
                this.parseEditableProperty(current, property, value);
                continue;
            }
            List<Node> children2 = this.getNonTextNodesIgnoring(current, "value");
            if (children2.size() == 0) {
                try {
                    Integer integer = Integer.parseInt(value);
                    intValue = 0;
                    if (integer != null) {
                        intValue = integer;
                    }
                    properties.set(property, intValue);
                }
                catch (NumberFormatException e) {
                    properties.set(property, value);
                }
                continue;
            }
            String type = children2.get(0).getNodeName();
            if (type.equals("boolean")) {
                properties.set(property, Boolean.valueOf(value));
                continue;
            }
            if (type.equals("file")) {
                properties.set(property, new File(value));
                continue;
            }
            if (type.equals("number")) {
                intValue = 0;
                if (value != null) {
                    try {
                        intValue = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                properties.set(property, intValue);
                continue;
            }
            properties.set(property, value);
        }
        if (this.data.getGameLoader() instanceof TripleA) {
            if (!runningList.contains("AI Bonus Income Flat Rate")) {
                this.data.getProperties().addEditableProperty(new NumberProperty("AI Bonus Income Flat Rate", 40, -20, 0));
            }
            if (!runningList.contains("AI Bonus Income Percentage")) {
                this.data.getProperties().addEditableProperty(new NumberProperty("AI Bonus Income Percentage", 200, -100, 0));
            }
            if (!runningList.contains("AI Bonus Attack")) {
                this.data.getProperties().addEditableProperty(new NumberProperty("AI Bonus Attack", this.data.getDiceSides(), 0, 0));
            }
            if (!runningList.contains("AI Bonus Defense")) {
                this.data.getProperties().addEditableProperty(new NumberProperty("AI Bonus Defense", this.data.getDiceSides(), 0, 0));
            }
        }
    }

    private void parseEditableProperty(Element property, String name, String defaultValue) throws GameParseException {
        AEditableProperty editableProperty;
        List<Node> children = this.getNonTextNodes(property);
        if (children.size() != 1) {
            throw new GameParseException("Editable properties must have exactly 1 child specifying the type. Number of children found:" + children.size() + " for node:" + property.getNodeName());
        }
        Element child = (Element)children.get(0);
        String childName = child.getNodeName();
        if (childName.equals("boolean")) {
            editableProperty = new BooleanProperty(name, Boolean.valueOf(defaultValue));
        } else if (childName.equals("file")) {
            editableProperty = new FileProperty(name, defaultValue);
        } else if (childName.equals("list")) {
            StringTokenizer tokenizer = new StringTokenizer(child.getAttribute("values"), ",");
            ArrayList<String> values = new ArrayList<String>();
            while (tokenizer.hasMoreElements()) {
                values.add(tokenizer.nextToken());
            }
            editableProperty = new ListProperty(name, defaultValue, values);
        } else if (childName.equals("number")) {
            int max = Integer.valueOf(child.getAttribute("max"));
            int min = Integer.valueOf(child.getAttribute("min"));
            int def = Integer.valueOf(defaultValue);
            editableProperty = new NumberProperty(name, max, min, def);
        } else if (childName.equals("color")) {
            int def = Integer.valueOf(defaultValue, 16);
            editableProperty = new ColorProperty(name, def);
        } else if (childName.equals("string")) {
            editableProperty = new StringProperty(name, defaultValue);
        } else {
            throw new GameParseException("Unrecognized property type:" + childName);
        }
        this.data.getProperties().addEditableProperty(editableProperty);
    }

    private void parseDelegates(List<Element> delegateList) throws GameParseException {
        DelegateList delegates = this.data.getDelegateList();
        for (Element current : delegateList) {
            String className = current.getAttribute("javaClass");
            IDelegate delegate = null;
            try {
                delegate = (IDelegate)this.getInstance(className);
            }
            catch (ClassCastException cce) {
                throw new GameParseException("Class <" + className + "> is not a delegate.");
            }
            String name = current.getAttribute("name");
            String displayName = current.getAttribute("display");
            if (displayName == null) {
                displayName = name;
            }
            delegate.initialize(name, displayName);
            delegates.addDelegate(delegate);
        }
    }

    private void parseSequence(Node sequence) throws GameParseException {
        this.parseSteps(this.getChildren("step", sequence));
    }

    private void parseSteps(List<Element> stepList) throws GameParseException {
        for (Element current : stepList) {
            IDelegate delegate = this.getDelegate(current, "delegate", true);
            PlayerID player = this.getPlayerID(current, "player", false);
            String name = current.getAttribute("name");
            String displayName = null;
            List<Element> propertyElements = this.getChildren("stepProperty", current);
            Properties stepProperties = this.pareStepProperties(propertyElements);
            if (current.hasAttribute("display")) {
                displayName = current.getAttribute("display");
            }
            GameStep step = new GameStep(name, displayName, player, delegate, this.data, stepProperties);
            if (current.hasAttribute("maxRunCount")) {
                int runCount = Integer.parseInt(current.getAttribute("maxRunCount"));
                if (runCount <= 0) {
                    throw new GameParseException("maxRunCount must be positive");
                }
                step.setMaxRunCount(runCount);
            }
            this.data.getSequence().addStep(step);
        }
    }

    private Properties pareStepProperties(List<Element> properties) {
        Properties rVal = new Properties();
        for (Element stepProperty : properties) {
            String name = stepProperty.getAttribute("name");
            String value = stepProperty.getAttribute("value");
            rVal.setProperty(name, value);
        }
        return rVal;
    }

    private void parseProduction(Node root) throws GameParseException {
        this.parseProductionRules(this.getChildren("productionRule", root));
        this.parseProductionFrontiers(this.getChildren("productionFrontier", root));
        this.parsePlayerProduction(this.getChildren("playerProduction", root));
        this.parseRepairRules(this.getChildren("repairRule", root));
        this.parseRepairFrontiers(this.getChildren("repairFrontier", root));
        this.parsePlayerRepair(this.getChildren("playerRepair", root));
    }

    private void parseTechnology(Node root) throws GameParseException {
        this.parseTechnologies(this.getSingleChild("technologies", root, false));
        this.parsePlayerTech(this.getChildren("playerTech", root));
    }

    private void parseProductionRules(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            String name = current.getAttribute("name");
            ProductionRule rule = new ProductionRule(name, this.data);
            this.parseCosts(rule, this.getChildren("cost", current));
            this.parseResults(rule, this.getChildren("result", current));
            this.data.getProductionRuleList().addProductionRule(rule);
        }
    }

    private void parseRepairRules(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            String name = current.getAttribute("name");
            RepairRule rule = new RepairRule(name, this.data);
            this.parseRepairCosts(rule, this.getChildren("cost", current));
            this.parseRepairResults(rule, this.getChildren("result", current));
            this.data.getRepairRuleList().addRepairRule(rule);
        }
    }

    private void parseCosts(ProductionRule rule, List<Element> elements) throws GameParseException {
        if (elements.size() == 0) {
            throw new GameParseException("no costs  for rule:" + rule.getName());
        }
        for (Element current : elements) {
            Resource resource = this.getResource(current, "resource", true);
            int quantity = Integer.parseInt(current.getAttribute("quantity"));
            rule.addCost(resource, quantity);
        }
    }

    private void parseRepairCosts(RepairRule rule, List<Element> elements) throws GameParseException {
        if (elements.size() == 0) {
            throw new GameParseException("no costs  for rule:" + rule.getName());
        }
        for (Element current : elements) {
            Resource resource = this.getResource(current, "resource", true);
            int quantity = Integer.parseInt(current.getAttribute("quantity"));
            rule.addCost(resource, quantity);
        }
    }

    private void parseResults(ProductionRule rule, List<Element> elements) throws GameParseException {
        if (elements.size() == 0) {
            throw new GameParseException("no results  for rule:" + rule.getName());
        }
        for (Element current : elements) {
            NamedAttachable result = null;
            result = this.getResource(current, "resourceOrUnit", false);
            if (result == null) {
                result = this.getUnitType(current, "resourceOrUnit", false);
            }
            if (result == null) {
                throw new GameParseException("Could not find resource or unit" + current.getAttribute("resourceOrUnit"));
            }
            int quantity = Integer.parseInt(current.getAttribute("quantity"));
            rule.addResult(result, quantity);
        }
    }

    private void parseRepairResults(RepairRule rule, List<Element> elements) throws GameParseException {
        if (elements.size() == 0) {
            throw new GameParseException("no results  for rule:" + rule.getName());
        }
        for (Element current : elements) {
            NamedAttachable result = null;
            result = this.getResource(current, "resourceOrUnit", false);
            if (result == null) {
                result = this.getUnitType(current, "resourceOrUnit", false);
            }
            if (result == null) {
                throw new GameParseException("Could not find resource or unit" + current.getAttribute("resourceOrUnit"));
            }
            int quantity = Integer.parseInt(current.getAttribute("quantity"));
            rule.addResult(result, quantity);
        }
    }

    private void parseProductionFrontiers(List<Element> elements) throws GameParseException {
        ProductionFrontierList frontiers = this.data.getProductionFrontierList();
        for (Element current : elements) {
            String name = current.getAttribute("name");
            ProductionFrontier frontier = new ProductionFrontier(name, this.data);
            this.parseFrontierRules(this.getChildren("frontierRules", current), frontier);
            frontiers.addProductionFrontier(frontier);
        }
    }

    private void parseTechnologies(Node element) {
        TechnologyFrontier techs = this.data.getTechnologyFrontier();
        this.parseTechs(this.getChildren("techname", element), techs);
    }

    private void parsePlayerTech(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            PlayerID player = this.getPlayerID(current, "player", true);
            TechnologyFrontierList categories = player.getTechnologyFrontierList();
            this.parseCategories(this.getChildren("category", current), categories);
        }
    }

    private void parseCategories(List<Element> elements, TechnologyFrontierList categories) throws GameParseException {
        for (Element current : elements) {
            TechnologyFrontier tf = new TechnologyFrontier(current.getAttribute("name"), this.data);
            this.parseCategoryTechs(this.getChildren("tech", current), tf);
            categories.addTechnologyFrontier(tf);
        }
    }

    private void parseRepairFrontiers(List<Element> elements) throws GameParseException {
        RepairFrontierList frontiers = this.data.getRepairFrontierList();
        for (Element current : elements) {
            String name = current.getAttribute("name");
            RepairFrontier frontier = new RepairFrontier(name, this.data);
            this.parseRepairFrontierRules(this.getChildren("repairRules", current), frontier);
            frontiers.addRepairFrontier(frontier);
        }
    }

    private void parsePlayerProduction(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            PlayerID player = this.getPlayerID(current, "player", true);
            ProductionFrontier frontier = this.getProductionFrontier(current, "frontier", true);
            player.setProductionFrontier(frontier);
        }
    }

    private void parsePlayerRepair(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            PlayerID player = this.getPlayerID(current, "player", true);
            RepairFrontier repairFrontier = this.getRepairFrontier(current, "frontier", true);
            player.setRepairFrontier(repairFrontier);
        }
    }

    private void parseFrontierRules(List<Element> elements, ProductionFrontier frontier) throws GameParseException {
        Iterator<Element> iter = elements.iterator();
        while (iter.hasNext()) {
            ProductionRule rule = this.getProductionRule(iter.next(), "name", true);
            frontier.addRule(rule);
        }
    }

    private void parseTechs(List<Element> elements, TechnologyFrontier frontier) {
        for (Element current : elements) {
            TechAdvance ta;
            String name = current.getAttribute("name");
            String tech = current.getAttribute("tech");
            if (tech.length() > 0) {
                ta = new GenericTechAdvance(name, TechAdvance.findDefinedAdvance(tech), this.data);
            } else {
                try {
                    ta = TechAdvance.findDefinedAdvance(name);
                }
                catch (IllegalArgumentException e) {
                    ta = new GenericTechAdvance(name, null, this.data);
                }
            }
            frontier.addAdvance(ta);
        }
    }

    private void parseCategoryTechs(List<Element> elements, TechnologyFrontier frontier) throws GameParseException {
        for (Element current : elements) {
            TechAdvance ta = this.data.getTechnologyFrontier().getAdvanceByProperty(current.getAttribute("name"));
            if (ta == null) {
                ta = this.data.getTechnologyFrontier().getAdvanceByName(current.getAttribute("name"));
            }
            if (ta == null) {
                throw new GameParseException("Technology not found :" + current.getAttribute("name"));
            }
            frontier.addAdvance(ta);
        }
    }

    private void parseRepairFrontierRules(List<Element> elements, RepairFrontier frontier) throws GameParseException {
        Iterator<Element> iter = elements.iterator();
        while (iter.hasNext()) {
            RepairRule rule = this.getRepairRule(iter.next(), "name", true);
            frontier.addRule(rule);
        }
    }

    private void parseAttachments(Element root) throws GameParseException {
        HashMap constructors = new HashMap();
        for (Element current : this.getChildren("attatchment", root)) {
            String className = current.getAttribute("javaClass");
            if (!constructors.containsKey(className)) {
                try {
                    Class<?> objectClass = this.getClassByName(className);
                    if (!IAttachment.class.isAssignableFrom(objectClass)) {
                        throw new GameParseException(className + " does not implement IAttachable");
                    }
                    constructors.put(className, objectClass.getConstructor(IAttachment.attachmentConstructorParameter));
                }
                catch (NoSuchMethodException exception) {
                    throw new GameParseException("Constructor for class " + className + " could not be found: " + exception.getMessage());
                }
                catch (SecurityException exception) {
                    throw new GameParseException("Constructor for class " + className + " could not be found: " + exception.getMessage());
                }
            }
            String type = current.getAttribute("type");
            Attachable attachable = this.findAttachment(current, type);
            String name = current.getAttribute("name");
            List<Element> options = this.getChildren("option", current);
            try {
                IAttachment attachment = (IAttachment)((Constructor)constructors.get(className)).newInstance(name, attachable, this.data);
                attachable.addAttachment(name, attachment);
                ArrayList<Tuple<String, String>> attachmentOptionValues = this.setValues(attachment, options);
                this.data.addToAttachmentOrderAndValues(new Tuple<IAttachment, ArrayList<Tuple<String, String>>>(attachment, attachmentOptionValues));
            }
            catch (InstantiationException e) {
                throw new GameParseException("Attachment of type " + className + " could not be instanciated: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new GameParseException("Attachment of type " + className + " could not be instanciated: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new GameParseException("Attachment of type " + className + " could not be instanciated: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new GameParseException("Attachment of type " + className + " could not be instanciated: " + e.getMessage());
            }
        }
    }

    private Attachable findAttachment(Element element, String type) throws GameParseException {
        NamedAttachable returnVal;
        String name = "attatchTo";
        if (type.equals("unitType")) {
            returnVal = this.getUnitType(element, "attatchTo", true);
        } else if (type.equals("territory")) {
            returnVal = this.getTerritory(element, "attatchTo", true);
        } else if (type.equals("resource")) {
            returnVal = this.getResource(element, "attatchTo", true);
        } else if (type.equals("territoryEffect")) {
            returnVal = this.getTerritoryEffect(element, "attatchTo", true);
        } else if (type.equals("player")) {
            returnVal = this.getPlayerID(element, "attatchTo", true);
        } else if (type.equals("relationship")) {
            returnVal = this.getRelationshipType(element, "attatchTo", true);
        } else if (type.equals("technology")) {
            returnVal = this.getTechnology(element, "attatchTo", true);
        } else {
            throw new GameParseException("Type not found to attach to:" + type);
        }
        return returnVal;
    }

    private String capitalizeFirstLetter(String aString) {
        char first = aString.charAt(0);
        first = Character.toUpperCase(first);
        return first + aString.substring(1);
    }

    private ArrayList<Tuple<String, String>> setValues(IAttachment attachment, List<Element> values) throws GameParseException {
        ArrayList<Tuple<String, String>> options = new ArrayList<Tuple<String, String>>();
        for (Element current : values) {
            String name = null;
            Method setter = null;
            try {
                name = current.getAttribute("name");
                if (name.length() == 0) {
                    throw new GameParseException("Option name with 0 length");
                }
                setter = attachment.getClass().getMethod("set" + this.capitalizeFirstLetter(name), SETTER_ARGS);
            }
            catch (NoSuchMethodException nsme) {
                throw new GameParseException("The following option name of " + attachment.getName() + " of class " + attachment.getClass().getName().substring(attachment.getClass().getName().lastIndexOf(46) + 1) + " are either misspelled or exist only in a future version of TripleA. Setter: " + name);
            }
            String value = current.getAttribute("value");
            String count = current.getAttribute("count");
            String itemValues = count.length() > 0 ? count + ":" + value : value;
            try {
                Object[] args = new Object[]{itemValues};
                setter.invoke((Object)attachment, args);
            }
            catch (IllegalAccessException iae) {
                throw new GameParseException("Setter not public. Setter:" + name + " Class:" + attachment.getClass().getName());
            }
            catch (InvocationTargetException ite) {
                ite.getCause().printStackTrace(System.out);
                throw new GameParseException("Error setting property:" + name + " cause:" + ite.getCause().getMessage());
            }
            options.add(new Tuple<String, String>(name, itemValues));
        }
        return options;
    }

    private void parseInitialization(Node root) throws GameParseException {
        Element relationInitialize;
        Element resource;
        Element unit;
        Element owner = this.getSingleChild("ownerInitialize", root, true);
        if (owner != null) {
            this.parseOwner(this.getChildren("territoryOwner", owner));
        }
        if ((unit = this.getSingleChild("unitInitialize", root, true)) != null) {
            this.parseUnitPlacement(this.getChildren("unitPlacement", unit));
            this.parseHeldUnits(this.getChildren("heldUnits", unit));
        }
        if ((resource = this.getSingleChild("resourceInitialize", root, true)) != null) {
            this.parseResourceInitialization(this.getChildren("resourceGiven", resource));
        }
        if ((relationInitialize = this.getSingleChild("relationshipInitialize", root, true)) != null) {
            this.parseRelationInitialize(this.getChildren("relationship", relationInitialize));
        }
    }

    private void parseOwner(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            TerritoryAttachment ta;
            Territory territory = this.getTerritory(current, "territory", true);
            PlayerID owner = this.getPlayerID(current, "owner", true);
            territory.setOwner(owner);
            if (territory.getData().getGameName().equals("gameExample") || territory.getData().getGameName().equals("test") || (ta = TerritoryAttachment.get(territory)) == null) continue;
            ta.setOriginalOwner(owner);
        }
    }

    private void parseUnitPlacement(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            Territory territory = this.getTerritory(current, "territory", true);
            UnitType type = this.getUnitType(current, "unitType", true);
            String ownerString = current.getAttribute("owner");
            PlayerID owner = ownerString == null || ownerString.trim().length() == 0 ? PlayerID.NULL_PLAYERID : this.getPlayerID(current, "owner", false);
            int quantity = Integer.parseInt(current.getAttribute("quantity"));
            territory.getUnits().addAllUnits(type.create(quantity, owner));
        }
    }

    private void parseHeldUnits(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            PlayerID player = this.getPlayerID(current, "player", true);
            UnitType type = this.getUnitType(current, "unitType", true);
            int quantity = Integer.parseInt(current.getAttribute("quantity"));
            player.getUnits().addAllUnits(type.create(quantity, player));
        }
    }

    private void parseResourceInitialization(List<Element> elements) throws GameParseException {
        for (Element current : elements) {
            PlayerID player = this.getPlayerID(current, "player", true);
            Resource resource = this.getResource(current, "resource", true);
            int quantity = Integer.parseInt(current.getAttribute("quantity"));
            player.getResources().addResource(resource, quantity);
        }
    }

    private void checkThatAllUnitsHaveAttachments(GameData data) throws GameParseException {
        ArrayList<UnitType> errors = new ArrayList<UnitType>();
        for (UnitType ut : data.getUnitTypeList().getAllUnitTypes()) {
            UnitAttachment ua = UnitAttachment.get(ut);
            if (ua != null) continue;
            errors.add(ut);
        }
        if (!errors.isEmpty()) {
            throw new GameParseException(data.getGameName() + " does not have unit attachments for: " + MyFormatter.asList(errors));
        }
    }
}

