/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.GameStep;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSequence
extends GameDataComponent
implements Iterable<GameStep> {
    private final List<GameStep> m_steps = new ArrayList<GameStep>();
    private int m_currentIndex;
    private int m_round = 1;
    private transient Object m_currentStepMutex = new Object();
    private static final long serialVersionUID = 8205078386807440137L;

    public GameSequence(GameData data) {
        super(data);
    }

    protected void addStep(GameStep step) {
        this.m_steps.add(step);
    }

    protected void remove(GameStep step) {
        if (!this.m_steps.contains(step)) {
            throw new IllegalArgumentException("Step does not exist");
        }
        this.m_steps.remove(step);
    }

    protected void removeStep(int index) {
        this.m_steps.remove(index);
    }

    protected void removeAllSteps() {
        this.m_steps.clear();
        this.m_round = 1;
    }

    public int getRound() {
        return this.m_round;
    }

    public int getStepIndex() {
        return this.m_currentIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        Object object = this.m_currentStepMutex;
        synchronized (object) {
            ++this.m_currentIndex;
            if (this.m_currentIndex == this.m_steps.size()) {
                this.m_currentIndex = 0;
                ++this.m_round;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testWeAreOnLastStep() {
        Object object = this.m_currentStepMutex;
        synchronized (object) {
            return this.m_currentIndex + 1 == this.m_steps.size();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameStep getStep() {
        Object object = this.m_currentStepMutex;
        synchronized (object) {
            return this.getStep(this.m_currentIndex);
        }
    }

    public GameStep getStep(int index) {
        if (index < 0 || index >= this.m_steps.size()) {
            throw new IllegalArgumentException("Attempt to access invalid state: " + index);
        }
        return this.m_steps.get(index);
    }

    @Override
    public Iterator<GameStep> iterator() {
        return this.m_steps.iterator();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.m_currentStepMutex == null) {
            this.m_currentStepMutex = new Object();
        }
    }
}

