/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteFinder {
    private final GameMap m_map;
    private final Match<Territory> m_condition;
    private final Map<Territory, Territory> m_previous;

    public RouteFinder(GameMap map, Match<Territory> condition) {
        this.m_map = map;
        this.m_condition = condition;
        this.m_previous = new HashMap<Territory, Territory>();
    }

    public Route findRoute(Territory start, Territory end) {
        Set<Territory> startSet = this.m_map.getNeighbors(start, this.m_condition);
        for (Territory t : startSet) {
            this.m_previous.put(t, start);
        }
        if (this.calculate(startSet, end)) {
            return this.getRoute(start, end);
        }
        return null;
    }

    private boolean calculate(Set<Territory> startSet, Territory end) {
        HashSet<Territory> nextSet = new HashSet<Territory>();
        for (Territory t : startSet) {
            Set<Territory> neighbors = this.m_map.getNeighbors(t, this.m_condition);
            for (Territory neighbor : neighbors) {
                if (this.m_previous.containsKey(neighbor)) continue;
                this.m_previous.put(neighbor, t);
                if (neighbor.equals(end)) {
                    return true;
                }
                nextSet.add(neighbor);
            }
        }
        if (nextSet.isEmpty()) {
            return false;
        }
        return this.calculate(nextSet, end);
    }

    private Route getRoute(Territory start, Territory destination) {
        ArrayList<Territory> route = new ArrayList<Territory>();
        Territory current = destination;
        while (current != start) {
            if (current == null) {
                return null;
            }
            route.add(current);
            current = this.m_previous.get(current);
        }
        route.add(start);
        Collections.reverse(route);
        return new Route(route);
    }
}

