/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteScripted
extends Route {
    private static final long serialVersionUID = 604474811874966546L;

    public RouteScripted() {
    }

    public RouteScripted(Territory terr) {
        super(terr, new Territory[0]);
    }

    public RouteScripted(Territory start, Territory ... route) {
        super(start, route);
    }

    @Override
    public void add(Territory t) {
        super.add(t);
    }

    @Override
    @Deprecated
    public int getLength() {
        if (super.getLength() < 1) {
            return 1;
        }
        return super.getLength();
    }

    @Override
    public int getMovementCost(Unit u) {
        if (super.getMovementCost(u) <= 0) {
            return 1;
        }
        return super.getMovementCost(u);
    }

    @Override
    public int numberOfSteps() {
        if (super.numberOfSteps() <= 0) {
            return 1;
        }
        return super.numberOfSteps();
    }

    @Override
    public List<Territory> getSteps() {
        if (this.numberOfSteps() <= 0) {
            return Collections.singletonList(this.getStart());
        }
        return super.getSteps();
    }

    @Override
    public Territory getEnd() {
        if (super.getEnd() == null) {
            return super.getStart();
        }
        return super.getEnd();
    }

    @Override
    public Territory getTerritoryAtStep(int i) {
        try {
            if (super.getEnd() == null || super.getTerritoryAtStep(i) == null) {
                return super.getStart();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return super.getStart();
        }
        return super.getTerritoryAtStep(i);
    }

    @Override
    public boolean hasSteps() {
        return true;
    }

    @Override
    public boolean hasNoSteps() {
        return false;
    }

    @Override
    public boolean hasExactlyOneStep() {
        return this.numberOfSteps() <= 1;
    }
}

