/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.IAttachmentExporter;
import games.strategy.util.IntegerMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DefaultAttachmentExporter
implements IAttachmentExporter {
    public String getAttachmentOptions(IAttachment attachment) {
        StringBuffer xmlfile = new StringBuffer();
        for (Field field : Arrays.asList(attachment.getClass().getDeclaredFields())) {
            field.setAccessible(true);
            try {
                xmlfile.append(this.printOption(field, attachment));
            }
            catch (AttachmentExportException e) {
                System.err.println(e);
            }
        }
        return xmlfile.toString();
    }

    protected String printOption(Field field, IAttachment attachment) throws AttachmentExportException {
        block16: {
            try {
                String fieldName = field.getName();
                if (fieldName.startsWith("m_is")) {
                    try {
                        attachment.getClass().getMethod("setIs" + fieldName.substring(4), String.class);
                        return this.printBooleanOption(field, fieldName.substring(2), attachment);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            attachment.getClass().getMethod("set" + Character.toUpperCase(fieldName.charAt(4)) + fieldName.substring(5), String.class);
                            return this.printBooleanOption(field, "" + Character.toLowerCase(fieldName.charAt(4)) + fieldName.substring(5), attachment);
                        }
                        catch (NoSuchMethodException nsme2) {
                            break block16;
                        }
                    }
                }
                if (!fieldName.startsWith("m_")) break block16;
                try {
                    attachment.getClass().getMethod("set" + Character.toUpperCase(fieldName.charAt(2)) + fieldName.substring(3), String.class);
                    if (field.getType().equals(String.class)) {
                        return this.printStringOption(field, fieldName.substring(2), attachment);
                    }
                    if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
                        return this.printBooleanOption(field, fieldName.substring(2), attachment);
                    }
                    if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE) || field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
                        return this.printIntegerOption(field, fieldName.substring(2), attachment);
                    }
                    if (field.getType().equals(String[].class)) {
                        return this.printStringArrayOption(field, fieldName.substring(2), attachment);
                    }
                    if (field.getType().equals(PlayerID.class)) {
                        return this.printPlayerIDOption(field, fieldName.substring(2), attachment);
                    }
                    if (field.getType().equals(UnitType.class)) {
                        return this.printUnitTypeOption(field, fieldName.substring(2), attachment);
                    }
                    throw new AttachmentExportException("unknown handler for field: " + field + " of class: " + field.getType());
                }
                catch (NullPointerException npe) {
                    System.err.println("npe: field: " + fieldName);
                    npe.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    System.err.println("no method: set" + Character.toUpperCase(fieldName.charAt(2)) + fieldName.substring(3) + " found on: " + attachment.getClass().getCanonicalName());
                }
            }
            catch (IllegalArgumentException e) {
                throw new AttachmentExportException("e: " + e + " for printOption on field: " + field + " on Attachment: " + attachment.getName());
            }
        }
        return "";
    }

    private String printUnitTypeOption(Field field, String option, IAttachment attachment) throws AttachmentExportException {
        try {
            UnitType value = (UnitType)field.get(attachment);
            if (value == null) {
                return "";
            }
            return this.printDefaultOption(option, value.getName());
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for printPlayerIDOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for printPlayerIDOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
    }

    private String printPlayerIDOption(Field field, String option, IAttachment attachment) throws AttachmentExportException {
        PlayerID value;
        try {
            value = (PlayerID)field.get(attachment);
            if (value == null) {
                return "";
            }
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for printPlayerIDOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for printPlayerIDOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        return this.printDefaultOption(option, value.getName());
    }

    private String printStringArrayOption(Field field, String option, IAttachment attachment) throws AttachmentExportException {
        try {
            String[] valueArray = (String[])field.get(attachment);
            if (valueArray == null) {
                return "";
            }
            Iterator<String> values = Arrays.asList(valueArray).iterator();
            String value = values.next();
            while (values.hasNext()) {
                value = value + ":" + values.next();
            }
            return this.printDefaultOption(option, value);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for printStringArrayOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for printStringArrayOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
    }

    protected String printIntegerOption(Field field, String option, IAttachment attachment, boolean printDefaultValue) throws AttachmentExportException {
        try {
            int value = field.getInt(attachment);
            IAttachment defaultAttachment = (IAttachment)attachment.getClass().newInstance();
            int defaultValue = field.getInt(defaultAttachment);
            if (defaultValue != value || printDefaultValue) {
                return this.printDefaultOption(option, "" + value);
            }
            return "";
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for printIntegerOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for printIntegerOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (InstantiationException e) {
            throw new AttachmentExportException("e: " + e + " for printIntegerOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
    }

    protected String printIntegerOption(Field field, String option, IAttachment attachment) throws AttachmentExportException {
        return this.printIntegerOption(field, option, attachment, false);
    }

    protected String printStringOption(Field field, String option, IAttachment attachment) throws AttachmentExportException {
        return this.printStringOption(field, option, attachment, false);
    }

    protected String printStringOption(Field field, String option, IAttachment attachment, boolean printDefaultValue) throws AttachmentExportException {
        try {
            String value = (String)field.get(attachment);
            if (value == null) {
                return "";
            }
            IAttachment defaultAttachment = (IAttachment)attachment.getClass().newInstance();
            String defaultValue = (String)field.get(defaultAttachment);
            if (value.equals(defaultValue) && !printDefaultValue) {
                return "";
            }
            return this.printDefaultOption(option, "" + value);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for printStringOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for printStringOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (InstantiationException e) {
            throw new AttachmentExportException("e: " + e + " for printStringOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
    }

    protected String printBooleanOption(Field field, String option, IAttachment attachment) throws AttachmentExportException {
        return this.printBooleanOption(field, option, attachment, false);
    }

    protected String printBooleanOption(Field field, String option, IAttachment attachment, boolean printDefaultValue) throws AttachmentExportException {
        boolean value = false;
        try {
            value = field.getBoolean(attachment);
            IAttachment defaultAttachment = (IAttachment)attachment.getClass().newInstance();
            boolean defaultValue = field.getBoolean(defaultAttachment);
            if (value == defaultValue && !printDefaultValue) {
                return "";
            }
            return this.printDefaultOption(option, "" + value);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for printBooleanOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for printBooleanOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
        catch (InstantiationException e) {
            throw new AttachmentExportException("e: " + e + " for printBooleanOption on field: " + field + " option: " + option + " on Attachment: " + attachment.getName());
        }
    }

    protected String printDefaultOption(String option, String value) {
        return "            <option name=\"" + option + "\" value=\"" + value + "\"/>\n";
    }

    protected String printCountOption(String option, String value, String count) {
        return "            <option name=\"" + option + "\" value=\"" + value + "\" count=\"" + count + "\"/>\n";
    }

    protected String printPlayerList(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            ArrayList playerIds = (ArrayList)field.get(attachment);
            Iterator iplayerIds = playerIds.iterator();
            String returnValue = "";
            if (iplayerIds.hasNext()) {
                returnValue = ((PlayerID)iplayerIds.next()).getName();
            }
            while (iplayerIds.hasNext()) {
                returnValue = returnValue + ":" + ((PlayerID)iplayerIds.next()).getName();
            }
            String optionName = "" + Character.toLowerCase(field.getName().charAt(2)) + field.getName().substring(3);
            if (returnValue.length() > 0) {
                return this.printDefaultOption(optionName, returnValue);
            }
            return "";
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    protected String printUnitIntegerMap(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            String optionName = "" + Character.toLowerCase(field.getName().charAt(2)) + field.getName().substring(3);
            IntegerMap map = (IntegerMap)field.get(attachment);
            String returnValue = "";
            if (map == null) {
                return "";
            }
            for (UnitType type : map.keySet()) {
                int number = map.getInt(type);
                if (type == null) {
                    returnValue = returnValue + this.printCountOption(optionName, "ANY", "" + number);
                    continue;
                }
                returnValue = returnValue + this.printCountOption(optionName, type.getName(), "" + number);
            }
            return returnValue;
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mUnitPresenceHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mUnitPresenceHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AttachmentExportException("e: " + e + " for mUnitPresenceHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }
}

