/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListProperty
extends AEditableProperty {
    private static final long serialVersionUID = -3098612299805630587L;
    private final List<String> m_possibleValues;
    private String m_value;

    public ListProperty(String name, String defaultValue, Collection<String> possibleValues) {
        super(name);
        if (!possibleValues.contains(defaultValue)) {
            throw new IllegalStateException("possible values does not contain default");
        }
        this.m_possibleValues = new ArrayList<String>(possibleValues);
        this.m_value = defaultValue;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        this.m_value = (String)value;
    }

    @Override
    public JComponent getEditorComponent() {
        final JComboBox<String> box = new JComboBox<String>(new Vector<String>(this.m_possibleValues));
        box.setSelectedItem(this.m_value);
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ListProperty.this.m_value = (String)box.getSelectedItem();
            }
        });
        return box;
    }
}

