/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.debug.Console;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.background.WaitWindow;
import games.strategy.triplea.ui.ErrorHandler;
import games.strategy.util.Version;
import java.util.logging.LogManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GameRunner2 {
    public static final String LOOK_AND_FEEL_PREF = "LookAndFeel";
    public static final String DELAYED_PARSING = "DelayedParsing";
    public static final String TRIPLEA_GAME_PROPERTY = "triplea.game";
    public static final String TRIPLEA_HOST_PROPERTY = "triplea.host";
    public static final String TRIPLEA_PORT_PROPERTY = "triplea.port";
    public static final String TRIPLEA_SERVER_PASSWORD_PROPERTY = "triplea.server.password";
    public static final String TRIPLEA_CLIENT_PROPERTY = "triplea.client";
    public static final String TRIPLEA_SERVER_PROPERTY = "triplea.server";
    public static final String TRIPLEA_NAME_PROPERTY = "triplea.name";
    public static final String TRIPLEA_STARTED = "triplea.started";
    public static final String LOBBY_PORT = "triplea.lobby.port";
    public static final String LOBBY_HOST = "triplea.lobby.host";
    public static final String LOBBY_GAME_COMMENTS = "triplea.lobby.game.comments";
    public static final String LOBBY_GAME_HOSTED_BY = "triplea.lobby.game.hostedBy";
    public static final String TRIPLEA_ENGINE_VERSION_BIN = "triplea.engine.version.bin";
    public static final String OLD_EXTENSION = ".old";
    private static WaitWindow waitWindow;

    public static String[] getProperties() {
        return new String[]{TRIPLEA_SERVER_PROPERTY, TRIPLEA_CLIENT_PROPERTY, TRIPLEA_PORT_PROPERTY, TRIPLEA_HOST_PROPERTY, TRIPLEA_GAME_PROPERTY, TRIPLEA_NAME_PROPERTY, TRIPLEA_SERVER_PASSWORD_PROPERTY, TRIPLEA_STARTED, LOBBY_PORT, LOBBY_HOST, LOBBY_GAME_COMMENTS, LOBBY_GAME_HOSTED_BY, TRIPLEA_ENGINE_VERSION_BIN};
    }

    public static void main(String[] args) {
        GameRunner2.setupLogging();
        Console.getConsole().displayStandardError();
        Console.getConsole().displayStandardOutput();
        System.setProperty("sun.awt.exception.handler", ErrorHandler.class.getName());
        System.setProperty("triplea.engine.version", EngineVersion.VERSION.toString());
        GameRunner2.setupLookAndFeel();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    waitWindow = new WaitWindow("TripleA is starting...");
                    waitWindow.setVisible(true);
                    waitWindow.showWait();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameRunner2.handleCommandLineArgs(args);
        GameRunner2.showMainFrame();
    }

    private static void showMainFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame frame = new MainFrame();
                frame.start();
                frame.requestFocus();
                frame.toFront();
                if (waitWindow != null) {
                    waitWindow.doneWait();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleCommandLineArgs(String[] args) {
        String[] properties = GameRunner2.getProperties();
        if (args.length == 1) {
            String value = args[0].startsWith(TRIPLEA_GAME_PROPERTY) ? GameRunner2.getValue(args[0]) : args[0];
            System.setProperty(TRIPLEA_GAME_PROPERTY, value);
        } else {
            boolean usagePrinted = false;
            for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                boolean found = false;
                String arg = args[argIndex];
                int indexOf = arg.indexOf(61);
                if (indexOf > 0) {
                    arg = arg.substring(0, indexOf);
                    for (int propIndex = 0; propIndex < properties.length; ++propIndex) {
                        if (!arg.equals(properties[propIndex])) continue;
                        String value = GameRunner2.getValue(args[argIndex]);
                        System.getProperties().setProperty(properties[propIndex], value);
                        System.out.println(properties[propIndex] + ":" + value);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                System.out.println("Unrecogized:" + args[argIndex]);
                if (usagePrinted) continue;
                usagePrinted = true;
                GameRunner2.usage();
            }
        }
        String version = System.getProperty(TRIPLEA_ENGINE_VERSION_BIN);
        if (version != null && version.length() > 0) {
            try {
                Version testVersion = new Version(version);
                System.out.println("triplea.engine.version.bin:" + version);
                if (EngineVersion.VERSION.equals(testVersion, false)) return;
                System.out.println("Current Engine version in use: " + EngineVersion.VERSION.toString());
                return;
            }
            catch (Exception e) {
                System.getProperties().setProperty(TRIPLEA_ENGINE_VERSION_BIN, EngineVersion.VERSION.toString());
                System.out.println("triplea.engine.version.bin:" + EngineVersion.VERSION.toString());
                return;
            }
        } else {
            System.getProperties().setProperty(TRIPLEA_ENGINE_VERSION_BIN, EngineVersion.VERSION.toString());
            System.out.println("triplea.engine.version.bin:" + EngineVersion.VERSION.toString());
        }
    }

    private static void usage() {
        System.out.println("Arguments\n   triplea.game=<FILE_NAME>\n   triplea.server=true\n   triplea.client=true\n   triplea.port=<PORT>\n   triplea.host=<HOST>\n   triplea.name=<PLAYER_NAME>\n\nif there is only one argument, and it does not start with triplea.game, the argument will be \ntaken as the name of the file to load.\n\nExample\n   to start a game using the given file:\n\n   triplea /home/sgb/games/test.xml\n\n   or\n\n   triplea triplea.game=/home/sgb/games/test.xml\n\n   to connect to a remote host:\n\n   triplea triplea.client=true triplea.host=127.0.0.0 triplea.port=3300 triplea.name=Paul\n\n   to start a server with the given game\n\n   triplea triplea.game=/home/sgb/games/test.xml triplea.server=true triplea.port=3300 triplea.name=Allan\n   to start a server, you can optionally password protect the game using triplea.server.password=foo");
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    public static void setupLookAndFeel() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    block4: {
                        try {
                            UIManager.setLookAndFeel(GameRunner2.getDefaultLookAndFeel());
                        }
                        catch (Throwable t) {
                            if (GameRunner.isMac()) break block4;
                            try {
                                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public static void setupLogging() {
        try {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("logging.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDefaultLookAndFeel() {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        String defaultLokAndFeel = "org.jvnet.substance.skin.SubstanceRavenGraphiteLookAndFeel";
        if (GameRunner.isMac()) {
            defaultLokAndFeel = UIManager.getSystemLookAndFeelClassName();
        }
        return pref.get(LOOK_AND_FEEL_PREF, defaultLokAndFeel);
    }

    public static void setDefaultLookAndFeel(String lookAndFeelClassName) {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        pref.put(LOOK_AND_FEEL_PREF, lookAndFeelClassName);
        try {
            pref.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static boolean getDelayedParsing() {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        return pref.getBoolean(DELAYED_PARSING, true);
    }

    public static void setDelayedParsing(boolean delayedParsing) {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        pref.putBoolean(DELAYED_PARSING, delayedParsing);
        try {
            pref.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

