/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup;

import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBeanCache {
    private static final LocalBeanCache s_INSTANCE = new LocalBeanCache();
    private final File m_file;
    private final Object m_mutex = new Object();
    Map<String, IBean> m_map = new HashMap<String, IBean>();

    public static LocalBeanCache getInstance() {
        return s_INSTANCE;
    }

    private LocalBeanCache() {
        this.m_file = new File(GameRunner.getUserRootFolder(), "local.cache");
        this.m_map = this.loadMap();
        Thread shutdown = new Thread(new Runnable(){

            public void run() {
                LocalBeanCache.this.writeToDisk();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IBean> loadMap() {
        if (this.m_file.exists()) {
            HashMap hashMap;
            block10: {
                ObjectInput oin = null;
                try {
                    oin = new ObjectInputStream(new FileInputStream(this.m_file));
                    Object o = oin.readObject();
                    if (o instanceof Map) {
                        Map m = (Map)o;
                        for (Object o1 : m.keySet()) {
                            if (o1 instanceof String) continue;
                            throw new Exception("Map is corrupt");
                        }
                    } else {
                        throw new Exception("File is corrupt");
                    }
                    hashMap = (HashMap)o;
                    if (oin == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (oin != null) {
                            oin.close();
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.m_file.delete();
                        System.err.println("Serialization cache invalid");
                    }
                }
                oin.close();
            }
            return hashMap;
        }
        return new HashMap<String, IBean>();
    }

    public void storeSerializable(String key, IBean bean) {
        this.m_map.put(key, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk() {
        Object object = this.m_mutex;
        synchronized (object) {
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(this.m_file, false));
                out.writeObject(this.m_map);
            }
            catch (IOException e) {
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public IBean getSerializable(String key) {
        return this.m_map.get(key);
    }
}

