/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.launcher;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.ui.NewGameChooser;
import games.strategy.engine.framework.ui.background.WaitWindow;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractLauncher
implements ILauncher {
    protected final GameData m_gameData;
    protected final GameSelectorModel m_gameSelectorModel;
    protected final WaitWindow m_gameLoadingWindow = new WaitWindow("Loading game, please wait.");

    protected AbstractLauncher(GameSelectorModel gameSelectorModel) {
        this.m_gameSelectorModel = gameSelectorModel;
        this.m_gameData = gameSelectorModel.getGameData();
    }

    public void launch(final Component parent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        Runnable r = new Runnable(){

            public void run() {
                NewGameChooser.clearNewGameChooserModel();
                AbstractLauncher.this.launchInNewThread(parent);
            }
        };
        Thread t = new Thread(r, "Triplea start thread");
        this.m_gameLoadingWindow.setLocationRelativeTo(JOptionPane.getFrameForComponent(parent));
        this.m_gameLoadingWindow.setVisible(true);
        this.m_gameLoadingWindow.showWait();
        JOptionPane.getFrameForComponent(parent).setVisible(false);
        t.start();
    }

    protected abstract void launchInNewThread(Component var1);
}

