/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.mc;

import games.strategy.engine.data.EngineVersionException;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.GameParser;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.ui.NewGameChooser;
import games.strategy.engine.framework.ui.NewGameChooserEntry;
import games.strategy.engine.framework.ui.NewGameChooserModel;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.Observable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class GameSelectorModel
extends Observable {
    public static final String DEFAULT_GAME_XML_DIRECTORY_NAME = "games";
    public static final File DEFAULT_MAP_DIRECTORY = new File(GameRunner.getRootFolder(), "/maps");
    private static final String DEFAULT_GAME_NAME_PREF = "DefaultGameName2";
    private static final String DEFAULT_GAME_NAME = "Big World : 1942";
    private static final String DEFAULT_GAME_URI_PREF = "DefaultGameURI";
    private static final String DEFAULT_GAME_URI = "";
    private GameData m_data;
    private String m_gameName;
    private String m_gameVersion;
    private String m_gameRound;
    private String m_fileName;
    private boolean m_canSelect = true;

    public GameSelectorModel() {
        this.setGameData(null);
    }

    public void load(NewGameChooserEntry entry) {
        if (GameRunner.areWeOldExtraJar()) {
            return;
        }
        this.m_fileName = entry.getLocation();
        this.setGameData(entry.getGameData());
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.put(DEFAULT_GAME_NAME_PREF, entry.getGameData().getGameName());
        prefs.put(DEFAULT_GAME_URI_PREF, entry.getURI().toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void load(File file, Component ui) {
        GameDataManager manager = new GameDataManager();
        if (!file.exists()) {
            this.error("Could not find file:" + file, ui);
            return;
        }
        if (file.isDirectory()) {
            this.error("Cannot load a directory:" + file, ui);
            return;
        }
        try {
            GameData newData = file.getName().toLowerCase().endsWith("xml") ? new GameParser().parse(new FileInputStream(file), false) : manager.loadGame(file);
            if (newData != null) {
                this.m_fileName = file.getName();
                this.setGameData(newData);
            }
        }
        catch (EngineVersionException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.error(e.getMessage(), ui);
        }
    }

    public boolean isSavedGame() {
        return !this.m_fileName.endsWith(".xml");
    }

    private void error(String message, Component ui) {
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(ui), message, "Could not load Game", 0);
    }

    public synchronized GameData getGameData() {
        return this.m_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanSelect(boolean aBool) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            this.m_canSelect = aBool;
        }
        this.notifyObs();
    }

    public synchronized boolean canSelect() {
        return this.m_canSelect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataButKeepGameInfo(String gameName, String gameRound, String gameVersion) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            this.m_data = null;
            this.m_gameName = gameName;
            this.m_gameRound = gameRound;
            this.m_gameVersion = gameVersion;
        }
        this.notifyObs();
    }

    public synchronized String getFileName() {
        if (this.m_data == null) {
            return "-";
        }
        return this.m_fileName;
    }

    public synchronized String getGameName() {
        return this.m_gameName;
    }

    public synchronized String getGameRound() {
        return this.m_gameRound;
    }

    public synchronized String getGameVersion() {
        return this.m_gameVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGameData(GameData data) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            if (data == null) {
                this.m_gameVersion = "-";
                this.m_gameRound = "-";
                this.m_gameName = "-";
            } else {
                this.m_gameName = data.getGameName();
                this.m_gameRound = DEFAULT_GAME_URI + data.getSequence().getRound();
                this.m_gameVersion = data.getGameVersion().toString();
            }
            this.m_data = data;
        }
        this.notifyObs();
    }

    private void notifyObs() {
        super.setChanged();
        super.notifyObservers(this.m_data);
        super.clearChanged();
    }

    private void resetDefaultGame() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.put(DEFAULT_GAME_NAME_PREF, DEFAULT_GAME_NAME);
        prefs.put(DEFAULT_GAME_URI_PREF, DEFAULT_GAME_URI);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void loadDefaultGame(Component ui) {
        Dynamix_AI.clearCachedGameDataAll();
        this.loadDefaultGame(ui, false);
    }

    private void loadDefaultGame(Component ui, boolean forceFactoryDefault) {
        String userPreferredDefaultGameURI;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        if (forceFactoryDefault) {
            this.resetDefaultGame();
        }
        NewGameChooserEntry selectedGame = null;
        String string = userPreferredDefaultGameURI = forceFactoryDefault ? DEFAULT_GAME_URI : prefs.get(DEFAULT_GAME_URI_PREF, DEFAULT_GAME_URI);
        if (!forceFactoryDefault && userPreferredDefaultGameURI != null && userPreferredDefaultGameURI.length() > 0) {
            try {
                URI defaultURI = new URI(userPreferredDefaultGameURI);
                selectedGame = new NewGameChooserEntry(defaultURI);
            }
            catch (Exception e) {
                System.out.println(userPreferredDefaultGameURI + " could not be loaded.");
                this.loadDefaultGame(ui, true);
                return;
            }
            if (!selectedGame.isGameDataLoaded()) {
                try {
                    selectedGame.fullyParseGameData();
                }
                catch (GameParseException e) {
                    this.loadDefaultGame(ui, true);
                    return;
                }
            }
            new Thread(new Runnable(){

                public void run() {
                    NewGameChooser.refreshNewGameChooserModel();
                }
            }).start();
        } else {
            if (!forceFactoryDefault) {
                NewGameChooser.refreshNewGameChooserModel();
            }
            String userPreferredDefaultGameName = forceFactoryDefault ? DEFAULT_GAME_NAME : prefs.get(DEFAULT_GAME_NAME_PREF, DEFAULT_GAME_NAME);
            NewGameChooserModel model = NewGameChooser.getNewGameChooserModel();
            selectedGame = model.findByName(userPreferredDefaultGameName);
            if (selectedGame == null) {
                selectedGame = model.findByName(DEFAULT_GAME_NAME);
            }
            if (selectedGame == null && model.size() > 0) {
                selectedGame = model.get(0);
            }
            if (selectedGame == null) {
                return;
            }
            if (!selectedGame.isGameDataLoaded()) {
                try {
                    selectedGame.fullyParseGameData();
                }
                catch (GameParseException e) {
                    selectedGame.delayParseGameData();
                    model.removeEntry(selectedGame);
                    this.loadDefaultGame(ui, true);
                    return;
                }
            }
        }
        this.load(selectedGame);
    }
}

