/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.mc;

import games.strategy.engine.framework.startup.mc.ClientModel;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.startup.ui.ClientSetupPanel;
import games.strategy.engine.framework.startup.ui.LocalSetupPanel;
import games.strategy.engine.framework.startup.ui.MetaSetupPanel;
import games.strategy.engine.framework.startup.ui.PBEMSetupPanel;
import games.strategy.engine.framework.startup.ui.ServerSetupPanel;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;

public class SetupPanelModel
extends Observable {
    private final GameSelectorModel m_gameSelectorModel;
    private SetupPanel m_panel;

    public SetupPanelModel(GameSelectorModel gameSelectorModel) {
        this.m_gameSelectorModel = gameSelectorModel;
    }

    public GameSelectorModel getGameSelectorModel() {
        return this.m_gameSelectorModel;
    }

    public void setWidgetActivation() {
        this.m_panel.setWidgetActivation();
    }

    public void showSelectType() {
        this.setGameTypePanel(new MetaSetupPanel(this));
    }

    public void showLocal() {
        this.setGameTypePanel(new LocalSetupPanel(this.m_gameSelectorModel));
    }

    public void showPBEM() {
        this.setGameTypePanel(new PBEMSetupPanel(this.m_gameSelectorModel));
    }

    public void showServer(Component ui) {
        ServerModel model = new ServerModel(this.m_gameSelectorModel, this);
        if (!model.createServerMessenger(ui)) {
            model.cancel();
            return;
        }
        this.setGameTypePanel(new ServerSetupPanel(model, this.m_gameSelectorModel));
        int x = ui.getPreferredSize().width > 800 ? ui.getPreferredSize().width : 800;
        int y = ui.getPreferredSize().height > 660 ? ui.getPreferredSize().height : 660;
        ui.setPreferredSize(new Dimension(x, y));
        ui.setSize(new Dimension(x, y));
    }

    public void showClient(Component ui) {
        ClientModel model = new ClientModel(this.m_gameSelectorModel, this);
        if (!model.createClientMessenger(ui)) {
            model.cancel();
            return;
        }
        this.setGameTypePanel(new ClientSetupPanel(model));
    }

    private void setGameTypePanel(SetupPanel panel) {
        if (this.m_panel != null) {
            this.m_panel.cancel();
        }
        this.m_panel = panel;
        super.setChanged();
        super.notifyObservers(this.m_panel);
        super.clearChanged();
    }

    public SetupPanel getPanel() {
        return this.m_panel;
    }
}

