/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.startup.ui.IGamePropertiesCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FileBackedGamePropertiesCache
implements IGamePropertiesCache {
    static final char[] s_illegalChars = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '*', ':', '<', '>', '?', '\\', '|'};

    public void cacheGameProperties(GameData gameData) {
        HashMap<String, Object> serializableMap = new HashMap<String, Object>();
        for (IEditableProperty property : gameData.getProperties().getEditableProperties()) {
            if (!(property.getValue() instanceof Serializable)) continue;
            serializableMap.put(property.getName(), property.getValue());
        }
        File cache = this.getCacheFile(gameData);
        try {
            if (!cache.getParentFile().exists()) {
                cache.getParentFile().mkdirs();
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cache));
            out.writeObject(serializableMap);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadCachedGamePropertiesInto(GameData gameData) {
        File cache = this.getCacheFile(gameData);
        try {
            if (cache.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(cache));
                Map serializedMap = (Map)in.readObject();
                for (IEditableProperty property : gameData.getProperties().getEditableProperties()) {
                    Serializable ser = (Serializable)serializedMap.get(property.getName());
                    if (ser == null) continue;
                    property.setValue(ser);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private File getCacheFile(GameData gameData) {
        File cacheDir = new File(GameRunner.getUserRootFolder(), "optionCache");
        return new File(cacheDir, this.getFileName(gameData.getGameName()));
    }

    private String getFileName(String gameName) {
        StringBuilder sb = new StringBuilder();
        int charArrayLength = gameName.length();
        for (int i = 0; i < charArrayLength; ++i) {
            char c = gameName.charAt(i);
            if (Arrays.binarySearch(s_illegalChars, c) >= 0) continue;
            sb.append(c);
        }
        sb.append(".defaultOptions");
        return sb.toString();
    }
}

