/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.launcher.LocalLauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.ui.LocalPlayerComboBoxSelector;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.engine.random.PlainRandomSource;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class LocalSetupPanel
extends SetupPanel
implements Observer {
    private static final long serialVersionUID = 2284030734590389060L;
    private final GameSelectorModel m_gameSelectorModel;
    private final List<LocalPlayerComboBoxSelector> m_playerTypes = new ArrayList<LocalPlayerComboBoxSelector>();

    public LocalSetupPanel(GameSelectorModel model) {
        this.m_gameSelectorModel = model;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
    }

    private void layoutComponents() {
        GameData data = this.m_gameSelectorModel.getGameData();
        LinkedHashMap<String, String> reloadSelections = PlayerID.currentPlayers(data);
        this.removeAll();
        this.m_playerTypes.clear();
        this.setLayout(new GridBagLayout());
        if (data == null) {
            this.add(new JLabel("No game selected!"));
            return;
        }
        String[] playerTypes = data.getGameLoader().getServerPlayerTypes();
        String[] playerNames = data.getPlayerList().getNames();
        for (int i = 0; i < playerNames.length; ++i) {
            LocalPlayerComboBoxSelector selector = new LocalPlayerComboBoxSelector(playerNames[i], reloadSelections, data.getAllianceTracker().getAlliancesPlayerIsIn(data.getPlayerList().getPlayerID(playerNames[i])), playerTypes);
            this.m_playerTypes.add(selector);
            selector.layout(i, this);
        }
        this.validate();
        this.invalidate();
    }

    private void setupListeners() {
        this.m_gameSelectorModel.addObserver(this);
    }

    public void setWidgetActivation() {
    }

    public boolean canGameStart() {
        return this.m_gameSelectorModel.getGameData() != null;
    }

    public void cancel() {
        this.m_gameSelectorModel.deleteObserver(this);
    }

    public void update(Observable o, Object arg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LocalSetupPanel.this.layoutComponents();
                }
            });
            return;
        }
        this.layoutComponents();
    }

    public String getPlayerType(String playerName) {
        for (LocalPlayerComboBoxSelector item : this.m_playerTypes) {
            if (!item.getPlayerName().equals(playerName)) continue;
            return item.getPlayerType();
        }
        throw new IllegalStateException("No player found:" + playerName);
    }

    public ILauncher getLauncher() {
        PlainRandomSource randomSource = new PlainRandomSource();
        HashMap<String, String> playerTypes = new HashMap<String, String>();
        for (LocalPlayerComboBoxSelector player : this.m_playerTypes) {
            playerTypes.put(player.getPlayerName(), player.getPlayerType());
        }
        LocalLauncher launcher = new LocalLauncher(this.m_gameSelectorModel, randomSource, playerTypes);
        return launcher;
    }
}

