/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.history;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.history.Event;
import games.strategy.engine.history.EventChild;
import games.strategy.engine.history.History;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.IndexedHistoryNode;
import games.strategy.engine.history.Round;
import games.strategy.engine.history.Step;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class HistoryWriter
implements Serializable {
    private static final long serialVersionUID = 4230519614567508061L;
    private final History m_history;
    private HistoryNode m_current;
    private static final Logger s_logger = Logger.getLogger(HistoryWriter.class.getName());

    public HistoryWriter(History history) {
        this.m_history = history;
    }

    private void assertCorrectThread() {
        if (this.m_history.getGameData().areChangesOnlyInSwingEventThread() && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    public void startNextStep(String stepName, String delegateName, PlayerID player, String stepDisplayName) {
        this.assertCorrectThread();
        s_logger.log(Level.FINE, "start step, stepName:" + stepName + " delegateName:" + delegateName + " player:" + player + " displayName:" + stepDisplayName);
        if (this.m_current == null) {
            this.startNextRound(1);
        }
        if (this.isCurrentEvent()) {
            this.closeCurrent();
        }
        if (this.isCurrentStep()) {
            this.closeCurrent();
        }
        if (!this.isCurrentRound()) {
            throw new IllegalStateException("Not in a round");
        }
        Step currentStep = new Step(stepName, delegateName, player, this.m_history.getChanges().size(), stepDisplayName);
        this.addToAndSetCurrent(currentStep);
    }

    public void startNextRound(int round) {
        this.assertCorrectThread();
        s_logger.log(Level.FINE, "Starting round:" + round);
        if (this.isCurrentEvent()) {
            this.closeCurrent();
        }
        if (this.isCurrentStep()) {
            this.closeCurrent();
        }
        if (this.isCurrentRound()) {
            this.closeCurrent();
        }
        Round currentRound = new Round(round, this.m_history.getChanges().size());
        this.m_current = (HistoryNode)this.m_history.getRoot();
        this.addToAndSetCurrent(currentRound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrent() {
        this.assertCorrectThread();
        HistoryNode old = this.m_current;
        this.m_history.getGameData().acquireWriteLock();
        try {
            if (this.isCurrentStep()) {
                HistoryNode parent = (HistoryNode)this.m_current.getParent();
                if (this.m_current.getChildCount() == 0) {
                    int index = parent.getChildCount() - 1;
                    parent.remove(this.m_current);
                    this.m_history.nodesWereRemoved(parent, new int[]{index}, new Object[]{this.m_current});
                }
                this.m_current = parent;
                return;
            }
            this.m_current = (HistoryNode)this.m_current.getParent();
            ((IndexedHistoryNode)old).setChangeEndIndex(this.m_history.getChanges().size());
        }
        finally {
            this.m_history.getGameData().releaseWriteLock();
        }
    }

    private void addToAndSetCurrent(HistoryNode newNode) {
        this.addToCurrent(newNode);
        this.m_current = newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCurrent(HistoryNode newNode) {
        this.m_history.getGameData().acquireWriteLock();
        try {
            this.m_history.insertNodeInto(newNode, this.m_current, this.m_current.getChildCount());
        }
        finally {
            this.m_history.getGameData().releaseWriteLock();
        }
        this.m_history.goToEnd();
    }

    public void startEvent(String eventName) {
        this.assertCorrectThread();
        s_logger.log(Level.FINE, "Starting event:" + eventName);
        if (this.isCurrentEvent()) {
            this.closeCurrent();
        }
        if (!this.isCurrentStep()) {
            throw new IllegalStateException("Cant add an event, not a step. Must be in a step to add an event to the step. \nTrying to add event: " + eventName);
        }
        Event event = new Event(eventName, this.m_history.getChanges().size());
        this.addToAndSetCurrent(event);
    }

    private boolean isCurrentEvent() {
        return this.m_current instanceof Event;
    }

    private boolean isCurrentRound() {
        return this.m_current instanceof Round;
    }

    private boolean isCurrentStep() {
        return this.m_current instanceof Step;
    }

    public void addChildToEvent(EventChild node) {
        this.assertCorrectThread();
        s_logger.log(Level.FINE, "Adding child:" + node);
        if (!this.isCurrentEvent()) {
            new IllegalStateException("Not in an event, but trying to add child:" + node + " current is:" + this.m_current).printStackTrace(System.out);
            this.startEvent("???");
        }
        this.addToCurrent(node);
    }

    public void addChange(Change change) {
        this.assertCorrectThread();
        s_logger.log(Level.FINE, "Adding change:" + change);
        if (!this.isCurrentEvent() && !this.isCurrentStep()) {
            new IllegalStateException("Not in an event, but trying to add change:" + change + " current is:" + this.m_current).printStackTrace(System.out);
            this.startEvent("Bad Event for change: \n" + change.toString());
        }
        this.m_history.changeAdded(change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderingData(Object details) {
        this.assertCorrectThread();
        s_logger.log(Level.FINE, "Setting rendering data:" + details);
        if (!this.isCurrentEvent()) {
            new IllegalStateException("Not in an event, but trying to set details:" + details + " current is:" + this.m_current).printStackTrace(System.out);
            this.startEvent("???");
        }
        this.m_history.getGameData().acquireWriteLock();
        try {
            ((Event)this.m_current).setRenderingData(details);
        }
        finally {
            this.m_history.getGameData().releaseWriteLock();
        }
        this.m_history.goToEnd();
    }
}

