/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.login;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;

public class LobbyServerProperties {
    private static final Logger s_logger = Logger.getLogger(LobbyServerProperties.class.getName());
    private final String m_host;
    private final int m_port;
    private final String m_serverErrorMessage;
    private final String m_serverMessage;
    private volatile boolean m_done;

    public LobbyServerProperties(String host, int port, String serverErrorMessage, String serverMessage) {
        this.m_host = host;
        this.m_port = port;
        this.m_serverErrorMessage = serverErrorMessage;
        this.m_serverMessage = serverMessage;
    }

    public boolean isDone() {
        return this.m_done;
    }

    public LobbyServerProperties(URL url) {
        this(LobbyServerProperties.getProperties(url));
    }

    public LobbyServerProperties(Properties props) {
        this.m_host = props.getProperty("HOST");
        this.m_port = Integer.parseInt(props.getProperty("PORT", "-1"));
        this.m_serverErrorMessage = props.getProperty("ERROR_MESSAGE", "");
        this.m_serverMessage = props.getProperty("MESSAGE", "");
        this.m_done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(URL url) {
        Properties props = new Properties();
        HttpClient client = new HttpClient();
        client.getHostConfiguration().setHost(url.getHost());
        GetMethod method = new GetMethod(url.getPath());
        method.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        try {
            client.executeMethod(method);
            String propsString = method.getResponseBodyAsString();
            props.load(new ByteArrayInputStream(propsString.getBytes()));
        }
        catch (IOException ioe) {
            s_logger.log(Level.WARNING, ioe.getMessage(), ioe);
            props.put("ERROR_MESSAGE", ioe.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return props;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getServerErrorMessage() {
        return this.m_serverErrorMessage;
    }

    public boolean isServerAvailable() {
        return this.m_serverErrorMessage.trim().length() <= 0;
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("http://triplea.sourceforge.net/lobby/server.properties");
        LobbyServerProperties props = new LobbyServerProperties(url);
        System.out.println(props.getHost());
        System.out.println(props.getPort());
        System.out.println(props.getServerErrorMessage());
    }

    public String getServerMessage() {
        return this.m_serverMessage;
    }
}

