/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.ui;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.ui.ServerOptions;
import games.strategy.engine.lobby.client.ui.LobbyGameTable;
import games.strategy.engine.lobby.client.ui.LobbyGameTableModel;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.engine.lobby.server.ModeratorController;
import games.strategy.net.Messengers;
import games.strategy.net.Node;
import games.strategy.ui.TableSorter;
import games.strategy.util.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobbyGamePanel
extends JPanel {
    private static final long serialVersionUID = -7829506356288575574L;
    private JButton m_hostGame;
    private JButton m_joinGame;
    private JButton m_bootGame;
    private LobbyGameTableModel m_gameTableModel;
    private final Messengers m_messengers;
    private JTable m_gameTable;
    private TableSorter m_tableSorter;

    public LobbyGamePanel(Messengers messengers) {
        this.m_messengers = messengers;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_hostGame = new JButton("Host Game");
        this.m_joinGame = new JButton("Join Game");
        this.m_bootGame = new JButton("Boot Game");
        this.m_gameTableModel = new LobbyGameTableModel(this.m_messengers.getMessenger(), this.m_messengers.getChannelMessenger(), this.m_messengers.getRemoteMessenger());
        this.m_tableSorter = new TableSorter(this.m_gameTableModel);
        this.m_gameTable = new LobbyGameTable(this.m_tableSorter);
        this.m_tableSorter.setTableHeader(this.m_gameTable.getTableHeader());
        this.m_gameTable.setColumnSelectionAllowed(false);
        this.m_gameTable.setRowSelectionAllowed(true);
        this.m_gameTable.setSelectionMode(0);
        int nameColumn = this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Name);
        this.m_tableSorter.setSortingStatus(nameColumn, 1);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Players)).setPreferredWidth(42);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Round)).setPreferredWidth(40);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.PW)).setPreferredWidth(22);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.GV)).setPreferredWidth(32);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.EV)).setPreferredWidth(42);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Started)).setPreferredWidth(54);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Status)).setPreferredWidth(110);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Name)).setPreferredWidth(148);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Comments)).setPreferredWidth(150);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Host)).setPreferredWidth(60);
        this.m_gameTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -2807387751127250972L;
            private final SimpleDateFormat format = new SimpleDateFormat("hh:mm a");

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(this.format.format((Date)value));
                return this;
            }
        });
    }

    private void layoutComponents() {
        JScrollPane scroll = new JScrollPane(this.m_gameTable);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.m_hostGame);
        toolBar.add(this.m_joinGame);
        if (this.isAdmin()) {
            toolBar.add(this.m_bootGame);
        }
        toolBar.setFloatable(false);
        this.add((Component)toolBar, "South");
    }

    public boolean isAdmin() {
        return ((IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName())).isAdmin();
    }

    private void setupListeners() {
        this.m_hostGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.hostGame();
            }
        });
        this.m_joinGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.joinGame();
            }
        });
        this.m_bootGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.bootGame();
            }
        });
        this.m_gameTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                LobbyGamePanel.this.setWidgetActivation();
            }
        });
        this.m_gameTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    LobbyGamePanel.this.joinGame();
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void joinGame() {
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        Version engineVersionOfGameToJoin = new Version(description.getEngineVersion());
        ArrayList<String> commands = new ArrayList<String>();
        if (EngineVersion.VERSION.equals(engineVersionOfGameToJoin)) {
            LobbyGamePanel.populateBasicJavaArgs(commands);
        } else {
            String newClassPath;
            try {
                newClassPath = LobbyGamePanel.findOldJar(engineVersionOfGameToJoin, false);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getParent(), "Host is using a different engine than you, and can not find correct engine: " + engineVersionOfGameToJoin.toStringFull("_"), "Correct TripleA Engine Not Found", 2);
                return;
            }
            String messageString = "<html>This TripleA engine is version " + EngineVersion.VERSION.toString() + " and you are trying to join a game made with version " + engineVersionOfGameToJoin.toString() + "<br>However, this TripleA can only play with engines that are the exact same version as itself (x_x_x_x)." + "<br><br>TripleA now comes with older engines included with it, and has found the engine used by the host. This is a new feature and is in 'beta' stage." + "<br>It will attempt to run a new instance of TripleA using the older engine jar file, and this instance will join the host's game." + "<br>Your current instance will not be closed. Please report any bugs or issues." + "<br><br>Do you wish to continue?</html>";
            int answer = JOptionPane.showConfirmDialog(null, messageString, "Run old jar to join hosted game?", 0);
            if (answer != 0) {
                return;
            }
            LobbyGamePanel.populateBasicJavaArgs(commands, newClassPath);
        }
        commands.add("-Dtriplea.client=true");
        commands.add("-Dtriplea.port=" + description.getPort());
        commands.add("-Dtriplea.host=" + description.getHostedBy().getAddress().getHostAddress());
        commands.add("-Dtriplea.name=" + this.m_messengers.getMessenger().getLocalNode().getName());
        String javaClass = "games.strategy.engine.framework.GameRunner";
        commands.add("games.strategy.engine.framework.GameRunner");
        LobbyGamePanel.exec(commands);
    }

    public static String findOldJar(Version oldVersionNeeded, boolean ignoreMicro) throws IOException {
        if (EngineVersion.VERSION.equals(oldVersionNeeded, ignoreMicro)) {
            return System.getProperty("java.class.path");
        }
        String jarName = "triplea_" + oldVersionNeeded.toStringFull("_", ignoreMicro);
        File oldJarsFolder = new File(GameRunner.getRootFolder(), "old/");
        File[] files = oldJarsFolder.listFiles();
        if (files == null) {
            throw new IOException("Can not find 'old' engine jars folder");
        }
        File ourOldJar = null;
        for (File f : Arrays.asList(files)) {
            String jarPath = f.getCanonicalPath();
            if (jarPath.indexOf(jarName) == -1 || jarPath.indexOf(".jar") == -1) continue;
            ourOldJar = f;
            break;
        }
        if (ourOldJar == null) {
            throw new IOException("Can not find 'old' engine jar for version: " + oldVersionNeeded.toStringFull("_"));
        }
        String newClassPath = ourOldJar.getCanonicalPath();
        if (newClassPath == null || newClassPath.length() <= 0) {
            throw new IOException("Can not find 'old' engine jar for version: " + oldVersionNeeded.toStringFull("_"));
        }
        return newClassPath;
    }

    protected void hostGame() {
        String fileName;
        ServerOptions options = new ServerOptions((Component)JOptionPane.getFrameForComponent(this), this.m_messengers.getMessenger().getLocalNode().getName(), 3300, true);
        options.setLocationRelativeTo(JOptionPane.getFrameForComponent(this));
        options.setNameEditable(false);
        options.setVisible(true);
        if (!options.getOKPressed()) {
            return;
        }
        ArrayList<String> commands = new ArrayList<String>();
        LobbyGamePanel.populateBasicJavaArgs(commands);
        commands.add("-Dtriplea.server=true");
        commands.add("-Dtriplea.port=" + options.getPort());
        commands.add("-Dtriplea.name=" + options.getName());
        commands.add("-Dtriplea.lobby.host=" + this.m_messengers.getMessenger().getRemoteServerSocketAddress().getAddress().getHostAddress());
        commands.add("-Dtriplea.lobby.port=" + this.m_messengers.getMessenger().getRemoteServerSocketAddress().getPort());
        commands.add("-Dtriplea.lobby.game.comments=" + options.getComments());
        commands.add("-Dtriplea.lobby.game.hostedBy=" + this.m_messengers.getMessenger().getLocalNode().getName());
        if (options.getPassword() != null && options.getPassword().length() > 0) {
            commands.add("-Dtriplea.server.password=" + options.getPassword());
        }
        if ((fileName = System.getProperty("triplea.game", "")).length() > 0) {
            commands.add("-Dtriplea.game=" + fileName);
        }
        String javaClass = "games.strategy.engine.framework.GameRunner";
        commands.add("games.strategy.engine.framework.GameRunner");
        LobbyGamePanel.exec(commands);
    }

    public static void startGame(String savegamePath, String classpath) {
        ArrayList<String> commands = new ArrayList<String>();
        LobbyGamePanel.populateBasicJavaArgs(commands, classpath);
        if (savegamePath != null && savegamePath.length() > 0) {
            commands.add("-Dtriplea.game=" + savegamePath);
        }
        for (String property : GameRunner2.getProperties()) {
            String oldValue;
            if ("triplea.game".equals(property) || "triplea.engine.version.bin".equals(property)) continue;
            String value = System.getProperty(property);
            if (value != null) {
                commands.add("-D" + property + "=" + value);
                continue;
            }
            if (!"triplea.lobby.host".equals(property) && !"triplea.lobby.port".equals(property) && !"triplea.lobby.game.hostedBy".equals(property) || (oldValue = System.getProperty(property + ".old")) == null) continue;
            commands.add("-D" + property + "=" + oldValue);
        }
        String javaClass = "games.strategy.engine.framework.GameRunner";
        commands.add("games.strategy.engine.framework.GameRunner");
        LobbyGamePanel.exec(commands);
    }

    private void bootGame() {
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to disconnect the selected game?", "Remove Game From Lobby", 2);
        if (result != 0) {
            return;
        }
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        Node lobbyWatcherNode = new Node(description.getHostedBy().getName() + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
        controller.boot(lobbyWatcherNode);
        JOptionPane.showMessageDialog(null, "The game you selected has been disconnected from the lobby.");
    }

    private static void exec(List<String> commands) {
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        try {
            Process p = builder.start();
            final InputStream s = p.getInputStream();
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        while (s.read() >= 0) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, "Process ouput gobbler");
            t.setDaemon(true);
            t.start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void populateBasicJavaArgs(List<String> commands) {
        LobbyGamePanel.populateBasicJavaArgs(commands, System.getProperty("java.class.path"));
    }

    private static void populateBasicJavaArgs(List<String> commands, String classpath) {
        String version;
        String[] preservedSystemProperties;
        String javaCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        commands.add(javaCommand);
        commands.add("-classpath");
        if (classpath != null && classpath.length() > 0) {
            commands.add(classpath);
        } else {
            commands.add(System.getProperty("java.class.path"));
        }
        long maxMemory = (long)((double)Runtime.getRuntime().maxMemory() * 1.15) + 0x4000000L;
        commands.add("-Xmx" + maxMemory);
        for (String key : preservedSystemProperties = new String[]{"sun.java2d.noddraw"}) {
            String value;
            if (System.getProperties().getProperty(key) == null || !(value = System.getProperties().getProperty(key)).matches("[a-zA-Z0-9.]+")) continue;
            commands.add("-D" + key + "=" + value);
        }
        if (GameRunner.isMac()) {
            commands.add("-Dapple.laf.useScreenMenuBar=true");
            commands.add("-Xdock:name=\"TripleA\"");
            File icons = new File(GameRunner.getRootFolder(), "icons/triplea_icon.png");
            if (!icons.exists()) {
                throw new IllegalStateException("Icon file not found");
            }
            commands.add("-Xdock:icon=" + icons.getAbsolutePath() + "");
        }
        if ((version = System.getProperty("triplea.engine.version.bin")) != null && version.length() > 0) {
            try {
                Version testVersion = new Version(version);
                commands.add("-Dtriplea.engine.version.bin=" + testVersion.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setWidgetActivation() {
        boolean selected = this.m_gameTable.getSelectedRow() >= 0;
        this.m_joinGame.setEnabled(selected);
    }
}

