/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.ui;

import games.strategy.engine.lobby.client.ui.LobbyGameTableModel;
import games.strategy.net.GUID;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class LobbyGameTable
extends JTable {
    private static final long serialVersionUID = 8632519876114231003L;
    private GUID m_selectedGame;
    private boolean inTableChange = false;

    public LobbyGameTable(TableModel model) {
        super(model);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!LobbyGameTable.this.inTableChange) {
                    LobbyGameTable.this.markSelection();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableChanged(TableModelEvent e) {
        this.inTableChange = true;
        try {
            super.tableChanged(e);
        }
        finally {
            this.inTableChange = false;
        }
        this.restoreSelection();
    }

    private void markSelection() {
        int selected = this.getSelectedRow();
        this.m_selectedGame = selected >= 0 ? (GUID)this.getModel().getValueAt(selected, LobbyGameTableModel.Column.GUID.ordinal()) : null;
    }

    private void restoreSelection() {
        if (this.m_selectedGame == null) {
            return;
        }
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            GUID current = (GUID)this.getModel().getValueAt(i, LobbyGameTableModel.Column.GUID.ordinal());
            if (!current.equals(this.m_selectedGame)) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }
}

