/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server;

import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.engine.lobby.server.userDB.BannedIpController;
import games.strategy.engine.lobby.server.userDB.BannedMacController;
import games.strategy.engine.lobby.server.userDB.BannedUsernameController;
import games.strategy.engine.lobby.server.userDB.DBUser;
import games.strategy.engine.lobby.server.userDB.DBUserController;
import games.strategy.engine.lobby.server.userDB.MutedIpController;
import games.strategy.engine.lobby.server.userDB.MutedMacController;
import games.strategy.engine.lobby.server.userDB.MutedUsernameController;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.MessageContext;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import java.util.Date;
import java.util.TreeSet;
import java.util.logging.Logger;

public class ModeratorController
implements IModeratorController {
    protected static final Logger s_logger = Logger.getLogger(ModeratorController.class.getName());
    protected final IServerMessenger m_messenger;

    public static final RemoteName getModeratorControllerName() {
        return new RemoteName(IModeratorController.class, "games.strategy.engine.lobby.server.ModeratorController:Global");
    }

    public void register(IRemoteMessenger messenger) {
        messenger.registerRemote(this, ModeratorController.getModeratorControllerName());
    }

    public ModeratorController(IServerMessenger messenger) {
        this.m_messenger = messenger;
    }

    public void banUsername(INode node, Date banExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't ban an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new BannedUsernameController().addBannedUsername(this.getRealName(node), banExpires);
        String banUntil = banExpires == null ? "forever" : banExpires.toString();
        s_logger.info(DUtils.Format("User was banned from the lobby(Username ban). Username: {0} IP: {1} Mac: {2} Mod Username: {3} Mod IP: {4} Mod Mac: {5} Expires: {6}", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), banUntil));
    }

    public void banIp(INode node, Date banExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't ban an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new BannedIpController().addBannedIp(node.getAddress().getHostAddress(), banExpires);
        String banUntil = banExpires == null ? "forever" : banExpires.toString();
        s_logger.info(DUtils.Format("User was banned from the lobby(IP ban). Username: {0} IP: {1} Mac: {2} Mod Username: {3} Mod IP: {4} Mod Mac: {5} Expires: {6}", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), banUntil));
    }

    public void banMac(INode node, Date banExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't ban an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new BannedMacController().addBannedMac(mac, banExpires);
        String banUntil = banExpires == null ? "forever" : banExpires.toString();
        s_logger.info(DUtils.Format("User was banned from the lobby(Mac ban). Username: {0} IP: {1} Mac: {2} Mod Username: {3} Mod IP: {4} Mod Mac: {5} Expires: {6}", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), banUntil));
    }

    public void muteUsername(INode node, Date muteExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't mute an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new MutedUsernameController().addMutedUsername(this.getRealName(node), muteExpires);
        this.m_messenger.NotifyUsernameMutingOfPlayer(node.getAddress().getHostAddress(), muteExpires);
        String muteUntil = muteExpires == null ? "forever" : muteExpires.toString();
        s_logger.info(DUtils.Format("User was muted on the lobby(Username mute). Username: {0} IP: {1} Mac: {2} Mod Username: {3} Mod IP: {4} Mod Mac: {5} Expires: {6}", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), muteUntil));
    }

    public void muteIp(INode node, Date muteExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't mute an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new MutedIpController().addMutedIp(node.getAddress().getHostAddress(), muteExpires);
        this.m_messenger.NotifyIPMutingOfPlayer(node.getAddress().getHostAddress(), muteExpires);
        String muteUntil = muteExpires == null ? "forever" : muteExpires.toString();
        s_logger.info(DUtils.Format("User was muted on the lobby(IP mute). Username: {0} IP: {1} Mac: {2} Mod Username: {3} Mod IP: {4} Mod Mac: {5} Expires: {6}", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), muteUntil));
    }

    public void muteMac(INode node, Date muteExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't mute an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new MutedMacController().addMutedMac(mac, muteExpires);
        this.m_messenger.NotifyMacMutingOfPlayer(mac, muteExpires);
        String muteUntil = muteExpires == null ? "forever" : muteExpires.toString();
        s_logger.info(DUtils.Format("User was muted on the lobby(Mac mute). Username: {0} IP: {1} Mac: {2} Mod Username: {3} Mod IP: {4} Mod Mac: {5} Expires: {6}", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), muteUntil));
    }

    protected String getNodeMacAddress(INode node) {
        return this.m_messenger.GetPlayerMac(node.getName());
    }

    public void boot(INode node) {
        this.assertUserIsAdmin();
        if (this.m_messenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Cant boot server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        this.m_messenger.removeConnection(node);
        s_logger.info(DUtils.Format("User was booted from the lobby. Username: {0} IP: {1} Mac: {2} Mod Username: {3} Mod IP: {4} Mod Mac: {5}", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
    }

    void assertUserIsAdmin() {
        if (!this.isAdmin()) {
            throw new IllegalStateException("Not an admin");
        }
    }

    public boolean isAdmin() {
        INode node = MessageContext.getSender();
        return this.isPlayerAdmin(node);
    }

    public boolean isPlayerAdmin(INode node) {
        DBUserController controller = new DBUserController();
        String name = this.getRealName(node);
        DBUser user = controller.getUser(name);
        if (user == null) {
            return false;
        }
        return user.isAdmin();
    }

    protected String getRealName(INode node) {
        String name = node.getName().split(" ")[0];
        return name;
    }

    public String getInformationOn(INode node) {
        this.assertUserIsAdmin();
        TreeSet<String> aliases = new TreeSet<String>();
        for (INode currentNode : this.m_messenger.getNodes()) {
            if (!currentNode.getAddress().equals(node.getAddress())) continue;
            aliases.add(currentNode.getName());
        }
        String mac = this.getNodeMacAddress(node);
        StringBuilder builder = new StringBuilder();
        builder.append("Name: ").append(node.getName());
        builder.append("\r\nHost Name: ").append(node.getAddress().getHostName());
        builder.append("\r\nIP Address: ").append(node.getAddress().getHostAddress());
        builder.append("\r\nPort: ").append(node.getPort());
        builder.append("\r\nHashed Mac: ").append(mac != null && mac.startsWith("$1$MH$") ? mac.substring(6) : mac + " (Invalid)");
        builder.append("\r\nAliases: ").append(this.getAliasesFor(node));
        return builder.toString();
    }

    protected String getAliasesFor(INode node) {
        StringBuilder builder = new StringBuilder();
        String nodeMac = this.getNodeMacAddress(node);
        for (INode cur : this.m_messenger.getNodes()) {
            if (cur.equals(node) || cur.getName().equals("Admin") || !cur.getAddress().equals(node.getAddress()) && !this.getNodeMacAddress(cur).equals(nodeMac)) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(cur.getName());
        }
        if (builder.length() > 100) {
            return builder.toString().replace(", ", "\r\n");
        }
        return builder.toString();
    }

    public String setPassword(INode node, String hashedPassword) {
        this.assertUserIsAdmin();
        DBUserController controller = new DBUserController();
        DBUser user = controller.getUser(this.getRealName(node));
        if (user == null) {
            return "Can't set the password of an anonymous player";
        }
        if (user.isAdmin()) {
            return "Can't set the password of an admin";
        }
        controller.updateUser(user.getName(), user.getEmail(), hashedPassword, user.isAdmin());
        return null;
    }
}

