/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.ui;

import games.strategy.engine.lobby.server.userDB.Database;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DBExplorerPanel
extends JPanel {
    private static final long serialVersionUID = 7259741539317170247L;
    private JTable m_table;
    private JTextArea m_sql;
    private JButton m_execute;

    public DBExplorerPanel() {
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_execute = new JButton("Execute");
        this.m_sql = new JTextArea();
        this.m_sql.setText("select * from ta_users \n\nupdate ta_users set password = 'foo' where username = '1152218272375'\n\nselect * from ta_users where CAST(joined as DATE) < CAST('2008-11-12' AS DATE) \nselect * from bad_words \nselect * from banned_ips \n\ndelete from banned_ips where ip = '192.168.1.0'");
        this.m_table = new JTable();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_sql, "North");
        this.add((Component)new JScrollPane(this.m_table), "Center");
        this.add((Component)this.m_execute, "South");
    }

    private void setupListeners() {
        this.m_execute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBExplorerPanel.this.execute();
            }
        });
    }

    public static boolean isNotQuery(String sql) {
        return (sql = sql.toUpperCase().trim()).startsWith("INSERT") || sql.startsWith("UPDATE") || sql.startsWith("CREATE") || sql.startsWith("DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        Connection con = Database.getConnection();
        try {
            String sql = this.m_sql.getSelectedText();
            if (sql == null || sql.length() == 0) {
                sql = this.m_sql.getText();
            }
            Statement ps = con.createStatement();
            if (DBExplorerPanel.isNotQuery(sql)) {
                int rs = ps.executeUpdate(sql);
                DefaultTableModel model = new DefaultTableModel();
                model.addColumn("COUNT");
                model.addRow(new Object[]{rs});
                this.m_table.setModel(model);
            } else {
                ResultSet rs = ps.executeQuery(sql);
                TableModel model = DBExplorerPanel.createTableModel(rs);
                if (model != null) {
                    this.m_table.setModel(model);
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void setWidgetActivation() {
    }

    public static TableModel createTableModel(ResultSet rs) {
        try {
            DefaultTableModel model = new DefaultTableModel();
            ArrayList<String> columnNames = new ArrayList<String>();
            int count = rs.getMetaData().getColumnCount();
            if (count <= 0) {
                return null;
            }
            model.addColumn("Count");
            for (int i = 1; i <= count; ++i) {
                String columnName = rs.getMetaData().getColumnName(i);
                columnNames.add(columnName);
                model.addColumn(columnName);
            }
            int index = 1;
            while (rs.next()) {
                ArrayList<String> values = new ArrayList<String>();
                values.add("" + index++);
                for (String column : columnNames) {
                    values.add(rs.getString(column));
                }
                model.addRow(values.toArray());
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

