/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.ui;

import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.triplea.ui.MemoryLabel;
import java.awt.GridLayout;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LobbyAdminStatPanel
extends JPanel {
    private static final long serialVersionUID = 3737079270721494810L;
    private JLabel m_upSince;
    private JLabel m_maxPlayersLabel;
    private JLabel m_totalLoginsLabel;
    private JLabel m_currentLoginsLabel;
    private int m_maxPlayers;
    private int m_totalLogins;
    private int m_currentLogins;
    private final IMessenger m_messenger;

    public LobbyAdminStatPanel(IMessenger messenger) {
        this.m_messenger = messenger;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_currentLoginsLabel = new JLabel("Current Players: -----");
        this.m_maxPlayersLabel = new JLabel("Max Concurrent Players : ----");
        this.m_totalLoginsLabel = new JLabel("Total Logins : ------");
        this.m_upSince = new JLabel("Up since " + new Date());
    }

    private void layoutComponents() {
        this.setLayout(new GridLayout(5, 1));
        this.add(this.m_currentLoginsLabel);
        this.add(this.m_totalLoginsLabel);
        this.add(this.m_maxPlayersLabel);
        this.add(this.m_upSince);
        this.add(new MemoryLabel());
    }

    private void setupListeners() {
        ((IServerMessenger)this.m_messenger).addConnectionChangeListener(new IConnectionChangeListener(){

            public void connectionRemoved(INode to) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LobbyAdminStatPanel.this.m_currentLogins--;
                        LobbyAdminStatPanel.this.m_currentLoginsLabel.setText("Current Players: " + LobbyAdminStatPanel.this.m_currentLogins);
                    }
                });
            }

            public void connectionAdded(INode to) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LobbyAdminStatPanel.this.m_currentLogins++;
                        LobbyAdminStatPanel.this.m_currentLoginsLabel.setText("Current Players: " + LobbyAdminStatPanel.this.m_currentLogins);
                        if (LobbyAdminStatPanel.this.m_currentLogins > LobbyAdminStatPanel.this.m_maxPlayers) {
                            LobbyAdminStatPanel.this.m_maxPlayers = LobbyAdminStatPanel.this.m_currentLogins;
                            LobbyAdminStatPanel.this.m_maxPlayersLabel.setText("Max Concurrent Players : " + LobbyAdminStatPanel.this.m_maxPlayers);
                        }
                        LobbyAdminStatPanel.this.m_totalLogins++;
                        LobbyAdminStatPanel.this.m_totalLoginsLabel.setText("Total Logins : " + LobbyAdminStatPanel.this.m_totalLogins);
                    }
                });
            }
        });
    }

    private void setWidgetActivation() {
    }
}

