/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.pbem;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.engine.pbem.IForumPoster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;

public class PBEMMessagePoster
implements Serializable {
    public static final String FORUM_POSTER_PROP_NAME = "games.strategy.engine.pbem.IForumPoster";
    public static final String EMAIL_SENDER_PROP_NAME = "games.strategy.engine.pbem.IEmailSender";
    private static final long serialVersionUID = 2256265436928530566L;
    private IForumPoster m_forumPoster = null;
    private final IEmailSender m_emailSender;
    private transient File m_saveGameFile = null;
    private transient String m_turnSummary = null;
    private transient String m_saveGameRef = null;
    private transient String m_turnSummaryRef = null;
    private transient String m_emailSendStatus;
    private transient PlayerID m_currentPlayer;
    private transient int m_roundNumber;
    private transient String m_gameNameAndInfo;

    public PBEMMessagePoster(GameData gameData, PlayerID currentPlayer, int roundNumber) {
        this.m_currentPlayer = currentPlayer;
        this.m_roundNumber = roundNumber;
        this.m_forumPoster = (IForumPoster)gameData.getProperties().get(FORUM_POSTER_PROP_NAME);
        this.m_emailSender = (IEmailSender)gameData.getProperties().get(EMAIL_SENDER_PROP_NAME);
        this.m_gameNameAndInfo = "TripleA Turn Summary for game: " + gameData.getGameName() + ", version: " + gameData.getGameVersion();
    }

    public boolean hasMessengers() {
        return this.m_forumPoster != null || this.m_emailSender != null;
    }

    public void setForumPoster(IForumPoster msgr) {
        this.m_forumPoster = msgr;
    }

    public IForumPoster getForumPoster() {
        return this.m_forumPoster;
    }

    public void setTurnSummary(String turnSummary) {
        this.m_turnSummary = turnSummary;
    }

    public void setSaveGame(File saveGameFile) throws FileNotFoundException {
        this.m_saveGameFile = saveGameFile;
    }

    public String getTurnSummaryRef() {
        return this.m_turnSummaryRef;
    }

    public String getSaveGameRef() {
        return this.m_saveGameRef;
    }

    public boolean post(IDelegateHistoryWriter historyWriter) {
        boolean forumSuccess = true;
        StringBuilder saveGameSb = new StringBuilder().append("triplea_");
        if (this.m_forumPoster != null) {
            saveGameSb.append(this.m_forumPoster.getTopicId()).append("_");
        }
        saveGameSb.append(this.m_currentPlayer.getName().substring(0, 1)).append(this.m_roundNumber).append(".tsvg");
        String saveGameName = saveGameSb.toString();
        if (this.m_forumPoster != null) {
            if (this.m_forumPoster.getIncludeSaveGame()) {
                this.m_forumPoster.addSaveGame(this.m_saveGameFile, saveGameName);
            }
            try {
                forumSuccess = this.m_forumPoster.postTurnSummary(this.m_gameNameAndInfo + "\n\n" + this.m_turnSummary, "TripleA Turn Summary: " + this.m_currentPlayer.getName() + " round " + this.m_roundNumber);
                this.m_turnSummaryRef = this.m_forumPoster.getTurnSummaryRef();
                if (this.m_turnSummaryRef != null && historyWriter != null) {
                    historyWriter.startEvent("Turn Summary: " + this.m_turnSummaryRef);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean emailSuccess = true;
        if (this.m_emailSender != null) {
            StringBuilder subjectPostFix = new StringBuilder(this.m_currentPlayer.getName());
            subjectPostFix.append(" - ").append("round ").append(this.m_roundNumber);
            try {
                this.m_emailSender.sendEmail(subjectPostFix.toString(), this.convertToHtml(this.m_gameNameAndInfo + "\n\n" + this.m_turnSummary), this.m_saveGameFile, saveGameName);
                this.m_emailSendStatus = "Success, sent to " + this.m_emailSender.getToAddress();
            }
            catch (IOException e) {
                emailSuccess = false;
                this.m_emailSendStatus = "Failed! Error " + e.getMessage();
                e.printStackTrace();
            }
        }
        if (historyWriter != null) {
            StringBuilder sb = new StringBuilder("Post Turn Summary");
            if (this.m_forumPoster != null) {
                sb.append(" to ").append(this.m_forumPoster.getDisplayName()).append(" success = ").append(String.valueOf(forumSuccess));
            }
            if (this.m_emailSender != null) {
                if (this.m_forumPoster != null) {
                    sb.append(" and to ");
                } else {
                    sb.append(" to ");
                }
                sb.append(this.m_emailSender.getToAddress()).append(" success = ").append(String.valueOf(emailSuccess));
            }
            historyWriter.startEvent(sb.toString());
        }
        return forumSuccess && emailSuccess;
    }

    private String convertToHtml(String string) {
        return "<pre><br/>" + string.replaceAll("\n", "<br/>") + "<br/></pre>";
    }

    public IEmailSender getEmailSender() {
        return this.m_emailSender;
    }

    public String getEmailSendStatus() {
        return this.m_emailSendStatus;
    }
}

