/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.random.IRandomStats;
import games.strategy.engine.random.RandomStatsDetails;
import games.strategy.util.IntegerMap;

public class RandomStats
implements IRandomStats {
    private final IRemoteMessenger m_remoteMessenger;
    private final IntegerMap<Integer> m_randomStats = new IntegerMap();

    public RandomStats(IRemoteMessenger remoteMessenger) {
        this.m_remoteMessenger = remoteMessenger;
        remoteMessenger.registerRemote(this, RANDOM_STATS_REMOTE_NAME);
    }

    public void shutDown() {
        this.m_remoteMessenger.unregisterRemote(RANDOM_STATS_REMOTE_NAME);
    }

    public synchronized void addRandom(int[] random) {
        for (int i = 0; i < random.length; ++i) {
            this.m_randomStats.add((Integer)(random[i] + 1), 1);
        }
    }

    public synchronized void addRandom(int random) {
        this.m_randomStats.add((Integer)(random + 1), 1);
    }

    public synchronized RandomStatsDetails getRandomStats() {
        return new RandomStatsDetails(this.m_randomStats);
    }
}

