/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.kingstable;

import games.strategy.engine.data.DefaultUnitFactory;
import games.strategy.engine.data.IUnitFactory;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import games.strategy.kingstable.player.AbstractAI;
import games.strategy.kingstable.player.BetterAI;
import games.strategy.kingstable.player.IKingsTablePlayer;
import games.strategy.kingstable.player.KingsTablePlayer;
import games.strategy.kingstable.player.RandomAI;
import games.strategy.kingstable.ui.KingsTableFrame;
import games.strategy.kingstable.ui.display.IKingsTableDisplay;
import games.strategy.kingstable.ui.display.KingsTableDisplay;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KingsTable
implements IGameLoader {
    private static final long serialVersionUID = -4160546942612903442L;
    private transient KingsTableDisplay m_display;
    private transient IGame m_game;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";
    private static final String ALPHABETA_COMPUTER_PLAYER_TYPE = "\u03b1\u03b2 AI";
    public static boolean kingCanParticipateInCaptures;
    public static boolean cornerSquaresCanBeUsedToCapturePawns;
    public static boolean centerSquareCanBeUsedToCapturePawns;
    public static boolean cornerSquaresCanBeUsedToCaptureTheKing;
    public static boolean centerSquareCanBeUsedToCaptureTheKing;
    public static boolean edgeOfBoardCanBeUsedToCaptureTheKing;
    public static boolean kingCanBeCapturedLikeAPawn;

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> players = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            AbstractAI ai;
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                KingsTablePlayer player = new KingsTablePlayer(name, type);
                players.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                ai = new RandomAI(name, type);
                players.add(ai);
                continue;
            }
            if (type.equals(ALPHABETA_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.ALPHABETA);
                players.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return players;
    }

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, ALPHABETA_COMPUTER_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public void shutDown() {
        if (this.m_display != null) {
            this.m_game.removeDisplay(this.m_display);
            this.m_display.shutDown();
        }
    }

    @Override
    public void startGame(final IGame game, final Set<IGamePlayer> players) throws Exception {
        try {
            this.m_game = game;
            GameProperties properties = this.m_game.getData().getProperties();
            kingCanParticipateInCaptures = properties.get("King can participate in captures", true);
            cornerSquaresCanBeUsedToCapturePawns = properties.get("Corner squares can be used to capture pawns", true);
            centerSquareCanBeUsedToCapturePawns = properties.get("Center square can be used to capture pawns", false);
            cornerSquaresCanBeUsedToCaptureTheKing = properties.get("Corner squares can be used to capture the king", false);
            centerSquareCanBeUsedToCaptureTheKing = properties.get("Center square can be used to capture the king", true);
            edgeOfBoardCanBeUsedToCaptureTheKing = properties.get("Edge of board can be used to capture the king", false);
            kingCanBeCapturedLikeAPawn = properties.get("King can be captured like a pawn", false);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    final KingsTableFrame frame = new KingsTableFrame(game, players);
                    KingsTable.this.m_display = new KingsTableDisplay(frame);
                    KingsTable.this.m_game.addDisplay(KingsTable.this.m_display);
                    frame.setVisible(true);
                    KingsTable.this.connectPlayers(players, frame);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            frame.toFront();
                        }
                    });
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            e.printStackTrace();
            throw new IllegalStateException(e.getCause().getMessage());
        }
    }

    private void connectPlayers(Set<IGamePlayer> players, KingsTableFrame frame) {
        for (IGamePlayer player : players) {
            if (!(player instanceof KingsTablePlayer)) continue;
            ((KingsTablePlayer)player).setFrame(frame);
        }
    }

    @Override
    public Class<? extends IChannelSubscribor> getDisplayType() {
        return IKingsTableDisplay.class;
    }

    @Override
    public Class<? extends IRemote> getRemotePlayerType() {
        return IKingsTablePlayer.class;
    }

    @Override
    public IUnitFactory getUnitFactory() {
        return new DefaultUnitFactory();
    }
}

