/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.net.INode;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class Node
implements INode,
Externalizable {
    static final long serialVersionUID = -2908980662926959943L;
    private String m_name;
    private int m_port;
    private InetAddress m_address;
    public static final INode NULL_NODE;

    public Node() {
    }

    public Node(String name, InetSocketAddress address) {
        this.m_name = name;
        this.m_address = address.getAddress();
        this.m_port = address.getPort();
    }

    public Node(String name, InetAddress address, int port) {
        this.m_name = name;
        this.m_address = address;
        this.m_port = port;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return other.m_port == this.m_port && other.m_address.equals(this.m_address);
    }

    public int hashCode() {
        return 37 * this.m_port + this.m_address.hashCode();
    }

    public String toString() {
        return this.m_name + " port:" + this.m_port + " ip:" + this.m_address.getHostAddress();
    }

    public int getPort() {
        return this.m_port;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_name = in.readUTF();
        this.m_port = in.readInt();
        int length = in.read();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = in.readByte();
        }
        this.m_address = InetAddress.getByAddress(bytes);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.m_name);
        out.writeInt(this.m_port);
        out.write(this.m_address.getAddress().length);
        out.write(this.m_address.getAddress());
    }

    public int compareTo(INode o) {
        if (o == null) {
            return -1;
        }
        return this.m_name.compareToIgnoreCase(o.getName());
    }

    public static void main(String[] args) throws IOException {
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(sink);
        for (int i = 0; i < 1000; ++i) {
            out.writeObject(new Node("" + i, InetAddress.getLocalHost(), i));
        }
        out.close();
        System.out.println("1000 nodes is:" + sink.toByteArray().length);
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.m_address, this.m_port);
    }

    static {
        try {
            NULL_NODE = new Node("NULL", InetAddress.getLocalHost(), -1);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}

