/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import games.strategy.net.nio.IErrorReporter;
import games.strategy.net.nio.SocketReadData;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOReader {
    private static final Logger s_logger = Logger.getLogger(NIOReader.class.getName());
    private final LinkedBlockingQueue<SocketReadData> m_outputQueue = new LinkedBlockingQueue();
    private volatile boolean m_running = true;
    private final Map<SocketChannel, SocketReadData> m_reading = new ConcurrentHashMap<SocketChannel, SocketReadData>();
    private final IErrorReporter m_errorReporter;
    private final Selector m_selector;
    private final Object m_socketsToAddMutex = new Object();
    private final List<SocketChannel> m_socketsToAdd = new ArrayList<SocketChannel>();
    private long m_totalBytes;

    public NIOReader(IErrorReporter reporter, String threadSuffix) {
        this.m_errorReporter = reporter;
        try {
            this.m_selector = Selector.open();
        }
        catch (IOException e) {
            s_logger.log(Level.SEVERE, "Could not create Selector", e);
            throw new IllegalStateException(e);
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                NIOReader.this.loop();
            }
        }, "NIO Reader - " + threadSuffix);
        t.start();
    }

    public void shutDown() {
        this.m_running = false;
        try {
            this.m_selector.close();
        }
        catch (Exception e) {
            s_logger.log(Level.WARNING, "error closing selector", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SocketChannel channel) {
        Object object = this.m_socketsToAddMutex;
        synchronized (object) {
            this.m_socketsToAdd.add(channel);
            this.m_selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectNewChannels() {
        ArrayList<SocketChannel> toAdd = null;
        Object object = this.m_socketsToAddMutex;
        synchronized (object) {
            if (this.m_socketsToAdd.isEmpty()) {
                return;
            }
            toAdd = new ArrayList<SocketChannel>(this.m_socketsToAdd);
            this.m_socketsToAdd.clear();
        }
        for (SocketChannel channel : toAdd) {
            try {
                channel.register(this.m_selector, 1);
            }
            catch (ClosedChannelException e) {
                return;
            }
        }
    }

    private void loop() {
        while (this.m_running) {
            try {
                if (s_logger.isLoggable(Level.FINEST)) {
                    s_logger.finest("selecting...");
                }
                try {
                    this.m_selector.select();
                }
                catch (Exception e) {
                    s_logger.log(Level.INFO, "error reading selection", e);
                }
                if (!this.m_running) continue;
                this.selectNewChannels();
                Set<SelectionKey> selected = this.m_selector.selectedKeys();
                if (s_logger.isLoggable(Level.FINEST)) {
                    s_logger.finest("selected:" + selected.size());
                }
                Iterator<SelectionKey> iter = selected.iterator();
                while (iter.hasNext()) {
                    SocketChannel channel;
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isValid() && key.isReadable()) {
                        channel = (SocketChannel)key.channel();
                        SocketReadData packet = this.getReadData(channel);
                        if (s_logger.isLoggable(Level.FINEST)) {
                            s_logger.finest("reading packet:" + packet + " from:" + channel.socket().getRemoteSocketAddress());
                        }
                        try {
                            boolean done = packet.read(channel);
                            if (!done) continue;
                            this.m_totalBytes += (long)packet.size();
                            if (s_logger.isLoggable(Level.FINE)) {
                                String remote = "null";
                                Socket s = channel.socket();
                                SocketAddress sa = null;
                                if (s != null) {
                                    sa = s.getRemoteSocketAddress();
                                }
                                if (sa != null) {
                                    remote = sa.toString();
                                }
                                s_logger.log(Level.FINE, " done reading from:" + remote + " size:" + packet.size() + " readCalls;" + packet.getReadCalls() + " total:" + this.m_totalBytes);
                            }
                            this.enque(packet);
                        }
                        catch (Exception e) {
                            s_logger.log(Level.FINER, "exception reading", e);
                            key.cancel();
                            this.m_errorReporter.error(channel, e);
                        }
                        continue;
                    }
                    if (key.isValid()) continue;
                    s_logger.fine("Remotely closed");
                    channel = (SocketChannel)key.channel();
                    key.cancel();
                    this.m_errorReporter.error(channel, new SocketException("triplea:key cancelled"));
                }
            }
            catch (Exception e) {
                s_logger.log(Level.WARNING, "error in reader", e);
            }
        }
    }

    private void enque(SocketReadData packet) {
        this.m_reading.remove(packet.getChannel());
        this.m_outputQueue.offer(packet);
    }

    private SocketReadData getReadData(SocketChannel channel) {
        if (this.m_reading.containsKey(channel)) {
            return this.m_reading.get(channel);
        }
        SocketReadData packet = new SocketReadData(channel);
        this.m_reading.put(channel, packet);
        return packet;
    }

    public SocketReadData take() throws InterruptedException {
        return this.m_outputQueue.take();
    }

    public void closed(SocketChannel channel) {
        this.m_reading.remove(channel);
    }
}

