/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleAUnit
extends Unit {
    private static final long serialVersionUID = 8811372406957115036L;
    public static final String TRANSPORTED_BY = "transportedBy";
    public static final String UNLOADED = "unloaded";
    public static final String LOADED_THIS_TURN = "wasLoadedThisTurn";
    public static final String UNLOADED_TO = "unloadedTo";
    public static final String UNLOADED_IN_COMBAT_PHASE = "wasUnloadedInCombatPhase";
    public static final String ALREADY_MOVED = "alreadyMoved";
    public static final String BONUS_MOVEMENT = "bonusMovement";
    public static final String MOVEMENT_LEFT = "movementLeft";
    public static final String SUBMERGED = "submerged";
    public static final String ORIGINAL_OWNER = "originalOwner";
    public static final String WAS_IN_COMBAT = "wasInCombat";
    public static final String LOADED_AFTER_COMBAT = "wasLoadedAfterCombat";
    public static final String UNLOADED_AMPHIBIOUS = "wasAmphibious";
    public static final String ORIGINATED_FROM = "originatedFrom";
    public static final String WAS_SCRAMBLED = "wasScrambled";
    public static final String MAX_SCRAMBLE_COUNT = "maxScrambleCount";
    public static final String WAS_IN_AIR_BATTLE = "wasInAirBattle";
    public static final String UNIT_DAMAGE = "unitDamage";
    public static final String DISABLED = "disabled";
    public static final String LAUNCHED = "launched";
    public static final String AIRBORNE = "airborne";
    private TripleAUnit m_transportedBy = null;
    private List<Unit> m_unloaded = Collections.emptyList();
    private Boolean m_wasLoadedThisTurn = Boolean.FALSE;
    private Territory m_unloadedTo = null;
    private Boolean m_wasUnloadedInCombatPhase = Boolean.FALSE;
    private int m_alreadyMoved = 0;
    private int m_bonusMovement = 0;
    private int m_unitDamage = 0;
    private boolean m_submerged = false;
    private PlayerID m_originalOwner = null;
    private boolean m_wasInCombat = false;
    private boolean m_wasLoadedAfterCombat = false;
    private boolean m_wasAmphibious = false;
    private Territory m_originatedFrom = null;
    private boolean m_wasScrambled = false;
    private int m_maxScrambleCount = -1;
    private boolean m_wasInAirBattle = false;
    private boolean m_disabled = false;
    private int m_launched = 0;
    private boolean m_airborne = false;

    public static TripleAUnit get(Unit u) {
        return (TripleAUnit)u;
    }

    public TripleAUnit(UnitType type, PlayerID owner, GameData data) {
        super(type, owner, data);
    }

    public Unit getTransportedBy() {
        return this.m_transportedBy;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setTransportedBy(TripleAUnit transportedBy) {
        this.m_transportedBy = transportedBy;
    }

    public List<Unit> getTransporting() {
        for (Territory t : this.getData().getMap()) {
            if (!t.getUnits().getUnits().contains(this)) continue;
            return t.getUnits().getMatches(new Match<Unit>(){

                @Override
                public boolean match(Unit o) {
                    return TripleAUnit.get(o).getTransportedBy() == TripleAUnit.this;
                }
            });
        }
        return Collections.emptyList();
    }

    public List<Unit> getTransporting(Collection<Unit> transportedUnitsPossible) {
        return Match.getMatches(transportedUnitsPossible, new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                return TripleAUnit.get(o).getTransportedBy() == TripleAUnit.this;
            }
        });
    }

    public List<Unit> getUnloaded() {
        return this.m_unloaded;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setUnloaded(List<Unit> unloaded) {
        this.m_unloaded = unloaded == null || unloaded.isEmpty() ? Collections.emptyList() : new ArrayList<Unit>(unloaded);
    }

    public boolean getWasLoadedThisTurn() {
        return this.m_wasLoadedThisTurn;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setWasLoadedThisTurn(Boolean value) {
        this.m_wasLoadedThisTurn = (boolean)value;
    }

    public Territory getUnloadedTo() {
        return this.m_unloadedTo;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setUnloadedTo(Territory unloadedTo) {
        this.m_unloadedTo = unloadedTo;
    }

    public Territory getOriginatedFrom() {
        return this.m_originatedFrom;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setOriginatedFrom(Territory t) {
        this.m_originatedFrom = t;
    }

    public boolean getWasUnloadedInCombatPhase() {
        return this.m_wasUnloadedInCombatPhase;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setWasUnloadedInCombatPhase(Boolean value) {
        this.m_wasUnloadedInCombatPhase = (boolean)value;
    }

    public int getAlreadyMoved() {
        return this.m_alreadyMoved;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setAlreadyMoved(Integer alreadyMoved) {
        this.m_alreadyMoved = alreadyMoved;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setBonusMovement(Integer bonusMovement) {
        this.m_bonusMovement = bonusMovement;
    }

    public int getBonusMovement() {
        return this.m_bonusMovement;
    }

    public int getMaxMovementAllowed() {
        return Math.max(0, this.m_bonusMovement + UnitAttachment.get(this.getType()).getMovement(this.getOwner()));
    }

    public int getMovementLeft() {
        return Math.max(0, UnitAttachment.get(this.getType()).getMovement(this.getOwner()) + this.m_bonusMovement - this.m_alreadyMoved);
    }

    public int getUnitDamage() {
        return this.m_unitDamage;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setUnitDamage(Integer unitDamage) {
        this.m_unitDamage = unitDamage;
    }

    public boolean getSubmerged() {
        return this.m_submerged;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setSubmerged(boolean submerged) {
        this.m_submerged = submerged;
    }

    public PlayerID getOriginalOwner() {
        return this.m_originalOwner;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setOriginalOwner(PlayerID originalOwner) {
        this.m_originalOwner = originalOwner;
    }

    public boolean getWasInCombat() {
        return this.m_wasInCombat;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setWasInCombat(Boolean value) {
        this.m_wasInCombat = value;
    }

    public boolean getWasScrambled() {
        return this.m_wasScrambled;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setWasScrambled(Boolean value) {
        this.m_wasScrambled = value;
    }

    public int getMaxScrambleCount() {
        return this.m_maxScrambleCount;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setMaxScrambleCount(Integer value) {
        this.m_maxScrambleCount = value;
    }

    public int getLaunched() {
        return this.m_launched;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setLaunched(Integer value) {
        this.m_launched = value;
    }

    public boolean getAirborne() {
        return this.m_airborne;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setAirborne(Boolean value) {
        this.m_airborne = value;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setWasInAirBattle(Boolean value) {
        this.m_wasInAirBattle = value;
    }

    public boolean getWasInAirBattle() {
        return this.m_wasInAirBattle;
    }

    public boolean getWasLoadedAfterCombat() {
        return this.m_wasLoadedAfterCombat;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setWasLoadedAfterCombat(Boolean value) {
        this.m_wasLoadedAfterCombat = value;
    }

    public List<Unit> getDependents() {
        return this.getTransporting();
    }

    public Unit getDependentOf() {
        if (this.m_transportedBy != null) {
            return this.m_transportedBy;
        }
        return null;
    }

    public boolean getWasAmphibious() {
        return this.m_wasAmphibious;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setWasAmphibious(Boolean value) {
        this.m_wasAmphibious = value;
    }

    public boolean getDisabled() {
        return this.m_disabled;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setDisabled(Boolean value) {
        this.m_disabled = value;
    }

    public int getHowMuchMoreDamageCanThisUnitTake(Unit u, Territory t) {
        if (!Matches.UnitIsFactoryOrCanBeDamaged.match(u)) {
            return 0;
        }
        TripleAUnit taUnit = (TripleAUnit)u;
        if (Properties.getSBRAffectsUnitProduction(u.getData())) {
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta == null) {
                return 0;
            }
            int currentDamage = ta.getProduction() - ta.getUnitProduction();
            return 2 * ta.getProduction() - currentDamage;
        }
        if (Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(u.getData())) {
            return Math.max(0, this.getHowMuchDamageCanThisUnitTakeTotal(u, t) - taUnit.getUnitDamage());
        }
        return Integer.MAX_VALUE;
    }

    public int getHowMuchDamageCanThisUnitTakeTotal(Unit u, Territory t) {
        if (!Matches.UnitIsFactoryOrCanBeDamaged.match(u)) {
            return -1;
        }
        UnitAttachment ua = UnitAttachment.get(u.getType());
        TerritoryAttachment ta = TerritoryAttachment.get(t);
        int territoryProduction = 0;
        int territoryUnitProduction = 0;
        if (ta != null) {
            territoryProduction = ta.getProduction();
            territoryUnitProduction = ta.getUnitProduction();
        }
        if (Properties.getSBRAffectsUnitProduction(u.getData())) {
            return territoryProduction * 2;
        }
        if (Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(u.getData())) {
            if (ua.getMaxDamage() <= 0) {
                return territoryUnitProduction * 2;
            }
            if (Matches.UnitIsFactoryOrCanProduceUnits.match(u)) {
                if (ua.getCanProduceXUnits() < 0) {
                    return territoryUnitProduction * ua.getMaxDamage();
                }
                return ua.getMaxDamage();
            }
            return ua.getMaxDamage();
        }
        return Integer.MAX_VALUE;
    }

    public int getHowMuchCanThisUnitBeRepaired(Unit u, Territory t) {
        return Math.max(0, this.getHowMuchDamageCanThisUnitTakeTotal(u, t) - this.getHowMuchMoreDamageCanThisUnitTake(u, t));
    }

    public int getHowMuchShouldUnitBeRepairedToNotBeDisabled(Unit u, Territory t) {
        UnitAttachment ua = UnitAttachment.get(u.getType());
        int maxOperationalDamage = ua.getMaxOperationalDamage();
        if (maxOperationalDamage < 0) {
            return 0;
        }
        TripleAUnit taUnit = (TripleAUnit)u;
        int currentDamage = taUnit.getUnitDamage();
        return Math.max(0, currentDamage - maxOperationalDamage);
    }

    public static int getProductionPotentialOfTerritory(Collection<Unit> unitsAtStartOfStepInTerritory, Territory producer, PlayerID player, GameData data, boolean accountForDamage, boolean mathMaxZero) {
        return TripleAUnit.getHowMuchCanUnitProduce(TripleAUnit.getBiggestProducer(unitsAtStartOfStepInTerritory, producer, player, data, accountForDamage), producer, player, data, accountForDamage, mathMaxZero);
    }

    public static Unit getBiggestProducer(Collection<Unit> units, Territory producer, PlayerID player, GameData data, boolean accountForDamage) {
        List<Unit> factories = Match.getMatches(units, Matches.UnitIsOwnedAndIsFactoryOrCanProduceUnits(player));
        if (factories.isEmpty()) {
            return null;
        }
        IntegerMap<Unit> productionPotential = new IntegerMap<Unit>();
        Unit highestUnit = (Unit)factories.iterator().next();
        int highestCapacity = Integer.MIN_VALUE;
        for (Unit u : factories) {
            int capacity = TripleAUnit.getHowMuchCanUnitProduce(u, producer, player, data, accountForDamage, false);
            productionPotential.put(u, capacity);
            if (capacity <= highestCapacity) continue;
            highestCapacity = capacity;
            highestUnit = u;
        }
        return highestUnit;
    }

    public static int getHowMuchCanUnitProduce(Unit u, Territory producer, PlayerID player, GameData data, boolean accountForDamage, boolean mathMaxZero) {
        if (u == null) {
            return 0;
        }
        if (!Matches.UnitIsFactoryOrCanProduceUnits.match(u)) {
            return 0;
        }
        int productionCapacity = 0;
        UnitAttachment ua = UnitAttachment.get(u.getType());
        TripleAUnit taUnit = (TripleAUnit)u;
        TerritoryAttachment ta = TerritoryAttachment.get(producer);
        int territoryProduction = 0;
        int territoryUnitProduction = 0;
        if (ta != null) {
            territoryProduction = ta.getProduction();
            territoryUnitProduction = ta.getUnitProduction();
        }
        if (accountForDamage) {
            if (Properties.getSBRAffectsUnitProduction(data)) {
                productionCapacity = ua.getCanProduceXUnits() < 0 ? territoryUnitProduction : ua.getCanProduceXUnits() - (territoryProduction - territoryUnitProduction);
            } else if (Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
                productionCapacity = ua.getCanProduceXUnits() < 0 ? territoryUnitProduction - taUnit.getUnitDamage() : ua.getCanProduceXUnits() - taUnit.getUnitDamage();
            } else {
                productionCapacity = territoryProduction;
                if (productionCapacity < 1) {
                    productionCapacity = 1;
                }
            }
        } else {
            productionCapacity = ua.getCanProduceXUnits() < 0 && !Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data) ? territoryProduction : (ua.getCanProduceXUnits() < 0 && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data) ? territoryUnitProduction : ua.getCanProduceXUnits());
            if (productionCapacity < 1 && !Properties.getSBRAffectsUnitProduction(data) && !Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
                productionCapacity = 1;
            }
        }
        if (territoryProduction >= TechAbilityAttachment.getMinimumTerritoryValueForProductionBonus(player, data)) {
            productionCapacity += TechAbilityAttachment.getProductionBonus(u.getType(), player, data);
        }
        if (mathMaxZero) {
            return Math.max(0, productionCapacity);
        }
        return productionCapacity;
    }

    public static Change translateAttributesToOtherUnits(Unit unitGivingAttributes, Collection<Unit> unitsThatWillGetAttributes, Territory t) {
        int unitDamage;
        CompositeChange changes = new CompositeChange();
        TripleAUnit taUnit = (TripleAUnit)unitGivingAttributes;
        int combatDamage = taUnit.getHits();
        IntegerMap<Unit> hits = new IntegerMap<Unit>();
        if (combatDamage > 0) {
            for (Unit u : unitsThatWillGetAttributes) {
                hits.put(u, combatDamage);
            }
        }
        if (hits.size() > 0) {
            changes.add(ChangeFactory.unitsHit(hits));
        }
        if ((unitDamage = taUnit.getUnitDamage()) > 0) {
            for (Unit u : unitsThatWillGetAttributes) {
                TripleAUnit taNew = (TripleAUnit)u;
                int maxDamage = taNew.getHowMuchDamageCanThisUnitTakeTotal(u, t);
                int transferDamage = Math.max(0, Math.min(unitDamage, maxDamage));
                if (transferDamage <= 0) continue;
                changes.add(ChangeFactory.unitPropertyChange(u, transferDamage, UNIT_DAMAGE));
            }
        }
        return changes;
    }
}

